/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.chgvalidtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.service.btnservice.chgvalidtime.helper.OfferChgValidTimeServiceHelper;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferChgValidTimeMultiLangConstants;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.OfferVerifyResultEnum;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;

public class OfferChgValidTimeService {
    private OfferChgValidTimeServiceHelper changeOfferValidTimeHelper = OfferChgValidTimeServiceHelper.getInstance();

    public boolean isVisible(DynamicObject offerInfo) {
        OfferVerifyResult result = this.canExecute(Collections.singletonList(offerInfo.getLong("id")));
        return Objects.equals(result.getResultType(), OfferVerifyResultEnum.ALL_PASS.getCode());
    }

    public OfferVerifyResult canExecute(List<Long> offerIdList) {
        List<DynamicObject> offerInfoList = this.changeOfferValidTimeHelper.queryOfferByIdListForChgValidTime(offerIdList);
        OfferVerifyResult result = new OfferVerifyResult();
        ArrayList<Long> successIdList = new ArrayList<Long>(offerIdList.size());
        offerInfoList.forEach(offerInfo -> {
            boolean letterCanTurnValidConfig;
            if (!this.changeOfferValidTimeHelper.verifyAppFile((DynamicObject)offerInfo)) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.CHANGE_VALID_TIME_ERR_002, OfferChgValidTimeMultiLangConstants.appFileNotInProcessError());
                return;
            }
            OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatusByOffer((DynamicObject)offerInfo);
            if (letterStatus == OfferLetterStatus.NULL) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.CHANGE_VALID_TIME_ERR_003, OfferChgValidTimeMultiLangConstants.offerNotValidError());
                return;
            }
            if (letterStatus == OfferLetterStatus.ALR_DISCARD) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.CHANGE_VALID_TIME_ERR_008, OfferChgValidTimeMultiLangConstants.offerDiscardError());
                return;
            }
            if (!this.changeOfferValidTimeHelper.verifyReplyStatus((DynamicObject)offerInfo)) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.CHANGE_VALID_TIME_ERR_004, OfferChgValidTimeMultiLangConstants.offerHasBeenRefuseError());
                return;
            }
            if (letterStatus == OfferLetterStatus.PRE_GENERATE) {
                String changeLetterAuditStatus = offerInfo.getString("letterauditstatus");
                if (!(OfferAuditStatus.NULL.getCode().trim().equals(changeLetterAuditStatus) || HRStringUtils.equals((String)changeLetterAuditStatus, (String)"E") || HRStringUtils.equals((String)changeLetterAuditStatus, (String)"F"))) {
                    String billNo = offerInfo.getString("letterauditno");
                    result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.CHANGE_VALID_TIME_ERR_007, OfferChgValidTimeMultiLangConstants.hasProcessChangeLetterBill((String)billNo));
                    return;
                }
            }
            if (!this.changeOfferValidTimeHelper.verifyInductionStatus((DynamicObject)offerInfo)) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.CHANGE_VALID_TIME_ERR_006, OfferChgValidTimeMultiLangConstants.candidateInductionError());
                return;
            }
            OfferLetterDataStatus letterDataStatus = OfferStatusUtil.getLetterDataStatusByOffer((DynamicObject)offerInfo);
            if (letterDataStatus == OfferLetterDataStatus.NULL) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.CHANGE_VALID_TIME_ERR_009, OfferChgValidTimeMultiLangConstants.notValidOfferLetterError());
                return;
            }
            if (letterDataStatus == OfferLetterDataStatus.DEFAULT) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.CHANGE_VALID_TIME_ERR_009, OfferChgValidTimeMultiLangConstants.notValidOfferLetterError());
                return;
            }
            if (letterDataStatus == OfferLetterDataStatus.INVALID && !(letterCanTurnValidConfig = OfferParamConfigService.getInstance().getOfferLetterCanTurnValidConfig())) {
                result.recordFailInfoForBase((DynamicObject)offerInfo, OfferErrorEnum.CHANGE_VALID_TIME_ERR_009, OfferChgValidTimeMultiLangConstants.notValidOfferLetterError());
                return;
            }
            successIdList.add(offerInfo.getLong("id"));
        });
        result.setPassIds(successIdList);
        result.setResultType(successIdList.size(), offerInfoList.size());
        return result;
    }

    public static OfferChgValidTimeService getInstance() {
        return Instance.INSTANCE;
    }

    private OfferChgValidTimeService() {
    }

    private static class Instance {
        private static final OfferChgValidTimeService INSTANCE = new OfferChgValidTimeService();

        private Instance() {
        }
    }
}

