/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.chgvalidtime.helper;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tspr.common.constants.appfile.AppFileConstants;

public class OfferChgValidTimeServiceHelper {
    public boolean verifyPerm(DynamicObject offerInfo, String entityId) {
        DynamicObject busUnit = offerInfo.getDynamicObject("busunit");
        return OfferPermService.getInstance().verifyHasPerm("bar_chgvalidtime", entityId, (Long)busUnit.getLong("id"));
    }

    public boolean verifyAppFile(DynamicObject offerInfo) {
        DynamicObject appFile = offerInfo.getDynamicObject("appfile");
        String fileStatus = (String)appFile.get("filestatus");
        return HRStringUtils.equals((String)fileStatus, (String)AppFileConstants.APP_FILE_STATUS_IN) || HRStringUtils.equals((String)fileStatus, (String)AppFileConstants.APP_FILE_STATUS_TBEMP);
    }

    public boolean verifyReplyStatus(DynamicObject offerInfo) {
        OfferLetterReplyStatus replyStatus = OfferStatusUtil.getLetterReplyStatusByOffer((DynamicObject)offerInfo);
        return replyStatus != OfferLetterReplyStatus.ALR_REFUSE;
    }

    public boolean verifyInductionStatus(DynamicObject offerInfo) {
        DynamicObject appfile = offerInfo.getDynamicObject("appfile");
        return OfferUtils.checkAppFileInProcess((DynamicObject)appfile);
    }

    public List<DynamicObject> queryOfferByIdListForChgValidTime(List<Long> offerIdList) {
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"busunit", "appfile", "offerletter", "candidatename", "recruposi", "number", "status", "inductionstatus", "letterauditstatus", "letterauditno"});
        return Arrays.asList(OfferServiceHelper.getInstance().queryOfferByIdList(offerIdList, selectProperties));
    }

    public static OfferChgValidTimeServiceHelper getInstance() {
        return Instance.INSTANCE;
    }

    private OfferChgValidTimeServiceHelper() {
    }

    private static class Instance {
        private static final OfferChgValidTimeServiceHelper INSTANCE = new OfferChgValidTimeServiceHelper();

        private Instance() {
        }
    }
}

