/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.copy;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.offer.service.OfferBtnShowService;
import kd.tsc.tso.business.domain.offer.service.btnservice.save.OfferBaseSaveService;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.OfferBaseSubmitService;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferUniqueKeyUtils;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferCopyService {
    private static final Log log = LogFactory.getLog(OfferCopyService.class);
    private static final Map<String, Consumer<IDataModel>> SERVICE_MAP = Maps.newHashMapWithExpectedSize((int)8);

    public boolean isViewFromCopy(IFormView formView) {
        Object iscopy = formView.getFormShowParameter().getCustomParam("iscopy");
        return !HRObjectUtils.isEmpty((Object)iscopy) && (Boolean)iscopy != false;
    }

    public void initButtonForCopy(IFormView formView) {
        boolean submitBtnShow;
        if (!this.isViewFromCopy(formView)) {
            return;
        }
        ArrayList<String> showButtons = new ArrayList<String>();
        showButtons.add("bar_cancel");
        DynamicObject offerInfo = formView.getModel().getDataEntity(true);
        boolean saveBtnShow = OfferBaseSaveService.getInstance().isVisible(offerInfo);
        if (saveBtnShow) {
            showButtons.add("bar_save");
        }
        if (submitBtnShow = OfferBaseSubmitService.getInstance().isVisible(offerInfo)) {
            showButtons.add("bar_submit");
        }
        List<String> allButtons = OfferBtnShowService.allButtonForBase();
        allButtons.removeAll(showButtons);
        formView.setVisible(Boolean.TRUE, showButtons.toArray(new String[0]));
        formView.setVisible(Boolean.FALSE, allButtons.toArray(new String[0]));
    }

    public static void initOfferModel(IDataModel dataModel) {
        Consumer<IDataModel> iDataModelConsumer = SERVICE_MAP.get(dataModel.getDataEntityType().getName());
        if (iDataModelConsumer != null) {
            iDataModelConsumer.accept(dataModel);
        } else {
            dataModel.beginInit();
            dataModel.setValue("status", (Object)OfferStatus.PRE_APPLY.getCode());
            dataModel.setValue("applicant", (Object)TSCRequestContext.getUserId());
            dataModel.setValue("applytime", (Object)DateUtils.nowDateTime());
            String number = CodeRuleServiceHelper.readNumber((String)"tso_somk_offerbase", (DynamicObject)dataModel.getDataEntity(true), null);
            dataModel.setValue("number", (Object)number);
            dataModel.setValue("offerabandondesc", null);
            dataModel.setValue("offerabandontime", null);
            dataModel.setValue("offerabandonreason", null);
            dataModel.setValue("offerletter", null);
            dataModel.setValue("offerauditno", null);
            dataModel.setValue("billstatus", null);
            String primaryIndex = OfferUniqueKeyUtils.getPrimaryIndex((DynamicObject)dataModel.getDataEntity(true), (OfferUniqueKeyUtils.Strategy)OfferUniqueKeyUtils.Strategy.INIT);
            dataModel.setValue("pindexes", (Object)primaryIndex);
            dataModel.setValue("letterauditno", null);
            dataModel.setValue("letterauditstatus", null);
            dataModel.setValue("inductionstatus", null);
            dataModel.setValue("pemploymenttime", null);
            dataModel.endInit();
            Object clone = new CloneUtils(true, true).clone((IDataEntityBase)dataModel.getDataEntity());
            dataModel.createNewData(clone);
            dataModel.updateCache();
        }
    }

    private static void mkInitOfferModel(IDataModel dataModel) {
        dataModel.beginInit();
        dataModel.setValue("status", (Object)OfferStatus.PRE_APPLY.getCode());
        dataModel.setValue("applicant", (Object)TSCRequestContext.getUserId());
        dataModel.setValue("applytime", (Object)DateUtils.nowDateTime());
        String number = CodeRuleServiceHelper.readNumber((String)"tso_somk_offerbase", (DynamicObject)dataModel.getDataEntity(true), null);
        dataModel.setValue("number", (Object)number);
        dataModel.setValue("offerabandondesc", null);
        dataModel.setValue("offerabandontime", null);
        dataModel.setValue("offerabandonreason", null);
        dataModel.setValue("offerletter", null);
        dataModel.setValue("offerauditno", null);
        dataModel.setValue("billstatus", null);
        String primaryIndex = OfferUniqueKeyUtils.getPrimaryIndex((DynamicObject)dataModel.getDataEntity(true), (OfferUniqueKeyUtils.Strategy)OfferUniqueKeyUtils.Strategy.INIT);
        dataModel.setValue("pindexes", (Object)primaryIndex);
        dataModel.setValue("letterauditno", null);
        dataModel.setValue("letterauditstatus", null);
        dataModel.setValue("pemploymenttime", null);
        dataModel.setValue("inductionstatus", null);
        dataModel.setValue("salarystatus", (Object)"A");
        dataModel.endInit();
        Object clone = new CloneUtils(true, true).clone((IDataEntityBase)dataModel.getDataEntity());
        dataModel.createNewData(clone);
        dataModel.updateCache();
    }

    public static OfferCopyService getInstance() {
        return Instance.INSTANCE;
    }

    static {
        SERVICE_MAP.put("tso_somk_offerbaseinfo", OfferCopyService::mkInitOfferModel);
    }

    private static class Instance {
        private static OfferCopyService INSTANCE = new OfferCopyService();

        private Instance() {
        }
    }
}

