/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.delayreply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.bo.oprecord.OfferLetterDelayReplyBO;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.delayreply.helper.OfferDelayReplyHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDelayedReplyMultiLangConstants;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.util.OfferUtils;
import org.apache.commons.collections.CollectionUtils;

public class OfferDelayReplyService {
    private static final Log logger = LogFactory.getLog(OfferDelayReplyService.class);
    private OfferDelayReplyHelper delayReplyHelper = OfferDelayReplyHelper.getInstance();

    public boolean isVisible(DynamicObject dynamicObject) {
        return this.delayReplyHelper.verifyAppFile(dynamicObject) && this.delayReplyHelper.verifyStatus(dynamicObject);
    }

    public OfferVerifyResult canExecute(List<Long> offerIdList) {
        List<DynamicObject> offerInfoList = this.delayReplyHelper.getOfferByIdListForDelayReply(offerIdList);
        if (offerInfoList == null || offerInfoList.isEmpty()) {
            throw new KDBizException("offerInfoList cannot be null");
        }
        OfferVerifyResult result = new OfferVerifyResult();
        ArrayList passOffer = new ArrayList(offerInfoList.size());
        offerInfoList.forEach(offer -> {
            if (!this.delayReplyHelper.verifyAppFile((DynamicObject)offer)) {
                result.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.DELAY_REPLY_ERR_002, OfferDelayedReplyMultiLangConstants.appFileNotInProcessError());
                return;
            }
            if (!this.delayReplyHelper.verifyLetterStatus((DynamicObject)offer)) {
                result.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.DELAY_REPLY_ERR_003, OfferDelayedReplyMultiLangConstants.replyStatusError());
                return;
            }
            if (!this.delayReplyHelper.verifyLetterReplyStatus((DynamicObject)offer)) {
                result.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.DELAY_REPLY_ERR_003, OfferDelayedReplyMultiLangConstants.replyStatusError());
                return;
            }
            if (this.delayReplyHelper.verifyLetterReplyStatusEqualsAlrOutTime((DynamicObject)offer) && !this.delayReplyHelper.verifyLetterDataStatus((DynamicObject)offer)) {
                result.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.DELAY_REPLY_ERR_004, OfferDelayedReplyMultiLangConstants.dataStatusError());
                return;
            }
            if (this.delayReplyHelper.verifyLatestApplyDate((DynamicObject)offer)) {
                result.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.DELAY_REPLY_ERR_005, OfferDelayedReplyMultiLangConstants.lastReplyDateError());
                return;
            }
            passOffer.add(offer);
        });
        result.setPassIds(OfferUtils.getOfferIdListByDts(passOffer));
        result.setResultType(passOffer.size(), offerIdList.size());
        return result;
    }

    public boolean delayReply(List<Long> offerIdList, OfferLetterDelayReplyBO commonBo) {
        if (CollectionUtils.isEmpty(offerIdList)) {
            logger.error("offerIdList is empty");
            return false;
        }
        if (commonBo == null) {
            logger.error("commonBo is null");
            return false;
        }
        List<DynamicObject> offerList = this.delayReplyHelper.getOfferByOfferId(offerIdList);
        List<DynamicObject> offerLetterList = this.delayReplyHelper.getOfferLetterByOfferForDelayReply(offerList);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                offerLetterList.stream().forEach(offerLetter -> {
                    offerLetter.set("letterstatus", (Object)OfferLetterStatus.ALR_DISCARD.getCode());
                    offerLetter.set("datastatus", (Object)OfferLetterDataStatus.INVALID.getCode());
                    OfferUtils.updateModifyInfo((DynamicObject)offerLetter);
                });
                OfferLetterServiceHelper.getInstance().update(offerLetterList.toArray(new DynamicObject[0]));
                Set appfileIdSet = offerList.stream().filter(dy -> dy.getLong("appfile.id") != 0L).map(dy -> dy.getLong("appfile.id")).collect(Collectors.toSet());
                HRBaseServiceHelper appfileServiceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
                QFilter qFilter = new QFilter("id", "in", appfileIdSet);
                DynamicObject[] appfileDys = appfileServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
                Map offerToAppfileMaps = Arrays.stream(appfileDys).collect(Collectors.toMap(dy -> dy.getLong("offer.id"), Function.identity()));
                ArrayList<DynamicObject> newOfferLetterList = new ArrayList<DynamicObject>(offerList.size());
                ArrayList<DynamicObject> newAppFileList = new ArrayList<DynamicObject>(offerList.size());
                for (DynamicObject offer : offerList) {
                    DynamicObject offerLetter2 = OfferLetterServiceHelper.getInstance().generateNewOfferLetter(offer);
                    offerLetter2.set("lastreplytime", (Object)commonBo.getLastReplyTime());
                    offerLetter2.set("delayreplaydesc", (Object)commonBo.getDelaySendDesc());
                    offerLetter2.set("lastreasonsign", (Object)"delayreplaydesc");
                    offerLetter2.set("datastatus", (Object)OfferLetterDataStatus.DEFAULT.getCode());
                    offer.set("offerletter", (Object)offerLetter2);
                    newOfferLetterList.add(offerLetter2);
                    DynamicObject appfileDy = (DynamicObject)offerToAppfileMaps.get(offer.getLong("id"));
                    appfileDy.set("offerletter_id", (Object)offerLetter2.getLong("id"));
                    newAppFileList.add(appfileDy);
                }
                OfferLetterServiceHelper.getInstance().save(newOfferLetterList.toArray(new DynamicObject[0]));
                OfferServiceHelper.getInstance().update(offerList.toArray(new DynamicObject[0]));
                appfileServiceHelper.update(newAppFileList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.error("\u3010delayReplyOfferLetter\u3011error :", (Throwable)e);
                boolean bl = false;
                if (txHandle != null) {
                    if (var6_6 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    public static OfferDelayReplyService getInstance() {
        return Instance.INSTANCE;
    }

    private OfferDelayReplyService() {
    }

    private static class Instance {
        private static final OfferDelayReplyService INSTANCE = new OfferDelayReplyService();

        private Instance() {
        }
    }
}

