/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.delayreply.helper;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferDelayReplyHelper {
    private static final Log LOG = LogFactory.getLog(OfferDelayReplyHelper.class);

    public boolean verifyPerm(DynamicObject dynamicObject) {
        Long busUnitId = dynamicObject.getDynamicObject("busunit").getLong("id");
        return OfferPermService.getInstance().verifyHasPerm("bar_delayedreply", "tso_somk_offerbase", busUnitId);
    }

    public boolean verifyAppFile(DynamicObject offerInfo) {
        DynamicObject appFile = offerInfo.getDynamicObject("appfile");
        return OfferUtils.checkAppFileInProcess((DynamicObject)appFile);
    }

    public boolean verifyStatus(DynamicObject dynamicObject) {
        return this.verifyLetterStatus(dynamicObject) && this.verifyLetterReplyStatus(dynamicObject) && this.verifyLetterDataStatus(dynamicObject);
    }

    public boolean verifyLetterDataStatus(DynamicObject dynamicObject) {
        OfferLetterDataStatus letterDataStatus = OfferStatusUtil.getLetterDataStatusByOffer((DynamicObject)dynamicObject);
        if (letterDataStatus == OfferLetterDataStatus.INVALID) {
            return OfferParamConfigService.getInstance().getOfferLetterCanTurnValidConfig();
        }
        return letterDataStatus == OfferLetterDataStatus.TAKE_EFFECT;
    }

    public boolean verifyLetterReplyStatus(DynamicObject dynamicObject) {
        OfferLetterReplyStatus letterReplyStatus = OfferStatusUtil.getLetterReplyStatusByOffer((DynamicObject)dynamicObject);
        return letterReplyStatus == OfferLetterReplyStatus.PRE_REPLY || letterReplyStatus == OfferLetterReplyStatus.ALR_OUTTIME;
    }

    public boolean verifyLetterReplyStatusEqualsAlrOutTime(DynamicObject dynamicObject) {
        OfferLetterReplyStatus letterReplyStatus = OfferStatusUtil.getLetterReplyStatusByOffer((DynamicObject)dynamicObject);
        return letterReplyStatus == OfferLetterReplyStatus.ALR_OUTTIME;
    }

    public boolean verifyLetterStatus(DynamicObject dynamicObject) {
        OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatusByOffer((DynamicObject)dynamicObject);
        return letterStatus == OfferLetterStatus.ALR_SEND;
    }

    public List<DynamicObject> getOfferByIdListForDelayReply(List<Long> offerIdList) {
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"appfile", "busunit", "offerletter", "recruposi", "candidatename", "modifier", "modifytime", "letterauditstatus", "status", "number", "name", "letterauditno"});
        QFilter qFilter = new QFilter("id", "in", offerIdList);
        return Arrays.asList(OfferServiceHelper.getInstance().query(selectProperties, qFilter.toArray()));
    }

    public List<DynamicObject> getOfferLetterByOfferForDelayReply(List<DynamicObject> offerList) {
        List offerLetterIdList = offerList.stream().map(offer -> offer.getDynamicObject("offerletter").getLong("id")).collect(Collectors.toList());
        OfferLetterServiceHelper letterServiceHelper = OfferLetterServiceHelper.getInstance();
        QFilter qFilter = new QFilter("id", "in", offerLetterIdList);
        String selectProperties = letterServiceHelper.getLetterSelectProperties();
        return Arrays.asList(letterServiceHelper.query(selectProperties, qFilter.toArray()));
    }

    public List<DynamicObject> getOfferByOfferId(List<Long> offerIdList) {
        QFilter qFilter = new QFilter("id", "in", offerIdList);
        return Arrays.asList(OfferServiceHelper.getInstance().loadDynamicObjectArray(qFilter.toArray()));
    }

    public boolean verifyLatestApplyDate(DynamicObject offerInfo) {
        if (HRObjectUtils.isEmpty((Object)offerInfo)) {
            return false;
        }
        DynamicObject letterDt = offerInfo.getDynamicObject("offerletter");
        if (HRObjectUtils.isEmpty((Object)letterDt)) {
            return false;
        }
        Date lastReplyDate = letterDt.getDate("lastreplytime");
        if (lastReplyDate == null) {
            return false;
        }
        Date newLastReplyDate = HRDateTimeUtils.addDay((Date)HRDateTimeUtils.curUserDateBos((Long)TSCRequestContext.getUserId()), (long)OfferParamConfigService.getInstance().getLastReplyTimeConfig());
        return DateUtils.compareDate((Date)(lastReplyDate = DateUtils.convertDate2UserDate((Date)lastReplyDate)), (Date)newLastReplyDate);
    }

    public static OfferDelayReplyHelper getInstance() {
        return Instance.INSTANCE;
    }

    private OfferDelayReplyHelper() {
    }

    private static class Instance {
        private static OfferDelayReplyHelper INSTANCE = new OfferDelayReplyHelper();

        private Instance() {
        }
    }
}

