/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.delaysend;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tso.business.domain.offer.bo.OfferDelaySendBO;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.service.SyncOfferStatusToAppFileService;
import kd.tsc.tso.business.domain.offer.service.btnservice.delaysend.helper.OfferDelaySendHelper;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDelaySendMultiLanConstants;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.util.OfferUtils;
import org.apache.commons.collections.CollectionUtils;

public class OfferDelaySendService {
    private static final Log logger = LogFactory.getLog(OfferDelaySendService.class);
    private OfferDelaySendHelper delaySendHelper = OfferDelaySendHelper.getInstance();

    public boolean isVisible(DynamicObject dynamicObject) {
        return this.delaySendHelper.verifyAppFile(dynamicObject) && this.delaySendHelper.verifyStatus(dynamicObject);
    }

    public OfferVerifyResult canExecute(List<Long> offerIdList) {
        List<DynamicObject> offerInfoList = this.delaySendHelper.getOfferByIdListForDelaySend(offerIdList);
        if (offerInfoList == null || offerInfoList.isEmpty()) {
            throw new KDBizException("offerInfoList cannot be null");
        }
        OfferVerifyResult result = new OfferVerifyResult();
        ArrayList<DynamicObject> passOffer = new ArrayList<DynamicObject>(offerInfoList.size());
        offerInfoList.forEach(offer -> {
            if (!this.delaySendHelper.verifyAppFile((DynamicObject)offer)) {
                result.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.DELAY_SEND_ERR_002, OfferDelaySendMultiLanConstants.appFileNotInProcessError());
                return;
            }
            if (!this.delaySendHelper.verifyStatus((DynamicObject)offer)) {
                result.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.DELAY_SEND_ERR_003, OfferDelaySendMultiLanConstants.statusIsWrongError());
                return;
            }
            passOffer.add((DynamicObject)offer);
        });
        if (!this.delaySendHelper.verifyListHaveSameLastSendTime(passOffer)) {
            OfferVerifyResult verifyResult = new OfferVerifyResult();
            offerInfoList.forEach(offer -> verifyResult.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.DELAY_SEND_ERR_005, OfferDelaySendMultiLanConstants.notSameLastSendTimeError()));
            return verifyResult;
        }
        result.setPassIds(OfferUtils.getOfferIdListByDts(passOffer));
        result.setResultType(passOffer.size(), offerIdList.size());
        return result;
    }

    public boolean delaySend(List<Long> offerIdList, OfferDelaySendBO commonBo, String operateName) {
        if (CollectionUtils.isEmpty(offerIdList)) {
            logger.error("offerIdList is empty");
            return false;
        }
        if (commonBo == null) {
            logger.error("commonBo is null");
            return false;
        }
        List<DynamicObject> offerLetterList = this.delaySendHelper.getOfferLetterByOfferIdForDelaySend(offerIdList);
        List<DynamicObject> offerInfoList = this.delaySendHelper.getOfferByIdListForDelaySend(offerIdList);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.delaySendHelper.updateLetter(offerLetterList, commonBo.getLastSendTime(), commonBo.getDelaySendDesc());
                OfferGenOpRecordService.getInstance().genDelaySendOpRecord(offerInfoList, operateName, commonBo.getLastSendTime(), commonBo.getDelaySendDesc());
                SyncOfferStatusToAppFileService.syncOfferStatusToAppFile(offerInfoList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.error("\u3010delaySendOffer\u3011error :", (Throwable)e);
                boolean bl = false;
                if (txHandle != null) {
                    if (var7_7 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    public static OfferDelaySendService getInstance() {
        return Instance.INSTANCE;
    }

    private OfferDelaySendService() {
    }

    private static class Instance {
        private static final OfferDelaySendService INSTANCE = new OfferDelaySendService();

        private Instance() {
        }
    }
}

