/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.delaysend.helper;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import org.apache.commons.lang3.time.DateUtils;

public class OfferDelaySendHelper {
    public boolean verifyPerm(DynamicObject dynamicObject) {
        Long busUnitId = dynamicObject.getDynamicObject("busunit").getLong("id");
        return OfferPermService.getInstance().verifyHasPerm("bar_delaysend", "tso_somk_offerbase", busUnitId);
    }

    public boolean verifyAppFile(DynamicObject dynamicObject) {
        DynamicObject appFile = dynamicObject.getDynamicObject("appfile");
        return OfferUtils.checkAppFileInProcess((DynamicObject)appFile);
    }

    public boolean verifyStatus(DynamicObject dynamicObject) {
        OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatusByOffer((DynamicObject)dynamicObject);
        return letterStatus == OfferLetterStatus.PRE_SEND || letterStatus == OfferLetterStatus.NOSEND_OUTTIME;
    }

    public boolean verifyListHaveSameLastSendTime(List<DynamicObject> offerInfoList) {
        if (offerInfoList.isEmpty()) {
            return true;
        }
        if (offerInfoList.size() == 1) {
            return true;
        }
        DynamicObject offerLetter = offerInfoList.get(0).getDynamicObject("offerletter");
        Date lastSendTime = Optional.ofNullable(offerLetter.getDate("lastsendtime")).orElseGet(() -> DateUtils.addDays((Date)new Date(), (int)-1));
        for (int i = 1; i < offerInfoList.size(); ++i) {
            DynamicObject letter = offerInfoList.get(i).getDynamicObject("offerletter");
            Date lastSendTimeTemp = Optional.ofNullable(letter.getDate("lastsendtime")).orElseGet(() -> DateUtils.addDays((Date)new Date(), (int)-1));
            if (DateUtils.isSameDay((Date)lastSendTimeTemp, (Date)lastSendTime)) continue;
            return false;
        }
        return true;
    }

    public void updateLetter(List<DynamicObject> letterList, Object lastSendTime, Object delaySendDesc) {
        letterList.forEach(letter -> {
            letter.set("lastsendtime", lastSendTime);
            letter.set("delaydesc", delaySendDesc);
            letter.set("lastreasonsign", (Object)"delaydesc");
            OfferUtils.updateModifyInfo((DynamicObject)letter);
            letter.set("letterstatus", (Object)OfferLetterStatus.PRE_SEND.getCode());
        });
        OfferLetterServiceHelper.getInstance().update(letterList.toArray(new DynamicObject[0]));
    }

    public List<DynamicObject> getOfferByIdListForDelaySend(List<Long> offerIdList) {
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"appfile", "busunit", "offerletter", "recruposi", "candidatename", "modifier", "modifytime", "offerletter", "status", "number", "name"});
        QFilter qFilter = new QFilter("id", "in", offerIdList);
        return Arrays.asList(OfferServiceHelper.getInstance().query(selectProperties, qFilter.toArray()));
    }

    public List<DynamicObject> getOfferLetterByOfferIdForDelaySend(List<Long> offerIdList) {
        OfferLetterServiceHelper letterServiceHelper = OfferLetterServiceHelper.getInstance();
        QFilter qFilter = new QFilter("offer", "in", offerIdList);
        qFilter.and(new QFilter("datastatus", "in", Arrays.asList(OfferLetterDataStatus.DEFAULT.getCode(), OfferLetterDataStatus.NULL.getCode())));
        String selectProperties = letterServiceHelper.getLetterSelectProperties();
        return Arrays.asList(letterServiceHelper.query(selectProperties, qFilter.toArray()));
    }

    public static OfferDelaySendHelper getInstance() {
        return Instance.INSTANCE;
    }

    private OfferDelaySendHelper() {
    }

    private static class Instance {
        private static OfferDelaySendHelper INSTANCE = new OfferDelaySendHelper();

        private Instance() {
        }
    }
}

