/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.delete;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterBillHelper;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterValidHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.delete.helper.LetterChangeBillDeleteHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDeleteMultiLangConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class LetterChangeBillDeleteService {
    private Log logger = LogFactory.getLog(LetterChangeBillDeleteService.class);
    private LetterChangeBillDeleteHelper billDeleteHelper = LetterChangeBillDeleteHelper.getInstance();
    private final OfferServiceHelper offerHelper = OfferServiceHelper.getInstance();

    public String checkCondition(DynamicObject changeLetterBillInfo) {
        long offerId = changeLetterBillInfo.getLong("offer.id");
        DynamicObject offerObj = this.offerHelper.loadSingle(offerId);
        if (!this.billDeleteHelper.verifyPerm(offerObj)) {
            return OfferDeleteMultiLangConstants.noLetterChangeBillPermError();
        }
        DynamicObject[] editObjs = OfferEditMutexHelper.checkOfferIsEditing(Lists.newArrayList((Object[])new Long[]{offerObj.getLong("id")}));
        if (editObjs != null && editObjs.length > 0) {
            return MessageFormat.format(OfferMultilingualConstants.offerIsEditing(), editObjs[0].getString("user.name"));
        }
        if (changeLetterBillInfo.getBoolean("deletestatus")) {
            return OfferDeleteMultiLangConstants.noLetterChangeBill();
        }
        if (!this.billDeleteHelper.verifyStatus(changeLetterBillInfo)) {
            return OfferDeleteMultiLangConstants.letterChangeBillStatusError();
        }
        return null;
    }

    public void deleteBill(DynamicObject changeLetterBillInfo) {
        changeLetterBillInfo = ChangeLetterBillHelper.getInstance().queryOne(changeLetterBillInfo.get("id"));
        changeLetterBillInfo.set("deletestatus", (Object)DeleteEnum.PRE_DELETE.getCode());
        long validId = changeLetterBillInfo.getLong("changelettervalid.id");
        DynamicObject letterValidInfo = ChangeLetterValidHelper.getInstance().queryOne(validId);
        letterValidInfo.set("isdelete", (Object)DeleteEnum.PRE_DELETE.getCode());
        long offerId = changeLetterBillInfo.getLong("offer.id");
        DynamicObject offerInfo = this.offerHelper.loadSingle(offerId);
        offerInfo.set("letterauditno", (Object)"");
        offerInfo.set("letterauditstatus", (Object)OfferAuditStatus.NULL.getCode());
        try (TXHandle tx = TX.required();){
            try {
                OfferBillServiceHelper.getInstance().updateOne(changeLetterBillInfo);
                OfferServiceHelper.getInstance().updateOne(offerInfo);
                ChangeLetterValidHelper.getInstance().updateOne(letterValidInfo);
            }
            catch (Exception e) {
                this.logger.error("\u3010LetterChangeBillDeleteService\u3011\"deleteBill\" error :", (Throwable)e);
                tx.markRollback();
            }
        }
    }

    public static LetterChangeBillDeleteService getInstance() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final LetterChangeBillDeleteService INSTANCE = new LetterChangeBillDeleteService();

        private Instance() {
        }
    }
}

