/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.delete;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.bo.VerifyOfferFailedInfo;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.SyncOfferStatusToAppFileService;
import kd.tsc.tso.business.domain.offer.service.btnservice.delete.helper.OfferDeleteHelper;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDeleteMultiLangConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tspr.business.domain.mq.producer.ProducerExecution;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class OfferBaseDeleteService {
    private Log logger = LogFactory.getLog(OfferBaseDeleteService.class);
    private OfferDeleteHelper deleteHelper = OfferDeleteHelper.getInstance();

    public OfferVerifyResult canExecute(List<Long> offerIdList) {
        List<DynamicObject> offerInfoList = this.deleteHelper.getOfferByIdList(offerIdList);
        OfferVerifyResult offerVerifyResult = new OfferVerifyResult();
        ArrayList<DynamicObject> passVerifyOffers = new ArrayList<DynamicObject>(offerInfoList.size());
        offerInfoList.forEach(offer -> {
            if (!this.deleteHelper.verifyStatus((DynamicObject)offer)) {
                offerVerifyResult.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.DELETE_ERR_002, OfferDeleteMultiLangConstants.statusWrongError());
                return;
            }
            passVerifyOffers.add((DynamicObject)offer);
        });
        List<Long> noMutexOfferIds = this.verifyIfOfferIsEdit(passVerifyOffers, offerVerifyResult);
        offerVerifyResult.setResultType(noMutexOfferIds.size(), offerInfoList.size());
        offerVerifyResult.setPassIds(noMutexOfferIds);
        return offerVerifyResult;
    }

    private void syncOfferStatusToAppFile(DynamicObject[] offerInfoArr) {
        Map<Long, List<DynamicObject>> map = OfferServiceHelper.getInstance().checkHasOldOfferWhenDelete(offerInfoArr);
        Arrays.stream(offerInfoArr).forEach(offerInfo -> {
            long appFileId = offerInfo.getDynamicObject("appfile").getLong("id");
            List dynamicObjectList = (List)map.get(appFileId);
            if (dynamicObjectList == null || dynamicObjectList.isEmpty()) {
                offerInfo.set("status", null);
            } else {
                OfferStatus offerStatus;
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectList.get(0);
                OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatusByOffer((DynamicObject)dynamicObject);
                Long statusId = letterStatus == OfferLetterStatus.ALR_SEND ? OfferStatusUtil.getLetterReplyStatusByOffer((DynamicObject)dynamicObject).getCode() : ((offerStatus = OfferStatusUtil.getOfferStatus((DynamicObject)dynamicObject)) == OfferStatus.APPLY_PASS ? letterStatus.getCode() : offerStatus.getCode());
                offerInfo.set("status", (Object)statusId);
            }
        });
        SyncOfferStatusToAppFileService.syncOfferStatusToAppFile(offerInfoArr);
    }

    private List<Long> verifyIfOfferIsEdit(List<DynamicObject> offerInfos, OfferVerifyResult offerVerifyResult) {
        List offerIdList = OfferUtils.getOfferIdListByDts(offerInfos);
        DynamicObject[] mutexDts = OfferEditMutexHelper.checkOfferIsEditing(offerIdList);
        ArrayList hasMutexOfferIdList = new ArrayList(offerInfos.size());
        ((Stream)Arrays.stream(mutexDts).parallel()).forEach(dynamicObject -> {
            long hasMutexOfferId = dynamicObject.getLong("objectid");
            hasMutexOfferIdList.add(hasMutexOfferId);
            DynamicObject offerInfo = offerInfos.stream().filter(offerInfoTemp -> hasMutexOfferId == offerInfoTemp.getLong("id")).findFirst().get();
            offerVerifyResult.getFailInfos().add(new VerifyOfferFailedInfo(offerInfo.getString("number"), "offerHasEditMutex", MessageFormat.format(OfferMultilingualConstants.offerIsEditing(), dynamicObject.getString("user.name"))));
        });
        offerIdList.removeAll(hasMutexOfferIdList);
        return offerIdList;
    }

    public static OfferBaseDeleteService getInstance() {
        return Instance.INSTANCE;
    }

    public boolean deleteOfferAndSendMq(List<Long> offerIdList, String operateName) {
        List<DynamicObject> offerInfoList = this.deleteHelper.getOfferByIdList(offerIdList);
        this.deleteHelper.updateOfferForDelete(offerInfoList);
        DynamicObject[] offerInfoArr = offerInfoList.toArray(new DynamicObject[0]);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                OfferServiceHelper.getInstance().updateOffer(offerInfoArr);
                this.syncOfferStatusToAppFile(offerInfoArr);
                OfferGenOpRecordService.getInstance().genDeleteOfferOpRecord(offerInfoList, operateName);
                HashMap contentMap = Maps.newHashMapWithExpectedSize((int)2);
                List offerCodes = offerInfoList.stream().filter(off -> "2".equals(off.getString("salarytype"))).map(ids -> ids.getString("number")).collect(Collectors.toList());
                List offerIds = offerInfoList.stream().filter(off -> "2".equals(off.getString("salarytype"))).map(ids -> ids.getLong("id")).collect(Collectors.toList());
                if (0 != offerCodes.size()) {
                    contentMap.put("offerCode", offerCodes);
                    contentMap.put("offerId", offerIds);
                    contentMap.put("offerStatus", "delete");
                    ProducerExecution.handleExecution((String)"hcdm", (Object)contentMap);
                }
                this.updateAppfileOfferId(offerInfoList);
            }
            catch (Exception e) {
                txHandle.markRollback();
                this.logger.error("\u3010deleteOffer\u3011error:", (Throwable)e);
                boolean bl = false;
                if (txHandle != null) {
                    if (var6_6 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    private void updateAppfileOfferId(List<DynamicObject> offerInfoList) {
        Set appfileIds = offerInfoList.stream().map(dy -> dy.getLong("appfile.id")).collect(Collectors.toSet());
        QFilter appfileQfilter = new QFilter("appfile.id", "in", appfileIds);
        QFilter deleteQfilter = new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode());
        HRBaseServiceHelper offerServiceHelper = new HRBaseServiceHelper("tso_somk_offerbase");
        DynamicObject[] offerDys = offerServiceHelper.query("id,status.id,appfile.id,offerletter.id", new QFilter[]{appfileQfilter, deleteQfilter});
        HRBaseServiceHelper appfileServiceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        QFilter idFilter = new QFilter("id", "in", appfileIds);
        Object[] appfileDys = appfileServiceHelper.query("id,offer,offerletter", new QFilter[]{idFilter});
        if (HRArrayUtils.isEmpty((Object[])appfileDys)) {
            return;
        }
        Arrays.stream(appfileDys).forEach(appfileDy -> {
            List discardOfferDys = Arrays.stream(offerDys).filter(dy -> dy.getLong("appfile.id") == appfileDy.getLong("id") && dy.getLong("status.id") == OfferStatus.ALR_DISCARD.getCode().longValue()).sorted(Comparator.comparingLong(dy -> dy.getLong("id"))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(discardOfferDys)) {
                appfileDy.set("offer_id", ((DynamicObject)discardOfferDys.get(discardOfferDys.size() - 1)).get("id"));
                appfileDy.set("offerletter_id", (Object)((DynamicObject)discardOfferDys.get(discardOfferDys.size() - 1)).getLong("offerletter.id"));
            } else {
                appfileDy.set("offer_id", (Object)0L);
                appfileDy.set("offerletter_id", (Object)0L);
            }
        });
        appfileServiceHelper.update((DynamicObject[])appfileDys);
    }

    private OfferBaseDeleteService() {
    }

    private static class Instance {
        private static final OfferBaseDeleteService INSTANCE = new OfferBaseDeleteService();

        private Instance() {
        }
    }
}

