/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.delete;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferSalaryService;
import kd.tsc.tso.business.domain.offer.service.btnservice.delete.helper.OfferBillDeleteHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDeleteMultiLangConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class OfferBillDeleteService {
    private Log logger = LogFactory.getLog(OfferBillDeleteService.class);
    private OfferBillDeleteHelper billDeleteHelper = OfferBillDeleteHelper.getInstance();

    public boolean isVisible(DynamicObject offerBillInfo) {
        return this.billDeleteHelper.verifyPerm(offerBillInfo) && this.billDeleteHelper.verifyStatus(offerBillInfo);
    }

    public String checkCondition(DynamicObject offerBillInfo) {
        String message;
        offerBillInfo = OfferBillServiceHelper.getInstance().queryOne(offerBillInfo.get("id"));
        if (offerBillInfo.getBoolean("deletestatus")) {
            return OfferDeleteMultiLangConstants.dataHasDelete();
        }
        DynamicObjectCollection offerEntity = offerBillInfo.getDynamicObjectCollection("entryentity");
        long offerId = ((DynamicObject)offerEntity.get(0)).getLong("offer.id");
        DynamicObject offer = OfferServiceHelper.getInstance().getOfferById(offerId);
        DynamicObject[] editObjs = OfferEditMutexHelper.checkOfferIsEditing(Lists.newArrayList((Object[])new Long[]{offer.getLong("id")}));
        if (editObjs != null && editObjs.length > 0) {
            return MessageFormat.format(OfferMultilingualConstants.offerIsEditing(), editObjs[0].getString("user.name"));
        }
        if (!this.billDeleteHelper.verifyStatus(offerBillInfo)) {
            return OfferDeleteMultiLangConstants.billStatusError();
        }
        if ("2".equals(offer.getString("salarytype")) && !HRStringUtils.isEmpty((String)(message = new OfferSalaryService().verifyHasPerm(offer.getLong("id"), "tso_somk_offerapproveinfo")))) {
            return message;
        }
        return null;
    }

    public void deleteBill(DynamicObject offerBillInfo) {
        offerBillInfo = OfferBillServiceHelper.getInstance().queryOne(offerBillInfo.get("id"));
        offerBillInfo.set("deletestatus", (Object)DeleteEnum.PRE_DELETE.getCode());
        DynamicObjectCollection offerEntity = offerBillInfo.getDynamicObjectCollection("entryentity");
        long offerId = ((DynamicObject)offerEntity.get(0)).getLong("offer.id");
        DynamicObject offerInfo = OfferServiceHelper.getInstance().queryOne(offerId);
        offerInfo.set("offerauditno", (Object)"");
        offerInfo.set("billstatus", (Object)OfferAuditStatus.NULL.getCode());
        try (TXHandle tx = TX.required();){
            try {
                OfferBillServiceHelper.getInstance().updateOne(offerBillInfo);
                OfferServiceHelper.getInstance().updateOne(offerInfo);
            }
            catch (Exception e) {
                this.logger.error("\u3010OfferBillDeleteService\u3011\"deleteBill\" error :", (Throwable)e);
                tx.markRollback();
            }
        }
    }

    public static OfferBillDeleteService getInstance() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final OfferBillDeleteService INSTANCE = new OfferBillDeleteService();

        private Instance() {
        }
    }
}

