/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.delete.helper;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUniqueKeyUtils;
import kd.tsc.tso.common.util.OfferUtils;

public class OfferDeleteHelper {
    public boolean verifyPerm(DynamicObject offerInfo) {
        DynamicObject busUnit = offerInfo.getDynamicObject("busunit");
        return OfferPermService.getInstance().verifyHasPerm("bar_delete", "tso_somk_offerbase", (Long)busUnit.getLong("id"));
    }

    public boolean verifyStatus(DynamicObject offerInfo) {
        OfferStatus offerStatus = OfferStatusUtil.getOfferStatus((DynamicObject)offerInfo);
        OfferAuditStatus auditStatus = OfferStatusUtil.getOfferAuditStatus((DynamicObject)offerInfo);
        return offerStatus == OfferStatus.PRE_APPLY && (auditStatus == OfferAuditStatus.TEMPORARY || auditStatus == OfferAuditStatus.NULL || auditStatus == OfferAuditStatus.ALR_ABANDON);
    }

    public List<DynamicObject> getOfferByIdList(List<Long> offerIdList) {
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"status", "isdelete", "modifier", "modifytime", "busunit", "number", "appfile", "salarytype", "billstatus", "recruposi", "candidatename", "offerauditno", "pindexes"});
        DynamicObject[] offerInfos = OfferServiceHelper.getInstance().queryOfferByIdList(offerIdList, selectProperties);
        return Arrays.asList(offerInfos);
    }

    public void updateOfferForDelete(List<DynamicObject> offerInfoList) {
        offerInfoList.forEach(offerInfo -> {
            offerInfo.set("isdelete", (Object)1);
            OfferUtils.updateModifyInfo((DynamicObject)offerInfo);
            offerInfo.set("pindexes", (Object)OfferUniqueKeyUtils.getPrimaryIndex((DynamicObject)offerInfo, (OfferUniqueKeyUtils.Strategy)OfferUniqueKeyUtils.Strategy.DELETE));
        });
    }

    public static OfferDeleteHelper getInstance() {
        return Instance.INSTANCE;
    }

    private OfferDeleteHelper() {
    }

    private static class Instance {
        private static final OfferDeleteHelper INSTANCE = new OfferDeleteHelper();

        private Instance() {
        }
    }
}

