/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.edit;

import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferEditMultiLangConstants;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import org.apache.commons.lang3.tuple.Pair;

public class OfferEditBaseInfoService {
    public boolean isVisible(DynamicObject offerBaseDt) {
        return this.verifyAppFileStatus(offerBaseDt) && (Boolean)this.verifyStatus(offerBaseDt).getLeft() != false;
    }

    public Pair<Boolean, String> canExecute(DynamicObject offerBaseInfoDt) {
        if (!this.verifyAppFileStatus(offerBaseInfoDt)) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferEditMultiLangConstants.appFileNotInProcessError());
        }
        Pair<Boolean, String> statusPair = this.verifyStatus(offerBaseInfoDt);
        if (!((Boolean)statusPair.getLeft()).booleanValue()) {
            return statusPair;
        }
        return this.verifyOfferAuditStatus(offerBaseInfoDt);
    }

    public boolean execute(IFormView formView) {
        long offerId = this.getOfferId(formView);
        StringBuilder mutexStringBuilder = new StringBuilder();
        boolean require = OfferEditMutexHelper.requireMutex(formView, offerId, mutexStringBuilder);
        if (!require) {
            formView.showTipNotification(mutexStringBuilder.toString());
            return false;
        }
        this.changePageToEdit(formView);
        return true;
    }

    private void changePageToEdit(IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        formShowParameter.setStatus(OperationStatus.EDIT);
        formView.invokeOperation("refresh");
        String postMode = formView.getModel().getValue("postassignmode").toString();
        if ("2".equals(postMode)) {
            formView.setVisible(Boolean.TRUE, new String[]{"peposition"});
            BasedataEdit pePosition = (BasedataEdit)formView.getControl("peposition");
            pePosition.setMustInput(true);
            BasedataEdit pejob = (BasedataEdit)formView.getControl("pejob");
            pejob.setMustInput(true);
            Object peAdminOrgValue = formView.getModel().getValue("peadminorg");
            if (peAdminOrgValue == null) {
                formView.setEnable(Boolean.FALSE, new String[]{"peposition"});
            }
        }
    }

    private long getOfferId(IFormView formView) {
        BillShowParameter showParameter = (BillShowParameter)formView.getFormShowParameter();
        return Long.parseLong(showParameter.getPkId().toString());
    }

    private boolean verifyAppFileStatus(DynamicObject offerBaseInfoDt) {
        DynamicObject appFile = offerBaseInfoDt.getDynamicObject("appfile");
        return OfferUtils.checkAppFileInProcess((DynamicObject)appFile);
    }

    private Pair<Boolean, String> verifyStatus(DynamicObject offerBaseInfo) {
        OfferStatus offerStatus = OfferStatusUtil.getOfferStatus((DynamicObject)offerBaseInfo);
        if (offerStatus == OfferStatus.PRE_APPLY) {
            return Pair.of((Object)Boolean.TRUE, (Object)"");
        }
        return Pair.of((Object)Boolean.FALSE, (Object)OfferEditMultiLangConstants.offerStatusIsNotPreApplyError());
    }

    private Pair<Boolean, String> verifyOfferAuditStatus(DynamicObject offerInfo) {
        OfferAuditStatus auditStatus = OfferStatusUtil.getOfferAuditStatus((DynamicObject)offerInfo);
        if (auditStatus == OfferAuditStatus.TEMPORARY || auditStatus == OfferAuditStatus.WAIT_RESUBMIT) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferEditMultiLangConstants.hasProcessBillError((String)offerInfo.getString("offerauditno")));
        }
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    public static OfferEditBaseInfoService getInstance() {
        return Instance.EDIT_BASE_INFO;
    }

    private OfferEditBaseInfoService() {
    }

    private static class Instance {
        private static final OfferEditBaseInfoService EDIT_BASE_INFO = new OfferEditBaseInfoService();

        private Instance() {
        }
    }
}

