/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.edit;

import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferEditMultiLangConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSubmitMultiLangConstants;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import org.apache.commons.lang3.tuple.Pair;

public class OfferEditBillInfoService {
    public boolean isVisible(DynamicObject offerBillDt) {
        return (Boolean)this.canExecute(offerBillDt).getLeft();
    }

    public Pair<Boolean, String> canExecute(DynamicObject offerBillInfoDt) {
        DynamicObject offer = OfferBillServiceHelper.getInstance().getOfferByBillDt(offerBillInfoDt);
        if (offer.getBoolean("isdelete")) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferSubmitMultiLangConstants.OfferDataNotExistError());
        }
        DynamicObject offerDt = OfferServiceHelper.getInstance().queryOne(offer.getLong("id"));
        if (!OfferUtils.checkAppFileInProcess((DynamicObject)offerDt.getDynamicObject("appfile"))) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferEditMultiLangConstants.appFileNotInProcessError());
        }
        OfferAuditStatus auditStatus = OfferStatusUtil.getOfferAuditStatus((DynamicObject)offerBillInfoDt);
        if (auditStatus != OfferAuditStatus.TEMPORARY && auditStatus != OfferAuditStatus.WAIT_RESUBMIT) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferEditMultiLangConstants.statusErrorForBill());
        }
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    public boolean execute(IFormView formView) {
        StringBuilder mutexStringBuilder = new StringBuilder();
        boolean require = OfferEditMutexHelper.requireMutex(formView, formView.getModel().getDataEntity().getLong("id"), mutexStringBuilder);
        if (!require) {
            formView.showTipNotification(mutexStringBuilder.toString());
        } else {
            this.setPageStatusToEdit(formView);
        }
        return require;
    }

    private void setPageStatusToEdit(IFormView formView) {
        BillShowParameter formShowParameter = (BillShowParameter)formView.getFormShowParameter();
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId(formView.getModel().getValue("id"));
        IBillView billView = (IBillView)formView;
        billView.load(formView.getModel().getValue("id"));
        billView.invokeOperation("refresh");
    }

    public static OfferEditBillInfoService getInstance() {
        return Instance.EDIT_BILL_INFO;
    }

    private OfferEditBillInfoService() {
    }

    private static class Instance {
        private static final OfferEditBillInfoService EDIT_BILL_INFO = new OfferEditBillInfoService();

        private Instance() {
        }
    }
}

