/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.replacereply;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.bo.oprecord.OfferLetterReplaceReplyBO;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.replacereply.helper.OfferReplaceReplyHelper;
import kd.tsc.tso.business.domain.offer.service.letter.OfferLetterService;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.util.OfferUtils;

public class OfferReplaceReplyService {
    private static final Log logger = LogFactory.getLog(OfferReplaceReplyService.class);
    private OfferReplaceReplyHelper replaceReplyHelper = OfferReplaceReplyHelper.getInstance();
    private static final String REJECT_REASON_OTHER = "1050120_S";

    public OfferVerifyResult canExecute(List<Long> offerIdList) {
        List<DynamicObject> offerInfoList = this.replaceReplyHelper.getOfferByIdListForReplaceReply(offerIdList);
        if (offerInfoList == null || offerInfoList.isEmpty()) {
            throw new KDBizException("offerInfoList cannot be null");
        }
        OfferVerifyResult result = new OfferVerifyResult();
        ArrayList<DynamicObject> passOffer = new ArrayList<DynamicObject>(offerInfoList.size());
        offerInfoList.forEach(offer -> {
            if (!this.replaceReplyHelper.verifyReplyStatus((DynamicObject)offer)) {
                result.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.REPLACE_REPLY_ERR_001, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9Offer Letter\u56de\u590d\u72b6\u6001\u4e3a\u201c\u5f85\u56de\u590d\u201d\u7684Offer\u8fdb\u884c\u4ee3\u56de\u590d\u3002", (String)"OfferReplaceReplyService_0", (String)"tsc-tso-business", (Object[])new Object[0]));
                return;
            }
            if (this.replaceReplyHelper.verifyOfferLetterStatus((DynamicObject)offer)) {
                result.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.REPLACE_REPLY_ERR_002, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9Offer Letter\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u751f\u6548\u201d\u7684Offer\u8fdb\u884c\u4ee3\u56de\u590d\u3002", (String)"OfferReplaceReplyService_1", (String)"tsc-tso-business", (Object[])new Object[0]));
                return;
            }
            if (!this.replaceReplyHelper.verifyOfferLetterSendType((DynamicObject)offer)) {
                result.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.REPLACE_REPLY_ERR_004, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u53d1\u9001\u65b9\u5f0f\u4e3a\u201c\u90ae\u4ef6\u9644\u4ef6\u201d\u7684Offer Letter\u8fdb\u884c\u4ee3\u56de\u590d\u3002", (String)"OfferReplaceReplyService_3", (String)"tsc-tso-business", (Object[])new Object[0]));
                return;
            }
            passOffer.add((DynamicObject)offer);
        });
        if (!this.replaceReplyHelper.verifyListHaveSameSendTime(passOffer)) {
            OfferVerifyResult verifyResult = new OfferVerifyResult();
            offerInfoList.forEach(offer -> verifyResult.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.REPLACE_REPLY_ERR_003, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u53d1\u9001\u65e5\u671f\u76f8\u540c\u7684Offer Letter\u8fdb\u884c\u4ee3\u56de\u590d\u3002", (String)"OfferReplaceReplyService_2", (String)"tsc-tso-business", (Object[])new Object[0])));
            return verifyResult;
        }
        result.setPassIds(OfferUtils.getOfferIdListByDts(passOffer));
        result.setResultType(passOffer.size(), offerIdList.size());
        return result;
    }

    public boolean replaceReply(List<Long> offerIdList, OfferLetterReplaceReplyBO commonBo) {
        block40: {
            List<DynamicObject> offerList = this.replaceReplyHelper.getOfferByOfferId(offerIdList);
            List<DynamicObject> offerLetterList = this.replaceReplyHelper.getOfferLetterByOfferForReplaceReply(offerList);
            String replyResult = commonBo.getReplyResult();
            if (HRStringUtils.equals((String)"1", (String)replyResult)) {
                try (TXHandle tx = TX.required();){
                    try {
                        offerLetterList.stream().forEach(offerLetter -> {
                            offerLetter.set("replystatus", (Object)OfferLetterReplyStatus.ALR_ACCEPT.getCode());
                            offerLetter.set("replytime", (Object)commonBo.getRealReplyDate());
                            OfferUtils.updateModifyInfo((DynamicObject)offerLetter);
                            OfferLetterService.Singleton.INSTANCE.getInstance().sendAcceptOfferMessage((DynamicObject)offerLetter);
                        });
                        OfferLetterServiceHelper.getInstance().update(offerLetterList.toArray(new DynamicObject[0]));
                        OfferServiceHelper.getInstance().update(offerList.toArray(new DynamicObject[0]));
                        logger.info("offer status update success");
                        break block40;
                    }
                    catch (Exception e) {
                        logger.info("OfferReplaceReplyService accept error:", (Object)e);
                        tx.markRollback();
                        boolean bl = false;
                        if (tx != null) {
                            if (var7_8 != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable) {
                                    var7_8.addSuppressed(throwable);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        return bl;
                    }
                }
            }
            if (HRStringUtils.equals((String)"2", (String)replyResult)) {
                try (TXHandle tx = TX.required();){
                    try {
                        offerLetterList.stream().forEach(offerLetter -> {
                            offerLetter.set("replystatus", (Object)OfferLetterReplyStatus.ALR_REFUSE.getCode());
                            offerLetter.set("replytime", (Object)commonBo.getRealReplyDate());
                            offerLetter.set("rejectreason", commonBo.getRejectReason().getPkValue());
                            offerLetter.set("rejectdesc", (Object)commonBo.getOtherReasonDesc());
                            offerLetter.set("lastreasonsign", (Object)"rejectreason");
                            boolean isInvalid = OfferParamConfigService.getInstance().getInvalidConfig("refuseoffer");
                            if (isInvalid) {
                                offerLetter.set("datastatus", (Object)OfferLetterDataStatus.INVALID.getCode());
                            }
                            OfferUtils.updateModifyInfo((DynamicObject)offerLetter);
                        });
                        OfferLetterServiceHelper.getInstance().update(offerLetterList.toArray(new DynamicObject[0]));
                        break block40;
                    }
                    catch (Exception e) {
                        logger.info("OfferReplaceReplyService reject error:", (Object)e);
                        tx.markRollback();
                        boolean bl = false;
                        if (tx != null) {
                            if (var7_9 != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable) {
                                    var7_9.addSuppressed(throwable);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        return bl;
                    }
                }
            }
            return false;
        }
        return true;
    }

    private OfferReplaceReplyService() {
    }

    public static OfferReplaceReplyService getInstance() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final OfferReplaceReplyService INSTANCE = new OfferReplaceReplyService();

        private Instance() {
        }
    }
}

