/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.replacereply.helper;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import org.apache.commons.lang3.time.DateUtils;

public class OfferReplaceReplyHelper {
    private OfferReplaceReplyHelper() {
    }

    public boolean verifyReplyStatus(DynamicObject offer) {
        OfferLetterReplyStatus replyStatus = OfferStatusUtil.getLetterReplyStatusByOffer((DynamicObject)offer);
        return replyStatus == OfferLetterReplyStatus.PRE_REPLY;
    }

    public boolean verifyOfferLetterStatus(DynamicObject offer) {
        OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatusByOffer((DynamicObject)offer);
        return letterStatus == OfferLetterStatus.ALR_DISCARD;
    }

    public boolean verifyOfferLetterSendType(DynamicObject offer) {
        if (HRObjectUtils.isEmpty((Object)offer)) {
            return false;
        }
        DynamicObject letter = offer.getDynamicObject("offerletter");
        if (HRObjectUtils.isEmpty((Object)letter)) {
            return false;
        }
        String sendType = letter.getString("sendtype");
        return HRStringUtils.isNotEmpty((String)sendType) && HRStringUtils.equals((String)"2", (String)sendType);
    }

    public boolean verifyListHaveSameSendTime(List<DynamicObject> offerInfoList) {
        if (offerInfoList.isEmpty()) {
            return true;
        }
        if (offerInfoList.size() == 1) {
            return true;
        }
        DynamicObject offerLetter = offerInfoList.get(0).getDynamicObject("offerletter");
        Date sendTime = Optional.ofNullable(offerLetter.getDate("sendtime")).orElseGet(() -> DateUtils.addDays((Date)new Date(), (int)-1));
        for (int i = 1; i < offerInfoList.size(); ++i) {
            DynamicObject letter = offerInfoList.get(i).getDynamicObject("offerletter");
            Date sendTimeTemp = Optional.ofNullable(letter.getDate("sendtime")).orElseGet(() -> DateUtils.addDays((Date)new Date(), (int)-1));
            if (DateUtils.isSameDay((Date)sendTimeTemp, (Date)sendTime)) continue;
            return false;
        }
        return true;
    }

    public static OfferReplaceReplyHelper getInstance() {
        return Instance.INSTANCE;
    }

    public List<DynamicObject> getOfferByIdListForReplaceReply(List<Long> offerIdList) {
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"appfile", "busunit", "offerletter", "recruposi", "candidatename", "modifier", "modifytime", "status", "number", "name"});
        QFilter qFilter = new QFilter("id", "in", offerIdList);
        return Arrays.asList(OfferServiceHelper.getInstance().query(selectProperties, qFilter.toArray()));
    }

    public List<DynamicObject> getOfferByOfferId(List<Long> offerIdList) {
        QFilter qFilter = new QFilter("id", "in", offerIdList);
        return Arrays.asList(OfferServiceHelper.getInstance().loadDynamicObjectArray(qFilter.toArray()));
    }

    public List<DynamicObject> getOfferLetterByOfferForReplaceReply(List<DynamicObject> offerList) {
        List offerLetterIdList = offerList.stream().map(offer -> offer.getDynamicObject("offerletter").getLong("id")).collect(Collectors.toList());
        OfferLetterServiceHelper letterServiceHelper = OfferLetterServiceHelper.getInstance();
        QFilter qFilter = new QFilter("id", "in", offerLetterIdList);
        String selectProperties = letterServiceHelper.getLetterSelectProperties();
        return Arrays.asList(letterServiceHelper.query(selectProperties, qFilter.toArray()));
    }

    private static class Instance {
        private static OfferReplaceReplyHelper INSTANCE = new OfferReplaceReplyHelper();

        private Instance() {
        }
    }
}

