/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.save;

import java.util.Collections;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tso.business.domain.offer.helper.OfferFieldEditSwitchHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.copy.OfferCopyService;
import kd.tsc.tso.business.domain.offer.service.btnservice.save.helper.OfferBaseSaveHelper;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSaveMultiLangConstants;
import org.apache.commons.lang3.tuple.Pair;

public class OfferBaseSaveService {
    private static final Log logger = LogFactory.getLog(OfferBaseSaveService.class);
    private final OfferBaseSaveHelper saveHelper = OfferBaseSaveHelper.getInstance();

    public boolean isVisible(DynamicObject offerInfo) {
        return this.saveHelper.verifyAppFile(offerInfo) && this.saveHelper.verifyStatus(offerInfo);
    }

    public Pair<Boolean, String> canSaveOffer(DynamicObject offerInfoDt, IFormView view) {
        if (view.getModel().getValue("adminorg") == null) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferSaveMultiLangConstants.valiedateAdminOrgError());
        }
        if (view.getFormShowParameter().getStatus() == OperationStatus.ADDNEW && !this.saveHelper.verifyEffectOffer(offerInfoDt)) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferSaveMultiLangConstants.existEffectOfferError());
        }
        Boolean isCopy = (Boolean)view.getFormShowParameter().getCustomParam("iscopy");
        if (Objects.nonNull(isCopy) && isCopy.booleanValue() && !this.saveHelper.verifyEffectOffer(offerInfoDt)) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferSaveMultiLangConstants.existEffectOfferError());
        }
        if (!this.saveHelper.verifyAppFile(offerInfoDt)) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferSaveMultiLangConstants.appFileNotInProcessError());
        }
        if (!this.saveHelper.verifyStatus(offerInfoDt)) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferSaveMultiLangConstants.statusWrongError());
        }
        if (!this.saveHelper.verifyOfferLetterTemplate(offerInfoDt)) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferSaveMultiLangConstants.offerLetterTemplateIsDisenableError());
        }
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    public boolean saveOffer(DynamicObject offerInfo) {
        this.saveHelper.updateOfferInfo(offerInfo);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                OfferServiceHelper.getInstance().updateOne(offerInfo);
                OfferGenOpRecordService.getInstance().genEditOfferOpRecord(offerInfo);
            }
            catch (Exception exception) {
                txHandle.markRollback();
                logger.error("\u3010saveOffer\u3011: ", (Throwable)exception);
                boolean bl = false;
                if (txHandle != null) {
                    if (var3_3 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    public Pair<Boolean, Long> saveOfferForCopy(DynamicObject offerInfo) {
        this.saveHelper.updateOfferInfoForCopy(offerInfo);
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            DynamicObject newOfferInfo = (DynamicObject)OfferServiceHelper.getInstance().updateOne(offerInfo);
            OfferGenOpRecordService.getInstance().genNewOfferBaseOpRecord(Collections.singletonList(offerInfo));
            OfferGenOpRecordService.getInstance().genEditOfferOpRecord(offerInfo);
            Pair pair = Pair.of((Object)Boolean.TRUE, (Object)newOfferInfo.getLong("id"));
            return pair;
        }
        catch (Exception exception) {
            txHandle.markRollback();
            logger.error("\u3010saveOffer\u3011: ", (Throwable)exception);
            Pair pair = Pair.of((Object)Boolean.FALSE, (Object)0L);
            return pair;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public void afterSaveSuccessForCopy(IFormView formView, long newOfferId) {
        boolean isFromCopy = OfferCopyService.getInstance().isViewFromCopy(formView);
        if (!isFromCopy) {
            return;
        }
        BillShowParameter showParameter = (BillShowParameter)formView.getFormShowParameter();
        String fieldSwitchInfo = formView.getPageCache().get("fieldSwitchCacheKey");
        OfferFieldEditSwitchHelper.getInstance().insert(newOfferId, fieldSwitchInfo);
        showParameter.setCustomParam("copy", null);
        showParameter.setCustomParam("iscopy", null);
        showParameter.setCustomParam("copy_pkid", (Object)newOfferId);
        showParameter.setPkId((Object)newOfferId);
        formView.cacheFormShowParameter();
    }

    public static OfferBaseSaveService getInstance() {
        return Instance.BASE_INSTANCE;
    }

    private OfferBaseSaveService() {
    }

    private static class Instance {
        private static final OfferBaseSaveService BASE_INSTANCE = new OfferBaseSaveService();

        private Instance() {
        }
    }
}

