/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.save;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.save.OfferBaseSaveService;
import kd.tsc.tso.business.domain.offer.service.btnservice.save.helper.OfferBillSaveHelper;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSaveMultiLangConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSubmitMultiLangConstants;
import org.apache.commons.lang3.tuple.Pair;

public class OfferBillSaveService {
    private static final Log logger = LogFactory.getLog(OfferBaseSaveService.class);
    private final OfferBillSaveHelper saveHelper = OfferBillSaveHelper.getInstance();

    public boolean isVisible(DynamicObject offerBillDt) {
        return (Boolean)this.canSaveOfferBill(offerBillDt).getLeft();
    }

    public Pair<Boolean, String> canSaveOfferBill(DynamicObject offerBillDt) {
        if (this.saveHelper.verifyOfferData(offerBillDt)) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferSubmitMultiLangConstants.OfferDataNotExistError());
        }
        if (!this.saveHelper.verifyAppFile(offerBillDt)) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferSaveMultiLangConstants.appFileNotInProcessError());
        }
        if (!this.saveHelper.verifyAuditStatus(offerBillDt)) {
            return Pair.of((Object)Boolean.FALSE, (Object)OfferSaveMultiLangConstants.statusErrorForBill());
        }
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    public boolean saveOfferBill(DynamicObject offerBillDt, DynamicObject offerBaseDt, List<String> keyWords) {
        this.saveHelper.updateOfferBaseBeforeSave(offerBaseDt);
        this.saveHelper.updateOfferBillBeforeSave(offerBillDt);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                if (!"tso_somk_offerapproveinfo".equals(offerBaseDt.getDynamicObjectType().getName())) {
                    OfferServiceHelper.getInstance().updateOne(offerBaseDt);
                }
                OfferBillServiceHelper.getInstance().updateOne(offerBillDt);
                OfferGenOpRecordService.getInstance().genEditBillOpRecord(offerBillDt, keyWords);
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.error("\u3010saveOffer\u3011error: ", (Throwable)e);
                boolean bl = false;
                if (txHandle != null) {
                    if (var5_5 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    public static OfferBillSaveService getInstance() {
        return Instance.INSTANCE;
    }

    private OfferBillSaveService() {
    }

    private static class Instance {
        private static OfferBillSaveService INSTANCE = new OfferBillSaveService();

        private Instance() {
        }
    }
}

