/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.save.helper;

import java.util.Collections;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUniqueKeyUtils;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class OfferBaseSaveHelper {
    public boolean verifyPerm(DynamicObject offerInfoDt) {
        DynamicObject busUnit = offerInfoDt.getDynamicObject("busunit");
        if (HRObjectUtils.isEmpty((Object)busUnit)) {
            return false;
        }
        return OfferPermService.getInstance().verifyHasPerm("bar_save", "tso_somk_offerbase", (Long)busUnit.getLong("id"));
    }

    public boolean verifyAppFile(DynamicObject offerInfo) {
        DynamicObject appFile = offerInfo.getDynamicObject("appfile");
        if (HRObjectUtils.isEmpty((Object)appFile)) {
            return false;
        }
        return OfferUtils.checkAppFileInProcess((DynamicObject)appFile);
    }

    public boolean verifyStatus(DynamicObject offerInfo) {
        OfferStatus offerStatus = OfferStatusUtil.getOfferStatus((DynamicObject)offerInfo);
        return offerStatus == OfferStatus.PRE_APPLY;
    }

    public boolean verifyOfferLetterTemplate(DynamicObject offerInfo) {
        DynamicObject offerLetterTemplate = offerInfo.getDynamicObject("template");
        if (Objects.isNull(offerLetterTemplate)) {
            return true;
        }
        String templateEnable = offerLetterTemplate.getString("enable");
        return templateEnable.equals("1");
    }

    public void updateOfferInfo(DynamicObject offerInfo) {
        if (Objects.isNull(offerInfo.getDynamicObject("applicant"))) {
            offerInfo.set("applicant", (Object)RequestContext.get().getCurrUserId());
            offerInfo.set("applytime", (Object)DateUtils.nowDateTime());
        }
        OfferUtils.updateModifyInfo((DynamicObject)offerInfo);
    }

    public void updateOfferInfoForCopy(DynamicObject offerInfo) {
        this.updateOfferInfo(offerInfo);
        offerInfo.set("pindexes", (Object)OfferUniqueKeyUtils.getPrimaryIndex((DynamicObject)offerInfo, (OfferUniqueKeyUtils.Strategy)OfferUniqueKeyUtils.Strategy.INIT));
    }

    public static OfferBaseSaveHelper getInstance() {
        return Instance.INSTANCE;
    }

    public boolean verifyEffectOffer(DynamicObject offerInfoDt) {
        DynamicObject appFile = offerInfoDt.getDynamicObject("appfile");
        DynamicObject[] validOffers = OfferServiceHelper.getInstance().getValidDynamicObjectByAppIdList(Collections.singletonList(appFile.getLong("id")));
        return validOffers.length <= 0;
    }

    private OfferBaseSaveHelper() {
    }

    private static class Instance {
        private static OfferBaseSaveHelper INSTANCE = new OfferBaseSaveHelper();

        private Instance() {
        }
    }
}

