/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.save.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;

public class OfferBillSaveHelper {
    public boolean verifyPerm(DynamicObject offerBillDt) {
        DynamicObject busUnit = offerBillDt.getDynamicObject("busunit");
        return OfferPermService.getInstance().verifyHasPerm("bar_save", "tso_somk_offerbill", (Long)busUnit.getLong("id"));
    }

    public boolean verifyAppFile(DynamicObject offerBillDt) {
        DynamicObject offerByBillDt = OfferBillServiceHelper.getInstance().getOfferByBillDt(offerBillDt);
        DynamicObject offer = OfferServiceHelper.getInstance().queryOne(offerByBillDt.getLong("id"));
        DynamicObject appFile = offer.getDynamicObject("appfile");
        return OfferUtils.checkAppFileInProcess((DynamicObject)appFile);
    }

    public boolean verifyOfferData(DynamicObject offerBillDt) {
        DynamicObject offer = OfferBillServiceHelper.getInstance().getOfferByBillDt(offerBillDt);
        return offer.getBoolean("isdelete");
    }

    public boolean verifyAuditStatus(DynamicObject offerBillDt) {
        OfferAuditStatus auditStatus = OfferStatusUtil.getOfferAuditStatus((DynamicObject)offerBillDt);
        return auditStatus == OfferAuditStatus.TEMPORARY || auditStatus == OfferAuditStatus.WAIT_RESUBMIT;
    }

    public void updateOfferBaseBeforeSave(DynamicObject offerBaseDt) {
        OfferUtils.updateModifyInfo((DynamicObject)offerBaseDt);
    }

    public void updateOfferBillBeforeSave(DynamicObject offerBillDt) {
        OfferUtils.updateModifyInfo((DynamicObject)offerBillDt);
    }

    public static OfferBillSaveHelper getInstance() {
        return Instance.INSTANCE;
    }

    private OfferBillSaveHelper() {
    }

    private static class Instance {
        private static OfferBillSaveHelper INSTANCE = new OfferBillSaveHelper();

        private Instance() {
        }
    }
}

