/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.send;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.service.btnservice.send.helper.OfferSendServiceHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSendMultiLangConstants;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;

public class OfferBaseSendService {
    private OfferSendServiceHelper sendServiceHelper = OfferSendServiceHelper.getInstance();

    public boolean isVisible(DynamicObject offerBaseInfo) {
        return this.sendServiceHelper.verifyAppFile(offerBaseInfo) && this.sendServiceHelper.verifyStatus(offerBaseInfo);
    }

    public OfferVerifyResult canExecute(List<Long> offerIdList) {
        OfferVerifyResult verifyResult = new OfferVerifyResult();
        List<DynamicObject> offerByIdList = this.sendServiceHelper.getOfferByIdList(offerIdList);
        ArrayList<Long> passIds = new ArrayList<Long>(offerIdList.size());
        offerByIdList.forEach(offer -> {
            if (!this.sendServiceHelper.verifyOfferStatus((DynamicObject)offer)) {
                verifyResult.recordFailInfoForBase((DynamicObject)offer, OfferErrorEnum.SEND_ERR_003, OfferSendMultiLangConstants.statusNotPreSendError());
                return;
            }
            passIds.add(offer.getLong("id"));
        });
        verifyResult.setResultType(passIds.size(), offerByIdList.size());
        verifyResult.setPassIds(passIds);
        return verifyResult;
    }

    public static OfferBaseSendService getInstance() {
        return Instance.BASE_INSTANCE;
    }

    private OfferBaseSendService() {
    }

    private static class Instance {
        private static final OfferBaseSendService BASE_INSTANCE = new OfferBaseSendService();

        private Instance() {
        }
    }
}

