/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.send.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;

public class OfferSendServiceHelper {
    public boolean verifyPerm(DynamicObject offerBaseInfoDt) {
        long busUnitId = offerBaseInfoDt.getDynamicObject("busunit").getLong("id");
        return OfferPermService.getInstance().verifyHasPerm("bar_send", "tso_somk_offerbase", (Long)busUnitId);
    }

    public boolean verifyAppFile(DynamicObject offerBaseInfoDt) {
        return OfferUtils.checkAppFileInProcess((DynamicObject)offerBaseInfoDt.getDynamicObject("appfile"));
    }

    public boolean verifyStatus(DynamicObject offerBaseInfoDt) {
        OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatusByOffer((DynamicObject)offerBaseInfoDt);
        return letterStatus == OfferLetterStatus.PRE_SEND;
    }

    public boolean verifyOfferStatus(DynamicObject offerBaseInfoDt) {
        OfferStatus offerStatus = OfferStatusUtil.getOfferStatus((DynamicObject)offerBaseInfoDt);
        return OfferStatus.APPLY_PASS == offerStatus;
    }

    public List<DynamicObject> getOfferByIdList(List<Long> offerIdList) {
        ArrayList<DynamicObject> offerInfoList = new ArrayList<DynamicObject>(offerIdList.size());
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"number", "appfile", "busunit", "status", "offerletter"});
        DynamicObject[] offerArr = OfferServiceHelper.getInstance().queryOfferByIdList(offerIdList, selectProperties);
        offerInfoList.addAll(Arrays.asList(offerArr));
        return offerInfoList;
    }

    public static OfferSendServiceHelper getInstance() {
        return Instance.BASE_INSTANCE;
    }

    private OfferSendServiceHelper() {
    }

    private static class Instance {
        private static final OfferSendServiceHelper BASE_INSTANCE = new OfferSendServiceHelper();

        private Instance() {
        }
    }
}

