/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.submit;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.save.helper.OfferBaseSaveHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.helper.OfferBaseSubmitHelper;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferEditMultiLangConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSubmitMultiLangConstants;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.OfferVerifyResultEnum;
import kd.tsc.tsrbs.common.utils.CodeRuleUtils;
import org.apache.commons.lang3.tuple.Pair;

public class OfferBaseSubmitService {
    private static Log logger = LogFactory.getLog(OfferBaseSubmitService.class);
    private OfferBaseSubmitHelper submitHelper = OfferBaseSubmitHelper.getInstance();
    private static final String P_EXPTMONSAL = "exptmonsal";
    private static final String P_CURMONSAL = "curmonsal";
    private static final String P_EXPTMONSALCURC = "exptmonsalcurc";
    private static final String P_CURMONSALCURC = "curmonsalcurc";
    private static final String P_APPFILEID = "appfileId";

    public boolean isVisible(DynamicObject offerInfo) {
        return this.submitHelper.verifyAppFile(offerInfo) && this.submitHelper.verifyOfferStatus(offerInfo) && this.submitHelper.verifyAuditStatus(offerInfo);
    }

    public OfferVerifyResult canExecute(DynamicObject offerInfo, boolean needSave) {
        OfferVerifyResult result = new OfferVerifyResult();
        if (!this.submitHelper.verifyAppFile(offerInfo)) {
            return result.recordFailInfoForBase(offerInfo, OfferErrorEnum.SUBMIT_ERR_002, OfferSubmitMultiLangConstants.appFileNotInProcessError());
        }
        if (!this.submitHelper.verifyOfferStatus(offerInfo)) {
            return result.recordFailInfoForBase(offerInfo, OfferErrorEnum.SUBMIT_ERR_003, OfferSubmitMultiLangConstants.offerStatusIsNotPreApplyError());
        }
        if (!this.submitHelper.verifyAuditStatus(offerInfo)) {
            return result.recordFailInfoForBase(offerInfo, OfferErrorEnum.SUBMIT_ERR_004, OfferEditMultiLangConstants.hasProcessBillError((String)offerInfo.getString("offerauditno")));
        }
        if (!needSave && !this.submitHelper.verifyHasApply(offerInfo)) {
            return result.recordFailInfoForBase(offerInfo, OfferErrorEnum.SUBMIT_ERR_005, OfferEditMultiLangConstants.noApplyOfferBeforeSubmitError());
        }
        List<String> fields = this.submitHelper.verifyTemplateAndOffer(offerInfo);
        if (!fields.isEmpty()) {
            return result.recordFailInfoForBase(offerInfo, OfferErrorEnum.SUBMIT_ERR_006, OfferSubmitMultiLangConstants.templateFieldsHasNullInOffer(fields));
        }
        result.setResultType(OfferVerifyResultEnum.ALL_PASS.getCode());
        result.setPassIds(Collections.singletonList(offerInfo.getLong("id")));
        return result;
    }

    public Pair<Boolean, Long> submitOfferWithoutApprove(DynamicObject offerBaseInfo, boolean needSave, boolean fromCopy, String operateName) {
        if (offerBaseInfo.getLong("id") == 0L) {
            offerBaseInfo.set("id", (Object)ID.genLongId());
        }
        DynamicObject letter = OfferLetterServiceHelper.getInstance().generateNewOfferLetter(offerBaseInfo);
        if (fromCopy) {
            OfferBaseSaveHelper.getInstance().updateOfferInfoForCopy(offerBaseInfo);
        }
        if (needSave) {
            OfferBaseSaveHelper.getInstance().updateOfferInfo(offerBaseInfo);
        }
        this.submitHelper.updateBeforeSubmitWithoutApprove(offerBaseInfo, letter);
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            OfferServiceHelper.getInstance().updateOne(offerBaseInfo);
            OfferLetterServiceHelper.getInstance().saveOne(letter);
            if (fromCopy) {
                OfferGenOpRecordService.getInstance().genNewOfferBaseOpRecord(Collections.singletonList(offerBaseInfo));
            }
            if (needSave) {
                OfferGenOpRecordService.getInstance().genEditOfferOpRecord(offerBaseInfo);
            }
            OfferGenOpRecordService.getInstance().genSubmitOfferOpRecord(offerBaseInfo, operateName);
            OfferGenOpRecordService.getInstance().genNewOfferLetterOpRecord(Collections.singletonList(offerBaseInfo), 0);
            this.submitHelper.syncOfferStatusToAppFileForSubmitWithoutApprove(offerBaseInfo);
            this.synResume(new DynamicObject[]{offerBaseInfo});
            Pair pair = Pair.of((Object)Boolean.TRUE, (Object)offerBaseInfo.getLong("id"));
            return pair;
        }
        catch (Exception exception) {
            txHandle.markRollback();
            CodeRuleUtils.releaseOneCodeRule((String)"tso_offerletter", (DynamicObject)letter, (String)letter.getString("billno"));
            logger.error("\u3010submitOffer\u3011error: ", (Throwable)exception);
            Pair pair = Pair.of((Object)Boolean.FALSE, (Object)0L);
            return pair;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private void synResume(DynamicObject[] offerObjs) {
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)offerObjs.length);
        for (DynamicObject offerObj : offerObjs) {
            Object currentregpaycu = offerObj.get("currentregpaycu");
            Object currentsalary = offerObj.get("currentsalary");
            Object expectedsalary = offerObj.get("expectedsalary");
            long appfileid = offerObj.getLong("appfile.id");
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)6);
            paramMap.put(P_APPFILEID, appfileid);
            paramMap.put(P_EXPTMONSAL, expectedsalary);
            paramMap.put(P_CURMONSAL, currentsalary);
            paramMap.put(P_EXPTMONSALCURC, currentregpaycu);
            paramMap.put(P_CURMONSALCURC, currentregpaycu);
            paramList.add(paramMap);
        }
        try {
            logger.info("OfferBaseSubmitService.synResume param {}", (Object)paramList);
            DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"stdrsmServiceApi", (String)"updateSalaryInfos", (Object[])new Object[]{paramList});
        }
        catch (Exception ex) {
            logger.error("OfferBaseSubmitService.synResume error\uff1a", (Throwable)ex);
        }
    }

    public Pair<Boolean, Long> mokaSubmitOfferWithoutApprove(DynamicObject offerBaseInfo, boolean needSave, boolean fromCopy, String operateName, IFormView formView) {
        long offerId;
        if (offerBaseInfo.getLong("id") == 0L) {
            offerBaseInfo.set("id", (Object)ID.genLongId());
        }
        if ((offerId = offerBaseInfo.getLong("id")) == 0L || !OfferServiceHelper.getInstance().isExists(offerId)) {
            try {
                offerBaseInfo.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"tso_somk_offerbase", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"tso_somk_offerbase"), null));
            }
            catch (Exception e) {
                formView.showErrorNotification(e.getMessage());
                return Pair.of((Object)Boolean.FALSE, (Object)0L);
            }
        }
        DynamicObject letter = OfferLetterServiceHelper.getInstance().generateNewOfferLetter(offerBaseInfo);
        if (fromCopy) {
            OfferBaseSaveHelper.getInstance().updateOfferInfoForCopy(offerBaseInfo);
        }
        if (needSave) {
            OfferBaseSaveHelper.getInstance().updateOfferInfo(offerBaseInfo);
        }
        this.submitHelper.updateBeforeSubmitWithoutApprove(offerBaseInfo, letter);
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            OfferServiceHelper.getInstance().updateOne(offerBaseInfo);
            if (!HRObjectUtils.isEmpty((Object)letter)) {
                OfferLetterServiceHelper.getInstance().saveOne(letter);
            }
            if (fromCopy) {
                OfferGenOpRecordService.getInstance().genNewOfferBaseOpRecord(Collections.singletonList(offerBaseInfo));
            }
            if (needSave) {
                OfferGenOpRecordService.getInstance().genEditOfferOpRecord(offerBaseInfo);
            }
            OfferGenOpRecordService.getInstance().genSubmitOfferOpRecord(offerBaseInfo, operateName);
            OfferGenOpRecordService.getInstance().genNewOfferLetterOpRecord(Collections.singletonList(offerBaseInfo), 0);
            this.submitHelper.syncOfferStatusToAppFileForSubmitWithoutApprove(offerBaseInfo);
            this.synResume(new DynamicObject[]{offerBaseInfo});
            this.updateAppfileInfo(offerBaseInfo, letter);
            Pair pair = Pair.of((Object)Boolean.TRUE, (Object)offerBaseInfo.getLong("id"));
            return pair;
        }
        catch (Exception exception) {
            txHandle.markRollback();
            if (!HRObjectUtils.isEmpty((Object)letter)) {
                CodeRuleUtils.releaseOneCodeRule((String)"tso_offerletter", (DynamicObject)letter, (String)letter.getString("billno"));
            }
            logger.error("\u3010submitOffer\u3011error: ", (Throwable)exception);
            Pair pair = Pair.of((Object)Boolean.FALSE, (Object)0L);
            return pair;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public Pair<Boolean, Long> mokaSubmitOfferWithApprove(DynamicObject offerBaseInfo, DynamicObject offerApproveDy, boolean needSave, boolean fromCopy, String operateName, boolean isConfigWfPerson, IFormView formView) {
        DynamicObject approveFromDataBase;
        long offerId = offerBaseInfo.getLong("id");
        if (offerId == 0L || !OfferServiceHelper.getInstance().isExists(offerId)) {
            try {
                offerBaseInfo.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"tso_somk_offerbase", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"tso_somk_offerbase"), null));
            }
            catch (Exception e) {
                formView.showErrorNotification(e.getMessage());
                return Pair.of((Object)Boolean.FALSE, (Object)0L);
            }
        }
        if (null != (approveFromDataBase = OfferBillServiceHelper.getInstance().queryOne("id,number,billno,billstatus,enable,entryentity.offer", new QFilter("id", "=", (Object)offerApproveDy.getLong("id")).toArray()))) {
            offerApproveDy = approveFromDataBase;
        }
        this.submitHelper.updateOfferBaseWithApprove(offerBaseInfo, offerApproveDy);
        offerApproveDy.set("enable", (Object)"1");
        if (fromCopy) {
            OfferBaseSaveHelper.getInstance().updateOfferInfoForCopy(offerBaseInfo);
        }
        if (needSave) {
            OfferBaseSaveHelper.getInstance().updateOfferInfo(offerBaseInfo);
        }
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            DynamicObject newOfferInfo = (DynamicObject)OfferServiceHelper.getInstance().updateOne(offerBaseInfo);
            DynamicObjectCollection dynamicObjectCollection = offerApproveDy.getDynamicObjectCollection("entryentity");
            DynamicObject dynamicObject = ((DynamicObject)dynamicObjectCollection.get(0)).getDynamicObject("offer");
            if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
                ((DynamicObject)dynamicObjectCollection.get(0)).set("offer", (Object)newOfferInfo);
            }
            offerApproveDy.set("number", offerBaseInfo.get("number"));
            OfferBillServiceHelper.getInstance().saveOfferBill(offerApproveDy);
            if (!isConfigWfPerson) {
                logger.info("OfferBaseSubmitService.mokaSubmitOfferWithApprove:{}", (Object)new Date());
            }
            if (fromCopy) {
                OfferGenOpRecordService.getInstance().genNewOfferBaseOpRecord(Collections.singletonList(offerBaseInfo));
            }
            if (needSave) {
                OfferGenOpRecordService.getInstance().genEditOfferOpRecord(offerBaseInfo);
            }
            logger.info("\u4fdd\u5b58\u6570\u636e\u5230\u6570\u636e\u5e93");
            this.updateAppfileInfo(offerBaseInfo);
            OfferGenOpRecordService.getInstance().genSubmitOfferOpRecord(offerBaseInfo, operateName);
            OfferGenOpRecordService.getInstance().genNewOfferBillOpRecord(offerApproveDy);
            this.submitHelper.syncOfferStatusToAppFileForSubmitWithApprove(offerBaseInfo);
            Pair pair = Pair.of((Object)Boolean.TRUE, (Object)newOfferInfo.getLong("id"));
            return pair;
        }
        catch (Exception e) {
            txHandle.markRollback();
            CodeRuleUtils.releaseOneCodeRule((String)"tso_somk_offerbill", (DynamicObject)offerApproveDy, (String)offerApproveDy.getString("billno"));
            logger.error("\u3010submitOffer\u3011error: ", (Throwable)e);
            Pair pair = Pair.of((Object)Boolean.FALSE, (Object)0L);
            return pair;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private void updateAppfileInfo(DynamicObject offerDy) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        QFilter qFilter = new QFilter("id", "=", (Object)offerDy.getLong("appfile.id"));
        DynamicObject appfileDy = serviceHelper.queryOne("id,offer,offerletter", new QFilter[]{qFilter});
        if (!HRObjectUtils.isEmpty((Object)appfileDy)) {
            appfileDy.set("offer_id", (Object)offerDy.getLong("id"));
            appfileDy.set("offerletter_id", (Object)offerDy.getLong("offerletter.id"));
            serviceHelper.update(new DynamicObject[]{appfileDy});
        }
    }

    private void updateAppfileInfo(DynamicObject offerDy, DynamicObject offerLetterDy) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        QFilter qFilter = new QFilter("id", "=", (Object)offerDy.getLong("appfile.id"));
        DynamicObject appfileDy = serviceHelper.queryOne("id,offer,offerletter", new QFilter[]{qFilter});
        if (!HRObjectUtils.isEmpty((Object)appfileDy)) {
            appfileDy.set("offer_id", (Object)offerDy.getLong("id"));
            appfileDy.set("offerletter_id", (Object)offerLetterDy.getLong("id"));
            serviceHelper.update(new DynamicObject[]{appfileDy});
        }
    }

    public static OfferBaseSubmitService getInstance() {
        return Instance.INSTANCE;
    }

    private OfferBaseSubmitService() {
    }

    private static class Instance {
        private static final OfferBaseSubmitService INSTANCE = new OfferBaseSubmitService();

        private Instance() {
        }
    }
}

