/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.submit;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.SyncOfferStatusToAppFileService;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.OfferBaseSubmitService;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.helper.OfferBaseSubmitHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.helper.OfferBillSubmitHelper;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSubmitMultiLangConstants;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.OfferVerifyResultEnum;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import org.apache.commons.lang3.StringUtils;

public class OfferBillSubmitService {
    private static Log logger = LogFactory.getLog(OfferBaseSubmitService.class);
    private OfferBillSubmitHelper submitHelper = OfferBillSubmitHelper.getInstance();

    public boolean isVisible(DynamicObject offerBillInfo) {
        return this.submitHelper.verifyPerm(offerBillInfo) && this.submitHelper.verifyAppFile(offerBillInfo) && this.submitHelper.verifyAuditStatus(offerBillInfo);
    }

    public OfferVerifyResult canExecute(DynamicObject offerBillInfo, DynamicObject offerObj) {
        OfferVerifyResult result = new OfferVerifyResult();
        if ("tso_somk_offerapproveinfo".equals(offerObj.getDynamicObjectType().getName())) {
            DynamicObjectCollection offerEntity = offerBillInfo.getDynamicObjectCollection("entryentity");
            long offerId = ((DynamicObject)offerEntity.get(0)).getLong("offer.id");
            if (this.submitHelper.verifyOfferData(OfferServiceHelper.getInstance().getOfferById(offerId))) {
                return result.recordFailInfoForBill(offerBillInfo, OfferErrorEnum.SUBMIT_ERR_009, OfferSubmitMultiLangConstants.OfferDataNotExistError());
            }
        } else if (this.submitHelper.verifyOfferData(offerObj)) {
            return result.recordFailInfoForBill(offerBillInfo, OfferErrorEnum.SUBMIT_ERR_009, OfferSubmitMultiLangConstants.OfferDataNotExistError());
        }
        if (!this.submitHelper.verifyAppFile(offerBillInfo)) {
            return result.recordFailInfoForBill(offerBillInfo, OfferErrorEnum.SUBMIT_ERR_002, OfferSubmitMultiLangConstants.appFileNotInProcessError());
        }
        OfferAuditStatus auditStatus = OfferStatusUtil.getOfferAuditStatus((DynamicObject)offerBillInfo);
        if (auditStatus != OfferAuditStatus.TEMPORARY && auditStatus != OfferAuditStatus.WAIT_RESUBMIT) {
            return result.recordFailInfoForBill(offerBillInfo, OfferErrorEnum.SUBMIT_ERR_008, OfferSubmitMultiLangConstants.statusFailForBill());
        }
        List<String> fields = null;
        if ("tso_somk_offerapproveinfo".equals(offerObj.getDynamicObjectType().getName())) {
            logger.info("tso_somk_offerapproveinfo.verifyTemplateAndOffer\uff1a{}", offerBillInfo.get("pperiodterm"));
            fields = OfferBaseSubmitHelper.getInstance().verifyTemplateAndOffer(offerBillInfo);
        } else {
            fields = OfferBaseSubmitHelper.getInstance().verifyTemplateAndOffer(offerObj);
        }
        if (!fields.isEmpty()) {
            return result.recordFailInfoForBill(offerBillInfo, OfferErrorEnum.SUBMIT_ERR_006, OfferSubmitMultiLangConstants.templateFieldsHasNullInOffer(fields));
        }
        result.setResultType(OfferVerifyResultEnum.ALL_PASS.getCode());
        result.setPassIds(Collections.singletonList(offerBillInfo.getLong("id")));
        return result;
    }

    public boolean mokaSubmitOfferBill(DynamicObject offerApprove, DynamicObject offerBaseDt, String operateName, boolean isConfigWfPerson) {
        if (OfferAuditStatus.WAIT_RESUBMIT.getCode().equals(offerApprove.get("billstatus"))) {
            offerApprove.set("billstatus", (Object)OfferAuditStatus.AUDITING.getCode());
            offerBaseDt.set("billstatus", (Object)OfferAuditStatus.AUDITING.getCode());
        } else {
            offerBaseDt.set("billstatus", (Object)OfferAuditStatus.ALR_SUBMIT.getCode());
            offerApprove.set("billstatus", (Object)OfferAuditStatus.ALR_SUBMIT.getCode());
        }
        offerBaseDt.set("status", (Object)OfferStatus.APPLYING.getCode());
        if (StringUtils.isEmpty((CharSequence)offerApprove.getString("billno"))) {
            String number = CodeRuleServiceHelper.getNumber((String)"tso_offerbill", (DynamicObject)offerApprove, null);
            offerApprove.set("billno", (Object)number);
        }
        OfferUtils.updateOperateInfo((DynamicObject)offerApprove);
        OfferUtils.updateModifyInfo((DynamicObject)offerBaseDt);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                OfferServiceHelper.getInstance().updateOffer(new DynamicObject[]{offerBaseDt});
                OfferBillServiceHelper.getInstance().updateOfferBill(offerApprove);
                if (!isConfigWfPerson) {
                    logger.info("OfferBillSubmitService.mokaSubmitOfferBill:{}", (Object)new Date());
                }
                SyncOfferStatusToAppFileService.syncOfferStatusToAppFile(new DynamicObject[]{offerBaseDt});
                OfferGenOpRecordService.getInstance().genSubmitOfferBillOpRecord(offerApprove, operateName);
            }
            catch (Exception exception) {
                txHandle.markRollback();
                logger.error("\u3010submitOffer\u3011error: ", (Throwable)exception);
                boolean bl = false;
                if (txHandle != null) {
                    if (var6_6 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    public static OfferBillSubmitService getInstance() {
        return Instance.INSTANCE;
    }

    private OfferBillSubmitService() {
    }

    private static class Instance {
        private static final OfferBillSubmitService INSTANCE = new OfferBillSubmitService();

        private Instance() {
        }
    }
}

