/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.submit.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.mq.model.OfferChangeModel;
import kd.tsc.tso.business.domain.mq.producer.OfferChangeProducer;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferFieldMultiLangConstants;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferFieldsHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferTemplateHelper;

public class OfferBaseSubmitHelper {
    private static Log logger = LogFactory.getLog(OfferBaseSubmitHelper.class);

    public boolean verifyPerm(DynamicObject offerInfo) {
        long busUnitId = offerInfo.getDynamicObject("busunit").getLong("id");
        return OfferPermService.getInstance().verifyHasPerm("bar_submit", "tso_somk_offerbase", (Long)busUnitId);
    }

    public boolean verifyAppFile(DynamicObject offerInfo) {
        DynamicObject appfileObj = AppFileHelper.queryOriginalOne((String)"id,filestatus", (long)offerInfo.getLong("appfile.id"));
        return OfferUtils.checkAppFileInProcess((DynamicObject)appfileObj);
    }

    public boolean verifyOfferStatus(DynamicObject offerInfo) {
        DynamicObject dataEntity = OfferServiceHelper.getInstance().loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)offerInfo.getLong("id"))});
        OfferStatus offerStatus = null;
        offerStatus = null == dataEntity ? OfferStatusUtil.getOfferStatus((DynamicObject)offerInfo) : OfferStatusUtil.getOfferStatus((DynamicObject)dataEntity);
        return offerStatus == OfferStatus.PRE_APPLY;
    }

    public boolean verifyAuditStatus(DynamicObject offerInfo) {
        DynamicObject dataEntity = OfferServiceHelper.getInstance().loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)offerInfo.getLong("id"))});
        OfferAuditStatus auditStatus = null;
        auditStatus = null == dataEntity ? OfferStatusUtil.getOfferAuditStatus((DynamicObject)offerInfo) : OfferStatusUtil.getOfferAuditStatus((DynamicObject)dataEntity);
        return auditStatus != OfferAuditStatus.TEMPORARY && auditStatus != OfferAuditStatus.WAIT_RESUBMIT;
    }

    public boolean verifyHasApply(DynamicObject offerInfo) {
        return Objects.nonNull(offerInfo.get("applicant"));
    }

    public List<String> verifyTemplateAndOffer(DynamicObject offerInfo) {
        ArrayList<String> emptyFieldsInTemplate = new ArrayList<String>(16);
        String templateContent = "";
        if (offerInfo.getDynamicObjectType().getName().equals("tso_somk_offerapproveinfo")) {
            DynamicObject template = offerInfo.getDynamicObject("template");
            if (!HRObjectUtils.isEmpty((Object)template)) {
                DynamicObject offerTemplate = new OfferTemplateHelper().getOfferTemplate((Object)template.getLong("id"));
                templateContent = offerTemplate.getString("content_tag");
            }
        } else {
            templateContent = offerInfo.getString("templatecontent_tag");
        }
        List templateFields = OfferFieldsHelper.getTemplateFields((String)templateContent);
        templateFields.forEach(field -> {
            if (!OfferUtils.checkHasProperty((DynamicObject)offerInfo, (String)field)) {
                return;
            }
            if (this.checkNeedFullFieldInfo(offerInfo, (String)field)) {
                if ("peposition".equals(field)) {
                    if (!Objects.isNull(offerInfo.get("postassignmode")) && offerInfo.getString("postassignmode").equals("2") && Objects.isNull(offerInfo.get("peposition"))) {
                        emptyFieldsInTemplate.add(OfferFieldMultiLangConstants.post());
                    }
                    if (!Objects.isNull(offerInfo.get("postassignmode")) && offerInfo.getString("postassignmode").equals("3") && Objects.isNull(offerInfo.get("pestdposition"))) {
                        emptyFieldsInTemplate.add(OfferFieldMultiLangConstants.standardPost());
                    }
                    if (!Objects.isNull(offerInfo.get("postassignmode")) && offerInfo.getString("postassignmode").equals("1") && Objects.isNull(offerInfo.get("pejob"))) {
                        emptyFieldsInTemplate.add(OfferFieldMultiLangConstants.position());
                    }
                } else {
                    String fieldName = offerInfo.getDynamicObjectType().getProperty(field).getDisplayName().getLocaleValue();
                    if (!emptyFieldsInTemplate.contains(fieldName)) {
                        emptyFieldsInTemplate.add(fieldName);
                    }
                }
            }
        });
        return emptyFieldsInTemplate;
    }

    private boolean checkNeedFullFieldInfo(DynamicObject offerInfo, String field) {
        if ("peposition".equals(field)) {
            return Objects.isNull(offerInfo.get("peposition"));
        }
        if ("pejob".equals(field)) {
            return Objects.isNull(offerInfo.get("pejob"));
        }
        if ("prpemonthly".equals(field)) {
            return new BigDecimal(0).compareTo(offerInfo.getBigDecimal(field)) == 0;
        }
        if ("pperiodterm".equals(field)) {
            return offerInfo.getInt(field) == 0;
        }
        if ("supervisor".equals(field)) {
            return offerInfo.getDynamicObjectCollection("supervisor").size() == 0;
        }
        return Objects.isNull(offerInfo.get(field));
    }

    public void mokaInvokeSubmitOffer(DynamicObject offerApproveDy) {
        logger.info("OfferBaseSubmitHelper.mokaInvokeSubmitOffer:{}", (Object)new Date());
        OperationServiceImpl opImpl = new OperationServiceImpl();
        opImpl.localInvokeOperation("approve_submit", "tso_somk_offerapproveinfo", new Object[]{offerApproveDy.getPkValue()}, null);
    }

    public void updateBeforeSubmitWithoutApprove(DynamicObject offerBaseInfo, DynamicObject letter) {
        DynamicObject applyPass = BusinessDataServiceHelper.loadSingle((Object)OfferStatus.APPLY_PASS.getCode(), (String)"tsrbd_offerstatus");
        offerBaseInfo.set("status", (Object)applyPass);
        if (Objects.nonNull(letter)) {
            offerBaseInfo.set("offerletter", (Object)letter);
        }
        OfferUtils.updateModifyInfo((DynamicObject)offerBaseInfo);
    }

    public void updateOfferBaseWithApprove(DynamicObject offerBaseInfo, DynamicObject offerApproveDy) {
        DynamicObject applying = BusinessDataServiceHelper.loadSingle((Object)OfferStatus.APPLYING.getCode(), (String)"tsrbd_offerstatus");
        offerBaseInfo.set("status", (Object)applying);
        offerBaseInfo.set("offerauditno", (Object)offerApproveDy.getString("billno"));
        offerBaseInfo.set("billstatus", (Object)offerApproveDy.getString("billstatus"));
        OfferUtils.updateModifyInfo((DynamicObject)offerBaseInfo);
    }

    public DynamicObject updateOfferApprove(DynamicObject offerBaseInfo, String applyContent) {
        DynamicObject offerApproveDy = OfferBillServiceHelper.getInstance().generateNewOfferBillDt(offerBaseInfo);
        if (Objects.nonNull(applyContent)) {
            offerApproveDy.set("applycontent", (Object)applyContent);
        }
        return offerApproveDy;
    }

    public void syncOfferStatusToAppFileForSubmitWithoutApprove(DynamicObject offerInfo) {
        OfferChangeModel model = new OfferChangeModel();
        model.setAppFileId(offerInfo.getDynamicObject("appfile").getLong("id"));
        model.setOfferId(offerInfo.getLong("id"));
        model.setOfferStatus(OfferLetterStatus.PRE_SEND.getCode());
        OfferChangeProducer.sendOfferChangeBatch(Collections.singletonList(model));
    }

    public void syncOfferStatusToAppFileForSubmitWithApprove(DynamicObject offerInfo) {
        OfferChangeModel model = new OfferChangeModel();
        model.setAppFileId(offerInfo.getDynamicObject("appfile").getLong("id"));
        model.setOfferId(offerInfo.getLong("id"));
        model.setOfferStatus(OfferStatus.APPLYING.getCode());
        OfferChangeProducer.sendOfferChangeBatch(Collections.singletonList(model));
    }

    public void rollbackWhenFail(DynamicObject offerInfo) {
        HRBaseServiceHelper statusHelper = new HRBaseServiceHelper("tsrbd_offerstatus");
        DynamicObject preApply = statusHelper.queryOne((Object)OfferStatus.PRE_APPLY.getCode());
        offerInfo.set("status", (Object)preApply);
        offerInfo.set("offerletter", null);
    }

    public static OfferBaseSubmitHelper getInstance() {
        return Instance.INSTANCE;
    }

    private OfferBaseSubmitHelper() {
    }

    private static class Instance {
        private static OfferBaseSubmitHelper INSTANCE = new OfferBaseSubmitHelper();

        private Instance() {
        }
    }
}

