/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.submit.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;

public class OfferBillSubmitHelper {
    private static Log logger = LogFactory.getLog(OfferBillSubmitHelper.class);

    public boolean verifyPerm(DynamicObject offerInfo) {
        DynamicObject dynamicObject = offerInfo.getDynamicObject("busunit");
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return true;
        }
        long busUnitId = dynamicObject.getLong("id");
        return OfferPermService.getInstance().verifyHasPerm("bar_submit", "tso_somk_offerbill", (Long)busUnitId);
    }

    public boolean verifyAppFile(DynamicObject dynamicObject) {
        DynamicObject offerByBillDt = OfferBillServiceHelper.getInstance().getOfferByBillDt(dynamicObject);
        DynamicObject offer = OfferServiceHelper.getInstance().queryOne(offerByBillDt.getLong("id"));
        return OfferUtils.checkAppFileInProcess((DynamicObject)offer.getDynamicObject("appfile"));
    }

    public boolean verifyOfferData(DynamicObject dynamicObject) {
        DynamicObject offer = OfferServiceHelper.getInstance().getOfferById(dynamicObject.getLong("id"));
        return offer.getBoolean("isdelete");
    }

    public boolean verifyAuditStatus(DynamicObject offerInfo) {
        OfferAuditStatus auditStatus = OfferStatusUtil.getOfferAuditStatus((DynamicObject)offerInfo);
        return auditStatus == OfferAuditStatus.TEMPORARY || auditStatus == OfferAuditStatus.WAIT_RESUBMIT;
    }

    public static OfferBillSubmitHelper getInstance() {
        return Instance.INSTANCE;
    }

    private OfferBillSubmitHelper() {
    }

    private static class Instance {
        private static OfferBillSubmitHelper INSTANCE = new OfferBillSubmitHelper();

        private Instance() {
        }
    }
}

