/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.unsubmit;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.unsubmit.helper.OfferUnSubmitHelper;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferUnSubmitMultiLangConstants;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.OfferVerifyResultEnum;

public class OfferBillUnSubmitService {
    private Log logger = LogFactory.getLog(OfferBillUnSubmitService.class);
    private OfferUnSubmitHelper unSubmitHelper = OfferUnSubmitHelper.getInstance();

    public boolean isVisible(DynamicObject offerBillInfo) {
        return this.unSubmitHelper.verifyPerm(offerBillInfo) && this.unSubmitHelper.verifyStatus(offerBillInfo);
    }

    public OfferVerifyResult canExecute(DynamicObject offerBillInfo) {
        OfferVerifyResult verifyResult = new OfferVerifyResult();
        if (!this.unSubmitHelper.verifyStatus(offerBillInfo)) {
            verifyResult.recordFailInfoForBill(offerBillInfo, OfferErrorEnum.UN_SUBMIT_ERR_002, OfferUnSubmitMultiLangConstants.offerIsNotSubmit());
        }
        verifyResult.setResultType(OfferVerifyResultEnum.ALL_PASS.getCode());
        verifyResult.getPassIds().add(offerBillInfo.getLong("id"));
        return verifyResult;
    }

    public boolean unSubmit(Long offerBillId, String operateName) {
        DynamicObject offerBill = OfferBillServiceHelper.getInstance().queryOne(offerBillId);
        this.unSubmitHelper.invokeUnSubmitToApprove(Collections.singletonList(offerBill.getLong("id")));
        try {
            OfferGenOpRecordService.getInstance().genUnSubmitBillOpRecord(offerBill, operateName);
        }
        catch (Exception e) {
            this.logger.error("\u3010unSubmitOffer\u3011error :", (Throwable)e);
            return false;
        }
        return true;
    }

    public static OfferBillUnSubmitService getInstance() {
        return Instance.INSTANCE;
    }

    private OfferBillUnSubmitService() {
    }

    private static class Instance {
        private static final OfferBillUnSubmitService INSTANCE = new OfferBillUnSubmitService();

        private Instance() {
        }
    }
}

