/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.btnservice.unsubmit.helper;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferUnSubmitMultiLangConstants;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;

public class OfferUnSubmitHelper {
    public boolean verifyPerm(DynamicObject offerBillInfo) {
        long busUnitId = offerBillInfo.getDynamicObject("busunit").getLong("id");
        return OfferPermService.getInstance().verifyHasPerm("bar_unsubmit", "tso_somk_offerbill", (Long)busUnitId);
    }

    public boolean verifyStatus(DynamicObject offerBillInfo) {
        OfferAuditStatus auditStatus = OfferStatusUtil.getOfferAuditStatus((DynamicObject)offerBillInfo);
        return auditStatus == OfferAuditStatus.ALR_SUBMIT;
    }

    public void invokeUnSubmitToApprove(List<Long> billIds) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        HRBaseServiceHelper dbServiceApproval = new HRBaseServiceHelper("tso_offerapproveinfo");
        DynamicObject[] offerApproves = dbServiceApproval.loadDynamicObjectArray(billIds.toArray());
        OperationResult revoke = opImpl.localInvokeOperation("revoke", offerApproves, null);
        if (!revoke.isSuccess()) {
            String message = revoke.getValidateResult() != null && revoke.getValidateResult().getValidateErrors().size() > 0 ? ((OperateErrorInfo)((ValidateResult)revoke.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage() : OfferUnSubmitMultiLangConstants.unSubmitFail();
            throw new KDBizException(message);
        }
    }

    public static OfferUnSubmitHelper getInstance() {
        return Instance.INSTANCE;
    }

    private OfferUnSubmitHelper() {
    }

    private static class Instance {
        private static final OfferUnSubmitHelper INSTANCE = new OfferUnSubmitHelper();

        private Instance() {
        }
    }
}

