/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.cardinfo;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.cardinfo.OfferCardStrategyApi;
import kd.tsc.tso.business.domain.offer.service.cardinfo.bo.OfferInfoCardBo;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.constants.offer.OfferInfoCardConstants;
import kd.tsc.tso.common.constants.offer.approve.OfferApproveCardConstants;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;

public abstract class AbstractOfferStrategy
implements OfferCardStrategyApi {
    public static final Log log = LogFactory.getLog(AbstractOfferStrategy.class);
    protected OfferParamConfigService offerParamConfigService = OfferParamConfigService.getInstance();
    private static final Map<String, String> HEAD_KEY_MAPPING = Maps.newHashMapWithExpectedSize((int)16);
    private static final String ATTACHMENT_FIELD = "attachmentfield";
    private static final String[] BASE_INFO = new String[]{"launchinderrdesc", "rejectdesc", "changevaliddesc", "delaydesc", "delayreplaydesc", "launchinderrdesc", "offerabandondesc"};

    public boolean initProcess(Object status, Object eqStatus, OfferInfoCardBo offerInfoCardBo) {
        if (status == null) {
            return false;
        }
        boolean statusEq = this.isStatusEq(status, eqStatus);
        if (!statusEq) {
            return false;
        }
        this.hideHeadData(offerInfoCardBo);
        this.hideOfferInfo(offerInfoCardBo);
        this.initHeadData(offerInfoCardBo);
        this.initBody(offerInfoCardBo);
        this.showReasonPanel(offerInfoCardBo);
        return true;
    }

    private void showReasonPanel(OfferInfoCardBo offerInfoCardBo) {
        String panelKey;
        String lastreasonsign = offerInfoCardBo.getPageRow().getString("lastreasonsign");
        String offerabandondesc = offerInfoCardBo.getPageRow().getString("offerabandondesc");
        String elementKey = lastreasonsign;
        if (StringUtils.isEmpty((String)lastreasonsign) && StringUtils.isNotEmpty((String)offerabandondesc)) {
            elementKey = "offerabandondesc";
        }
        if (StringUtils.isNotEmpty((String)(panelKey = OfferInfoCardConstants.HeadElement.getVisibelElement((String)elementKey)))) {
            offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{panelKey});
        }
    }

    private boolean isStatusEq(Object status, Object eqStatus) {
        boolean statusEq = false;
        if (status instanceof String && eqStatus instanceof String) {
            statusEq = status.equals(eqStatus);
        }
        if (status instanceof Long && eqStatus instanceof Long) {
            statusEq = ((Long)status).longValue() == ((Long)eqStatus).longValue();
        }
        return statusEq;
    }

    private void initOfferInfo(OfferInfoCardBo offerInfoCardBo) {
        IDataModel model = offerInfoCardBo.getModel();
        Row pageRow = offerInfoCardBo.getPageRow();
        int newEntryRow = offerInfoCardBo.getNewEntryRow();
        model.setValue("busunit", (Object)pageRow.getLong("busunit"), newEntryRow);
        model.setValue("changevaliddesc_nick", (Object)pageRow.getString("changevaliddesc"), newEntryRow);
        model.setValue("delaydesc_nick", (Object)pageRow.getString("delaydesc"), newEntryRow);
        model.setValue("abandondesc_nick", (Object)pageRow.getString("offerabandondesc"), newEntryRow);
        Long reasonId = pageRow.getLong("rejectreason");
        log.info("AbstractOfferStrategy.initOfferInfo.reasonId -> {}", (Object)reasonId);
        if (Objects.nonNull(reasonId) && 0L != reasonId) {
            Optional.ofNullable(BaseHelper.selectById((Long)reasonId, (String)"tsrbd_recrursn")).ifPresent(reason -> model.setValue("rejectdesc_nick", (Object)reason.getString("name"), newEntryRow));
        }
        DynamicObject offerObj = this.initOfferDynamic(offerInfoCardBo);
        this.doHideFunction(offerInfoCardBo);
        this.initAttachment(offerInfoCardBo, offerObj);
    }

    protected void initAttachment(OfferInfoCardBo offerInfoCardBo, DynamicObject offerObj) {
        List<Map<String, Object>> offerAttachment = OfferAttachmentService.getInstance().getOfferAttachment(offerObj.getPkValue());
        log.info("AbstractOfferStrategy.initAttachment offerAttachment : {} pk : {}  newEntryRow : {}", new Object[]{offerAttachment, offerObj.getPkValue(), offerInfoCardBo.getNewEntryRow()});
        for (Map<String, Object> attachment : offerAttachment) {
            DynamicObject attachmentObj = AttachmentServiceHelper.getAttCreatorByUID((String)attachment.get("uid").toString());
            String url = attachmentObj.getString("ffileid");
            attachment.replace("url", url);
        }
        AttachmentEdit edit = (AttachmentEdit)offerInfoCardBo.getCardEntry().getView().getControl(ATTACHMENT_FIELD);
        edit.postBack(offerAttachment, offerInfoCardBo.getNewEntryRow(), offerInfoCardBo.getNewEntryRow());
    }

    private DynamicObject initOfferDynamic(OfferInfoCardBo offerInfoCardBo) {
        DynamicObject offerObj;
        Long offerId = offerInfoCardBo.getPageRow().getLong("offer");
        if (offerId == null || offerId == 0L) {
            Long appfileId = offerInfoCardBo.getPageRow().getLong("appfile");
            String offerNum = offerInfoCardBo.getPageRow().getString("number");
            QFilter qFilter = new QFilter("number", "=", (Object)offerNum);
            QFilter appfileFilter = new QFilter("appfile.id", "=", (Object)appfileId);
            qFilter.and(appfileFilter);
            offerObj = OFFER_SERVICE_HELPER.loadDynamicObject(qFilter);
        } else {
            offerObj = OFFER_SERVICE_HELPER.queryOne(offerId);
        }
        Map offerBaseAttrMap = OfferApproveCardConstants.OfferBaseEnum.getAttributeMap();
        for (Map.Entry entry : offerBaseAttrMap.entrySet()) {
            Object[] pkArray;
            if (OfferApproveCardConstants.OfferBaseEnum.KEY_DELIVER.getSrcKey().equals(entry.getKey())) {
                pkArray = offerObj.getDynamicObjectCollection("deliver").stream().map(dy -> dy.get("fbasedataid_id")).toArray();
                offerInfoCardBo.getModel().setValue("deliver", (Object)pkArray, offerInfoCardBo.getNewEntryRow());
                continue;
            }
            if (OfferApproveCardConstants.OfferBaseEnum.KEY_WORKAGE.getSrcKey().equals(entry.getKey())) {
                String workYearShow = ResumeAnalysisHelper.getWorkYearShow((int)((BigDecimal)offerObj.get((String)entry.getValue())).intValue());
                log.info("initOfferDynamic.worYearShow -> {}", (Object)workYearShow);
                offerInfoCardBo.getModel().setValue((String)entry.getKey(), (Object)workYearShow, offerInfoCardBo.getNewEntryRow());
                continue;
            }
            if (OfferApproveCardConstants.OfferBaseEnum.KEY_SUPERVISOR.getSrcKey().equals(entry.getKey())) {
                pkArray = offerObj.getDynamicObjectCollection("supervisor").stream().map(dy -> dy.get("fbasedataid_id")).toArray();
                offerInfoCardBo.getModel().setValue("supervisor", (Object)pkArray, offerInfoCardBo.getNewEntryRow());
                continue;
            }
            offerInfoCardBo.getModel().setValue((String)entry.getKey(), offerObj.get((String)entry.getValue()), offerInfoCardBo.getNewEntryRow());
        }
        Map offerLetterAttrMap = OfferApproveCardConstants.OfferLetterEnum.getAttributeMap();
        DynamicObject dynamicObject = offerObj.getDynamicObject("offerletter");
        if (dynamicObject != null) {
            for (Map.Entry entry : offerLetterAttrMap.entrySet()) {
                offerInfoCardBo.getModel().setValue((String)entry.getKey(), dynamicObject.get((String)entry.getValue()), offerInfoCardBo.getNewEntryRow());
            }
        }
        return offerObj;
    }

    private void doHideFunction(OfferInfoCardBo offerInfoCardBo) {
        Row pageRow = offerInfoCardBo.getPageRow();
        this.handlePeriodterm(pageRow, offerInfoCardBo);
        Arrays.stream(BASE_INFO).forEach(baseInfo -> {
            if (Objects.isNull(offerInfoCardBo.getModel().getValue(baseInfo)) || StringUtils.isEmpty((String)String.valueOf(offerInfoCardBo.getModel().getValue(baseInfo)))) {
                offerInfoCardBo.getCardEntry().setChildVisible(false, offerInfoCardBo.getNewEntryRow(), new String[]{baseInfo});
            }
        });
        String postMode = pageRow.getString("postassignmode");
        log.info("doHideFunction.postModeObj -> {}", (Object)postMode);
        if ("2".equals(postMode)) {
            offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{"peposition"});
            offerInfoCardBo.getCardEntry().setChildVisible(false, offerInfoCardBo.getNewEntryRow(), new String[]{"pestdposition"});
        }
        if ("3".equals(postMode)) {
            offerInfoCardBo.getCardEntry().setChildVisible(false, offerInfoCardBo.getNewEntryRow(), new String[]{"peposition"});
            offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{"pestdposition"});
        }
        if ("1".equals(postMode)) {
            offerInfoCardBo.getCardEntry().setChildVisible(false, offerInfoCardBo.getNewEntryRow(), new String[]{"peposition", "pestdposition", "jobscm"});
        }
    }

    private void handlePeriodterm(Row pageRow, OfferInfoCardBo offerInfoCardBo) {
        String isPeriodTerm;
        String salaryType = pageRow.getString("salarytype");
        Object periodterm = offerInfoCardBo.getModel().getValue(OfferApproveCardConstants.OfferBaseEnum.KEY_IS_HAVE_PERIODTERM.getSrcKey(), offerInfoCardBo.getNewEntryRow());
        String string = isPeriodTerm = periodterm != null ? periodterm.toString() : "";
        if ("1".equals(salaryType)) {
            offerInfoCardBo.getCardEntry().setChildVisible(Boolean.FALSE.booleanValue(), offerInfoCardBo.getNewEntryRow(), new String[]{"salaryinfo"});
            offerInfoCardBo.getCardEntry().setChildVisible(Boolean.TRUE.booleanValue(), offerInfoCardBo.getNewEntryRow(), new String[]{"tso_offerwelfareinfo", "tso_offeretinfo"});
            if ("0".equals(isPeriodTerm)) {
                offerInfoCardBo.getCardEntry().setChildVisible(Boolean.FALSE.booleanValue(), offerInfoCardBo.getNewEntryRow(), new String[]{"tso_offerprpesainfo", "pperiodterm", "pperiodtermunit"});
                offerInfoCardBo.getCardEntry().setChildVisible(Boolean.TRUE.booleanValue(), offerInfoCardBo.getNewEntryRow(), new String[]{"tso_offerregsainfo"});
            } else {
                offerInfoCardBo.getCardEntry().setChildVisible(Boolean.TRUE.booleanValue(), offerInfoCardBo.getNewEntryRow(), new String[]{"tso_offerprpesainfo", "pperiodterm", "pperiodtermunit", "tso_offerregsainfo"});
                this.setSacalValue(offerInfoCardBo);
            }
        } else {
            if ("0".equals(isPeriodTerm)) {
                offerInfoCardBo.getCardEntry().setChildVisible(Boolean.FALSE.booleanValue(), offerInfoCardBo.getNewEntryRow(), new String[]{"pperiodtermunit", "pperiodterm"});
            }
            offerInfoCardBo.getCardEntry().setChildVisible(Boolean.TRUE.booleanValue(), offerInfoCardBo.getNewEntryRow(), new String[]{"salaryinfo"});
            offerInfoCardBo.getCardEntry().setChildVisible(Boolean.FALSE.booleanValue(), offerInfoCardBo.getNewEntryRow(), new String[]{"tso_offerregsainfo", "tso_offerprpesainfo", "tso_offerwelfareinfo", "tso_offeretinfo"});
        }
    }

    private void setSacalValue(OfferInfoCardBo offerInfoCardBo) {
        Object sacaltype = offerInfoCardBo.getModel().getValue(OfferApproveCardConstants.OfferBaseEnum.KEY_SACALTYPE.getSrcKey());
        if (sacaltype == null || "".equals(sacaltype + "")) {
            return;
        }
        Optional.of(sacaltype).filter("P"::equals).ifPresent(src -> {
            offerInfoCardBo.getCardEntry().setChildVisible(false, offerInfoCardBo.getNewEntryRow(), new String[]{OfferApproveCardConstants.OfferBaseEnum.KEY_PRPEBWAGES.getSrcKey(), OfferApproveCardConstants.OfferBaseEnum.KEY_PRPEPOSSUB.getSrcKey(), OfferApproveCardConstants.OfferBaseEnum.KEY_PRPEPRP.getSrcKey()});
            offerInfoCardBo.getModel().setValue("formalmonthlysalar", offerInfoCardBo.getModel().getValue(OfferApproveCardConstants.OfferBaseEnum.KEY_REGMONTHLYSALARY.getSrcKey()), offerInfoCardBo.getNewEntryRow());
        });
        Optional.of(sacaltype).filter("F"::equals).ifPresent(src -> offerInfoCardBo.getCardEntry().setChildVisible(false, offerInfoCardBo.getNewEntryRow(), new String[]{"formalmonthlysalar", "percent_sign", "help_icon", OfferApproveCardConstants.OfferBaseEnum.KEY_SARATIO.getSrcKey()}));
    }

    private void hideHeadData(OfferInfoCardBo offerInfoCardBo) {
        offerInfoCardBo.getCardEntry().setChildVisible(false, offerInfoCardBo.getNewEntryRow(), OfferInfoCardConstants.HeadElement.getElementList());
        offerInfoCardBo.getCardEntry().setChildVisible(false, offerInfoCardBo.getNewEntryRow(), OfferInfoCardConstants.OptElement.getElementList());
    }

    private void hideOfferInfo(OfferInfoCardBo offerInfoCardBo) {
        offerInfoCardBo.getCardEntry().setChildVisible(false, offerInfoCardBo.getNewEntryRow(), new String[]{"offer_card"});
    }

    public void defHeadData(OfferInfoCardBo offerInfoCardBo, String statusKey) {
        IDataModel model = offerInfoCardBo.getModel();
        int newEntryRow = offerInfoCardBo.getNewEntryRow();
        Row pageRow = offerInfoCardBo.getPageRow();
        Object statusObject = offerInfoCardBo.getPageRow().get(statusKey);
        model.setValue("offer_status", statusObject, newEntryRow);
        model.setValue("pemploymenttime_nick", pageRow.get("pemploymenttime"), newEntryRow);
        model.setValue("applicant", (Object)pageRow.getLong("applicant"), newEntryRow);
        Date applyTime = pageRow.getDate("applytime");
        model.setValue("org", (Object)pageRow.getLong("busunit"), newEntryRow);
        if (applyTime != null) {
            model.setValue("applytime", (Object)HRInteDateTimeUtil.formatDate((String)"tso_somk_offerbaseinfo", (String)"applytime", (Date)applyTime), newEntryRow);
        }
        for (Map.Entry<String, String> entry : HEAD_KEY_MAPPING.entrySet()) {
            if ("rejectdesc_nick".equals(entry.getKey())) {
                log.info("AbstractOfferStrategy.defHeadData.rejectReasonId -> {}", pageRow.get(entry.getValue()));
                if (!Objects.nonNull(pageRow.get(entry.getValue())) || 0L == (Long)pageRow.get(entry.getValue())) continue;
                Optional.ofNullable(BaseHelper.selectById((Long)((Long)pageRow.get(entry.getValue())), (String)"tsrbd_recrursn")).ifPresent(reason -> model.setValue((String)entry.getKey(), (Object)reason.getString("name"), newEntryRow));
                continue;
            }
            model.setValue(entry.getKey(), pageRow.get(entry.getValue()), newEntryRow);
        }
        QFilter offerFilter = new QFilter("number", "=", (Object)pageRow.getString("number"));
        DynamicObject offerObj = OFFER_SERVICE_HELPER.queryOne(offerFilter.toArray());
        model.setValue("offerid", (Object)offerObj.getLong("id"), newEntryRow);
        DynamicObject offerAuditObj = BILL_SERVICE_HELPER.queryOneByAuditNo(pageRow.getString("offerauditno"), "id,auditusers");
        if (offerAuditObj != null) {
            DynamicObjectCollection auditUsers = offerAuditObj.getDynamicObjectCollection("auditusers");
            String approverInfo = "";
            if (auditUsers != null && auditUsers.size() > 0) {
                List<Long> userIds = auditUsers.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                approverInfo = this.getApproverInfoByUserIds(userIds);
            } else {
                approverInfo = this.getApproverInfo(offerAuditObj.getString("id"));
            }
            model.setValue("approve", (Object)approverInfo, newEntryRow);
        }
        log.info("defHeadData.visible.super");
        offerInfoCardBo.getCardEntry().setChildVisible(false, newEntryRow, new String[]{"btn_super"});
    }

    public String getApproverInfo(String businessKey) {
        if (businessKey == null) {
            return "";
        }
        List userIds = WorkflowServiceHelper.getApproverByBusinessKey((String)businessKey);
        log.info("AbstractOfferStrategy.getApproverInfo userIds {}  businessKey {}", (Object)userIds, (Object)businessKey);
        List userInfo = UserServiceHelper.getUserInfoByID((List)userIds);
        StringBuilder strBuilder = new StringBuilder();
        userInfo.forEach(strMap -> {
            if (!StringUtils.isEmpty((String)strBuilder.toString())) {
                strBuilder.append(',');
            }
            Object name = strMap.get("name");
            strBuilder.append(name);
        });
        log.info("AbstractOfferStrategy.getApproverInfo strBuilder {}  businessKey {}", (Object)strBuilder, (Object)businessKey);
        return strBuilder.toString();
    }

    public String getApproverInfoByUserIds(List<Long> userIds) {
        if (userIds == null || userIds.size() == 0) {
            return null;
        }
        List userInfo = UserServiceHelper.getUserInfoByID(userIds);
        StringBuilder strBuilder = new StringBuilder();
        userInfo.forEach(strMap -> {
            if (!StringUtils.isEmpty((String)strBuilder.toString())) {
                strBuilder.append(',');
            }
            Object name = strMap.get("name");
            strBuilder.append(name);
        });
        return strBuilder.toString();
    }

    public void showOptButton(boolean ignore, OfferInfoCardBo offerInfoCardBo, String ... optKeys) {
        boolean isApplicant = offerInfoCardBo.isApplicant();
        boolean isAppfileProcess = offerInfoCardBo.isAppfileProcess();
        long businitId = offerInfoCardBo.getPageRow().getLong("busunit");
        boolean hasPerm = offerPermService.verifyHasPerm("btn_view", "tso_somk_offerbase", (Long)businitId);
        Arrays.stream(optKeys).filter(optKey -> hasPerm).forEach(optKey -> {
            String separete = optKey + "dv";
            if (isApplicant && ("bar_offerletter".equals(optKey) || "btn_view".equals(optKey))) {
                offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{optKey, separete});
                return;
            }
            boolean isShow = isApplicant || ignore;
            boolean hasSuc = offerPermService.verifyHasPerm((String)optKey, "tso_somk_offerbase", (Long)businitId);
            if (isShow && isAppfileProcess && hasSuc) {
                offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{optKey, separete});
            }
        });
    }

    public void showButtonNoCheckAppfileStatus(boolean isIgnore, OfferInfoCardBo offerInfoCardBo, String ... optKeys) {
        boolean isApplicant = offerInfoCardBo.isApplicant();
        long businitId = offerInfoCardBo.getPageRow().getLong("busunit");
        boolean hasPerm = offerPermService.verifyHasPerm("btn_view", "tso_somk_offerbase", (Long)businitId);
        boolean isShow = isApplicant || isIgnore;
        Arrays.stream(optKeys).filter(optKey -> hasPerm).forEach(optKey -> {
            String separete = optKey + "dv";
            if (isApplicant && ("bar_offerletter".equals(optKey) || "btn_view".equals(optKey))) {
                offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{optKey, separete});
                return;
            }
            boolean hasSuc = offerPermService.verifyHasPerm((String)optKey, "tso_somk_offerbase", (Long)businitId);
            if (isShow && hasSuc) {
                offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{optKey, separete});
            }
        });
    }

    @Override
    public void initBody(OfferInfoCardBo offerInfoCardBo) {
        String panelKey;
        offerInfoCardBo.getCardEntry().setChildVisible(false, offerInfoCardBo.getNewEntryRow(), new String[]{"changevaliddesc", "delaydesc", "terminatedesc", "abandondesc", "delayreplaydesc"});
        String lastreasonsign = offerInfoCardBo.getPageRow().getString("lastreasonsign");
        String offerabandondesc = offerInfoCardBo.getPageRow().getString("offerabandondesc");
        String elementKey = lastreasonsign;
        if (StringUtils.isEmpty((String)lastreasonsign) && StringUtils.isNotEmpty((String)offerabandondesc)) {
            elementKey = "offerabandondesc";
        }
        if (StringUtils.isNotEmpty((String)(panelKey = OfferInfoCardConstants.HeadElement.getVisibelElement((String)elementKey)))) {
            offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{panelKey});
        }
        this.initOfferInfo(offerInfoCardBo);
    }

    public void initOutSendHead(OfferInfoCardBo offerInfoCardBo) {
        offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{"applicant_panel", "applytime_panel", "busunit_panel"});
        String delaydesc = ((OrmLocaleValue)offerInfoCardBo.getModel().getValue("delaydesc_nick")).getLocaleValue();
        boolean hasDelaySenddesc = delaydesc == null || "".equals(delaydesc);
        String changevaliddesc = ((OrmLocaleValue)offerInfoCardBo.getModel().getValue("changevaliddesc_nick")).getLocaleValue();
        boolean hasChangevaliddesc = changevaliddesc == null || "".equals(changevaliddesc);
    }

    public Consumer<Object> doShowDescInfo(String elementKey, OfferInfoCardBo offerInfoCardBo) {
        return desc -> {
            String descInfo = "";
            if (desc instanceof OrmLocaleValue) {
                descInfo = ((OrmLocaleValue)desc).getLocaleValue();
            }
            if (descInfo != null && !"".equals(descInfo)) {
                offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{elementKey});
            }
        };
    }

    @Override
    public void initHeadData(OfferInfoCardBo offerInfoCardBo) {
    }

    static {
        HEAD_KEY_MAPPING.put("offer_number", "number");
        HEAD_KEY_MAPPING.put("changevaliddesc_nick", "changevaliddesc");
        HEAD_KEY_MAPPING.put("delaydesc_nick", "delaydesc");
        HEAD_KEY_MAPPING.put("abandondesc_nick", "abandondesc");
        HEAD_KEY_MAPPING.put("rejectdesc_nick", "rejectreason");
        HEAD_KEY_MAPPING.put("lastreplytime", "lastreplytime");
        HEAD_KEY_MAPPING.put("abandontime", "offerabandontime");
        HEAD_KEY_MAPPING.put("sendtime", "sendtime");
        HEAD_KEY_MAPPING.put("replytime", "replytime");
        HEAD_KEY_MAPPING.put("delayreplaydesc_nick", "delayreplaydesc");
    }
}

