/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.cardinfo;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tsc.tso.business.domain.offer.service.cardinfo.AbstractOfferStrategy;
import kd.tsc.tso.business.domain.offer.service.cardinfo.OfferCardStrategyApi;
import kd.tsc.tso.business.domain.offer.service.cardinfo.abandon.OfferAbandonStrategy;
import kd.tsc.tso.business.domain.offer.service.cardinfo.applying.OfferApplyingStrategy;
import kd.tsc.tso.business.domain.offer.service.cardinfo.applypass.OfferApplypassStrategy;
import kd.tsc.tso.business.domain.offer.service.cardinfo.bo.OfferInfoCardBo;
import kd.tsc.tso.business.domain.offer.service.cardinfo.preapply.OfferPreApplyStrategy;
import kd.tsc.tso.business.domain.offer.service.cardinfo.term.OfferApplyTermStrategy;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class OfferStrategyControl
extends AbstractOfferStrategy {
    private static final String[] OFFER_FIELD = new String[]{"number", "candidatename", "pemploymenttime", "inductionstatus", "applicant", "applytime", "createtime", "offerabandondesc", "offerabandontime", "creator", "busunit", "billstatus", "offerletter", "appfile", "offerauditno", "status", "launchindstatus", "salarytype", "letterauditstatus", "modifytime", "letterauditno", "candidategender", "candidateage", "regmonthly", "candidatenation", "candidateworkage", "highesteducation", "schoolname", "specialtycategory", "candidatephone", "candidateemail", "currentregpaycu", "currentsalary", "expectedsalary", "expectedmark", "launchinderrdesc", "jobduties", "postassignmode", "pestdposition", "emprelationtype", "labrelstatuscls", "depcytype", "schoolnametext"};
    private static final String[] LETTER_FIELD = new String[]{"abandontime", "replystatus", "datastatus", "letterstatus", "changevaliddesc", "delaydesc", "id", "abandondesc", "rejectdesc", "lastreplytime", "sendtime", "offer", "replytime", "senduser", "delayreplaydesc", "lastreasonsign", "rejectreason"};
    private List<OfferCardStrategyApi> strategyList = Lists.newArrayList();

    public OfferStrategyControl() {
        this.strategyList.add(new OfferPreApplyStrategy());
        this.strategyList.add(new OfferApplyingStrategy());
        this.strategyList.add(new OfferApplyTermStrategy());
        this.strategyList.add(new OfferAbandonStrategy());
        this.strategyList.add(new OfferApplypassStrategy());
    }

    @Override
    public boolean initProcess(OfferInfoCardBo offerInfoCardBo) {
        OfferCardStrategyApi strategy;
        boolean initSuccess;
        if (this.strategyList.isEmpty()) {
            return false;
        }
        Iterator<OfferCardStrategyApi> iterator = this.strategyList.iterator();
        while (iterator.hasNext() && !(initSuccess = (strategy = iterator.next()).initProcess(offerInfoCardBo))) {
        }
        return false;
    }

    public DataSet getOfferCardList(Object appFileId) {
        String offerFields = OfferUtils.getSelectProperties((String[])OFFER_FIELD);
        QFilter offerFilter = new QFilter("appfile", "=", appFileId).and(new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode()));
        String letterFields = OfferUtils.getSelectProperties((String[])LETTER_FIELD);
        QFilter letterFilter = new QFilter("appfile", "=", appFileId).and(new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode()));
        String[] orderBy = new String[]{"number desc"};
        DataSet leftDataSet = QueryServiceHelper.queryDataSet((String)"tso_somk_offerbase", (String)"tso_somk_offerbase", (String)offerFields, (QFilter[])offerFilter.toArray(), (String)"modifytime desc");
        DataSet rightDataSet = QueryServiceHelper.queryDataSet((String)"tso_offerletter", (String)"tso_offerletter", (String)letterFields, (QFilter[])letterFilter.toArray(), null);
        DataSet pageSet = leftDataSet.leftJoin(rightDataSet).on("offerletter", "id").select(OFFER_FIELD, LETTER_FIELD).finish().orderBy(orderBy);
        log.info("OfferStrategyControl.getOfferCardList dataSet : {} appfileId : {}", (Object)pageSet, appFileId);
        return pageSet;
    }

    public boolean getProcessAppfile(String offerNum) {
        QFilter offerFilter = new QFilter("number", "=", (Object)offerNum);
        DynamicObject offerObject = OFFER_SERVICE_HELPER.loadDynamicObject(offerFilter);
        DynamicObject appFile = offerObject.getDynamicObject("appfile");
        return OfferUtils.checkAppFileInProcess((DynamicObject)appFile);
    }

    public static enum Singleton {
        INSTANCE;

        private OfferStrategyControl instance = new OfferStrategyControl();

        public OfferStrategyControl getInstance() {
            return this.instance;
        }
    }
}

