/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.cardinfo.preapply;

import kd.bos.util.StringUtils;
import kd.tsc.tso.business.domain.offer.service.cardinfo.AbstractOfferStrategy;
import kd.tsc.tso.business.domain.offer.service.cardinfo.bo.OfferInfoCardBo;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;

public class OfferPreApplyStrategy
extends AbstractOfferStrategy {
    @Override
    public boolean initProcess(OfferInfoCardBo offerInfoCardBo) {
        Long offerStatus = offerInfoCardBo.getPageRow().getLong("status");
        return super.initProcess(offerStatus, OfferStatus.PRE_APPLY.getCode(), offerInfoCardBo);
    }

    @Override
    public void initHeadData(OfferInfoCardBo offerInfoCardBo) {
        super.defHeadData(offerInfoCardBo, "status");
        String auditStatus = offerInfoCardBo.getPageRow().getString("billstatus");
        if (StringUtils.isEmpty((String)auditStatus) || OfferAuditStatus.ALR_ABANDON.getCode().equals(auditStatus)) {
            offerInfoCardBo.getCardEntry().setChildVisible(false, offerInfoCardBo.getNewEntryRow(), new String[]{"btn_down", "btn_super", "offer_card"});
            long applicant = offerInfoCardBo.getPageRow().getLong("applicant");
            this.showOptButton(applicant == 0L, offerInfoCardBo, "bar_modify", "bar_submit", "btn_view");
        } else if (OfferAuditStatus.TEMPORARY.getCode().equals(auditStatus)) {
            this.showOptButton(false, offerInfoCardBo, "bar_modify", "bar_offerletter", "btn_view");
        } else if (OfferAuditStatus.WAIT_RESUBMIT.getCode().equals(auditStatus)) {
            this.showOptButton(false, offerInfoCardBo, "bar_modify", "bar_abandon", "bar_offerletter", "btn_view");
        }
    }
}

