/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.cardinfo.pregenerate;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterBillHelper;
import kd.tsc.tso.business.domain.offer.service.cardinfo.AbstractOfferStrategy;
import kd.tsc.tso.business.domain.offer.service.cardinfo.bo.OfferInfoCardBo;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;

public class OfferPreGenerateStrategy
extends AbstractOfferStrategy {
    private final ChangeLetterBillHelper letterBillHelper = ChangeLetterBillHelper.getInstance();

    @Override
    public boolean initProcess(OfferInfoCardBo offerInfoCardBo) {
        Long offerStatus = offerInfoCardBo.getPageRow().getLong("letterstatus");
        return super.initProcess(offerStatus, OfferLetterStatus.PRE_GENERATE.getCode(), offerInfoCardBo);
    }

    @Override
    public void initHeadData(OfferInfoCardBo offerInfoCardBo) {
        DynamicObject letterBillObj;
        super.defHeadData(offerInfoCardBo, "letterstatus");
        IDataModel model = offerInfoCardBo.getModel();
        String letterAuditstatus = offerInfoCardBo.getPageRow().getString("letterauditstatus");
        if (OfferAuditStatus.AUDIT_NOTPASS.getCode().equals(letterAuditstatus)) {
            this.showOptButton(false, offerInfoCardBo, "bar_abandon", "bar_chgvalidtime", "bar_offerletter", "btn_view");
            offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{"approvetime_panel"});
        } else if (OfferAuditStatus.WAIT_RESUBMIT.getCode().equals(letterAuditstatus)) {
            this.showOptButton(false, offerInfoCardBo, "bar_abandon", "bar_offerletter", "btn_view");
        } else if (OfferAuditStatus.ALR_ABANDON.getCode().equals(letterAuditstatus)) {
            this.showOptButton(false, offerInfoCardBo, "bar_abandon", "bar_chgvalidtime", "bar_offerletter", "btn_view");
        } else if (OfferAuditStatus.NULL.getCode().trim().equals(letterAuditstatus)) {
            this.showOptButton(false, offerInfoCardBo, "bar_abandon", "bar_chgvalidtime", "bar_offerletter", "btn_view");
        } else {
            this.showOptButton(false, offerInfoCardBo, "bar_offerletter", "btn_view");
        }
        offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{"approve_panel", "applicant_panel", "applytime_panel", "busunit_panel"});
        if (OfferAuditStatus.TEMPORARY.getCode().equals(letterAuditstatus) || OfferAuditStatus.ALR_ABANDON.getCode().equals(letterAuditstatus) || OfferAuditStatus.NULL.getCode().trim().equals(letterAuditstatus)) {
            offerInfoCardBo.getCardEntry().setChildVisible(false, offerInfoCardBo.getNewEntryRow(), new String[]{"approve_panel"});
        }
        if ((letterBillObj = this.letterBillHelper.queryOneByAuditNo(offerInfoCardBo.getPageRow().getString("letterauditno"))) == null || OfferAuditStatus.ALR_ABANDON.getCode().equals(letterBillObj.getString("billstatus"))) {
            return;
        }
        DynamicObjectCollection auditUsers = letterBillObj.getDynamicObjectCollection("auditusers");
        String approverInfo = "";
        if (auditUsers != null && auditUsers.size() > 0) {
            List<Long> userIds = auditUsers.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
            approverInfo = this.getApproverInfoByUserIds(userIds);
        } else {
            approverInfo = this.getApproverInfo(String.valueOf(letterBillObj.get("id")));
        }
        model.setValue("approve", (Object)approverInfo, offerInfoCardBo.getNewEntryRow());
        Object applyCompleteTime = letterBillObj.get("applycompletetime");
        model.setValue("approvecompletetime", applyCompleteTime != null ? applyCompleteTime : "");
    }

    @Override
    public void initBody(OfferInfoCardBo offerInfoCardBo) {
        super.initBody(offerInfoCardBo);
        offerInfoCardBo.getCardEntry().setChildVisible(true, offerInfoCardBo.getNewEntryRow(), new String[]{"changevaliddesc", "delaydesc"});
    }
}

