/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.changeletter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.business.domain.offer.service.btnservice.abandon.OfferBillAbandonService;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.util.OfferUtils;

public class OfferLetterChangeBtnService {
    public static final List<String> BTN_LIST = new ArrayList<String>(8);
    private static Log logger = LogFactory.getLog(OfferLetterChangeBtnService.class);
    private final OfferServiceHelper offerHelper = OfferServiceHelper.getInstance();
    private final OfferPermService offerPermService = OfferPermService.getInstance();

    public Map<String, Boolean> checkBtnPerm(long businitId, List<String> btns) {
        HashMap<String, Boolean> btnMap = new HashMap<String, Boolean>(8);
        List<String> btnList = btns == null || btns.isEmpty() ? BTN_LIST : btns;
        btnList.forEach(btn -> {
            boolean isHasPerm = this.offerPermService.verifyHasPerm((String)btn, "tso_changeletterbill", (Long)businitId);
            btnMap.put((String)btn, isHasPerm);
        });
        return btnMap;
    }

    public Map<String, Boolean> getBillShowButtons(OperationStatus opStatus, DynamicObject letChBillObj, long offerId) {
        DynamicObject offerObj = this.offerHelper.loadSingle(offerId);
        if (offerObj == null || letChBillObj == null) {
            return Collections.emptyMap();
        }
        long businitId = offerObj.getLong("busunit.id");
        DynamicObject appFileObj = offerObj.getDynamicObject("appfile");
        boolean isInProcess = OfferUtils.checkAppFileInProcess((DynamicObject)appFileObj);
        Map<String, Boolean> btnMap = this.checkBtnPerm(businitId, BTN_LIST);
        logger.info("\u3010OfferLetterChangeBtnService\u3011 \"OfferLetterChangeBtnService\" userId:{}  btnMap : {}", (Object)RequestContext.get().getUserName(), btnMap);
        this.setBtnPerm(opStatus, letChBillObj, isInProcess, btnMap);
        return btnMap;
    }

    private void setBtnPerm(OperationStatus opStatus, DynamicObject letChangeObj, boolean isInProcess, Map<String, Boolean> btnMap) {
        btnMap.forEach((button, perm) -> {
            boolean isShow = false;
            OfferAuditStatus auditStr = OfferAuditStatus.getStatusByCode((String)letChangeObj.getString("billstatus"));
            switch (button) {
                case "bar_modify": {
                    boolean statusMatch = auditStr == OfferAuditStatus.TEMPORARY || auditStr == OfferAuditStatus.WAIT_RESUBMIT;
                    isShow = opStatus != OperationStatus.EDIT && isInProcess && (Boolean)btnMap.get(button) != false && statusMatch;
                    break;
                }
                case "bar_submit": {
                    boolean statusMatch = auditStr == OfferAuditStatus.TEMPORARY || auditStr == OfferAuditStatus.WAIT_RESUBMIT;
                    isShow = isInProcess && (Boolean)btnMap.get(button) != false && statusMatch;
                    break;
                }
                case "bar_save": {
                    boolean statusMatch = auditStr == OfferAuditStatus.TEMPORARY || auditStr == OfferAuditStatus.WAIT_RESUBMIT;
                    isShow = opStatus == OperationStatus.EDIT && isInProcess && (Boolean)btnMap.get(button) != false && statusMatch;
                    break;
                }
                case "bar_cancel": {
                    isShow = opStatus == OperationStatus.EDIT;
                    break;
                }
                case "bar_unsubmit": {
                    boolean statusMatch = auditStr == OfferAuditStatus.ALR_SUBMIT;
                    isShow = opStatus != OperationStatus.EDIT && (Boolean)btnMap.get(button) != false && statusMatch;
                    break;
                }
                case "bar_close": {
                    isShow = opStatus != OperationStatus.EDIT;
                    break;
                }
                case "bar_abandon": {
                    isShow = opStatus == OperationStatus.VIEW && OfferBillAbandonService.getInstance().isWaitResubmit(letChangeObj);
                    break;
                }
                case "bar_delete": {
                    boolean statusMatch = auditStr == OfferAuditStatus.TEMPORARY || auditStr == OfferAuditStatus.NULL;
                    isShow = opStatus != OperationStatus.EDIT && statusMatch;
                    break;
                }
            }
            btnMap.put((String)button, isShow);
        });
    }

    static {
        BTN_LIST.add("bar_modify");
        BTN_LIST.add("bar_save");
        BTN_LIST.add("bar_submit");
        BTN_LIST.add("bar_unsubmit");
        BTN_LIST.add("bar_cancel");
        BTN_LIST.add("bar_close");
        BTN_LIST.add("bar_delete");
        BTN_LIST.add("bar_abandon");
    }

    public static enum Singleton {
        INSTANCE;

        private OfferLetterChangeBtnService instance = new OfferLetterChangeBtnService();

        public OfferLetterChangeBtnService getInstance() {
            return this.instance;
        }
    }
}

