/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.createoffer;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tsrbs.common.utils.CodeRuleUtils;

public class OfferCreateService {
    private static final Log logger = LogFactory.getLog(OfferCreateService.class);
    private OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();

    public void initOfferBatch(List<DynamicObject> offerDynamicObList, Map<String, List<DynamicObject>> otherDynamicMap) {
        try (TXHandle tx = TX.required();){
            try {
                this.offerServiceHelper.save(offerDynamicObList.toArray(new DynamicObject[0]));
                HashMap maps = Maps.newHashMapWithExpectedSize((int)offerDynamicObList.size());
                offerDynamicObList.forEach(dynamicObject -> maps.put(dynamicObject.getLong("appfile"), dynamicObject.getLong("id")));
                this.addOtherPageData(otherDynamicMap, maps);
                OfferGenOpRecordService.getInstance().genNewOfferBaseOpRecord(offerDynamicObList);
            }
            catch (Exception e) {
                logger.error("\u3010OfferCreateService\u3011init batch offer error :", (Throwable)e);
                tx.markRollback();
                String[] numberArray = (String[])offerDynamicObList.stream().map(dynamicObject -> dynamicObject.getString("number")).toArray(String[]::new);
                CodeRuleUtils.releaseBatchCodeRule((String)"tso_somk_offerbase", (DynamicObject[])offerDynamicObList.toArray(new DynamicObject[0]), (String[])numberArray);
                throw new KDBizException(OfferMultilingualConstants.createOfferError());
            }
        }
    }

    private void addOtherPageData(Map<String, List<DynamicObject>> otherDynamicMap, Map<Long, Long> maps) {
        otherDynamicMap.forEach((key, dynamicList) -> {
            dynamicList.forEach(dynamicObject -> this.setFid((DynamicObject)dynamicObject, maps));
            new HRBaseServiceHelper(key).save(dynamicList.toArray(new DynamicObject[0]));
        });
    }

    private void setFid(DynamicObject dynamicObject, Map<Long, Long> maps) {
        Long appId = dynamicObject.getLong("offer");
        Long offerId = maps.get(appId);
        if (offerId == null) {
            throw new KDBizException(OfferMultilingualConstants.createOfferError());
        }
        dynamicObject.set("offer", (Object)offerId);
    }

    public static enum Singleton {
        INSTANCE;

        private final OfferCreateService instance = new OfferCreateService();

        public OfferCreateService getInstance() {
            return this.instance;
        }
    }
}

