/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.createoffer;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.dto.EmployDecisionVo;
import kd.tsc.tso.common.dto.OfferIncentInfoVo;
import kd.tsc.tso.common.dto.OfferJobInfoVo;
import kd.tsc.tso.common.dto.PrpeSalaryInfoVo;
import kd.tsc.tso.common.dto.RegSalaryInfoVo;
import kd.tsc.tso.common.dto.WelfareInfoVo;
import kd.tsc.tso.common.dto.createoffer.req.OfferCreateReqDto;
import kd.tsc.tso.common.enums.TSOPreDataEnum;
import kd.tsc.tso.common.enums.offer.OfferFieldEnableEnum;
import kd.tsc.tso.common.enums.offer.OfferPPeriodTermEnum;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferFieldEditSwitch;
import kd.tsc.tso.common.util.OfferUniqueKeyUtils;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tsrbd.common.enums.ThirdPartSystemEnum;
import kd.tsc.tsrbs.common.enums.DeleteEnum;
import kd.tsc.tsrbs.common.utils.CodeRuleUtils;
import org.apache.commons.lang3.StringUtils;

public class SocialRecruitService {
    private static final Log logger = LogFactory.getLog(SocialRecruitService.class);
    private static final LinkedList<String> PAGE_KEY_LIST = Lists.newLinkedList();
    private final HRBaseServiceHelper ADMINORGHELPER = new HRBaseServiceHelper("haos_adminorghr");
    private static final HRBaseServiceHelper hrPositionHelper = new HRBaseServiceHelper("hbpm_positionhr");
    private static final HRBaseServiceHelper POSITIONHELPER = new HRBaseServiceHelper("tspr_position");

    public void initCandidateDyOb(OfferCreateReqDto reqVo, DynamicObject offerDynamicOb) {
        offerDynamicOb.set("candidatename", (Object)reqVo.getUserName());
        offerDynamicOb.set("candidatenation", (Object)reqVo.getNationalityId());
        offerDynamicOb.set("candidatephone", (Object)reqVo.getPhone());
        offerDynamicOb.set("candidategender", (Object)reqVo.getGender());
        offerDynamicOb.set("candidateage", (Object)reqVo.getAge());
        offerDynamicOb.set("candidateemail", (Object)reqVo.getEmail());
        offerDynamicOb.set("candidateworkage", (Object)reqVo.getWorkage());
    }

    public DynamicObject initOfferDynamicOb(OfferCreateReqDto reqVo) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tso_somk_offerbase");
        DynamicObject appFileObject = AppFileHelper.queryOne((long)reqVo.getAppFileId());
        DynamicObject positionObject = appFileObject.getDynamicObject("position");
        CodeRuleUtils.generateOneCodeRule((String)"number", (String)"tso_somk_offerbase", (DynamicObject)dynamicObject);
        dynamicObject.set("appfile", (Object)reqVo.getAppFileId());
        dynamicObject.set("busunit", (Object)reqVo.getBusunitId());
        dynamicObject.set("name", (Object)(reqVo.getUserName() + OfferMultilingualConstants.getOfferNameSuffix()));
        dynamicObject.set("status", (Object)OfferStatus.PRE_APPLY.getCode());
        dynamicObject.set("isdelete", (Object)DeleteEnum.NO_DELETE.getCode());
        dynamicObject.set("tpsys", (Object)ThirdPartSystemEnum.KD.getTpSys());
        dynamicObject.set("recrutyp", (Object)positionObject.getDynamicObject("reccategory"));
        OfferUtils.updateOperateInfo((DynamicObject)dynamicObject);
        String primaryIndex = OfferUniqueKeyUtils.getPrimaryIndex((DynamicObject)dynamicObject, (OfferUniqueKeyUtils.Strategy)OfferUniqueKeyUtils.Strategy.INIT);
        dynamicObject.set("pindexes", (Object)primaryIndex);
        return dynamicObject;
    }

    private void initOfferBaseData(Map<Long, EmployDecisionVo> employMap, Map<String, List<DynamicObject>> dynamicMap, List<DynamicObject> offerDynamicObList) {
        offerDynamicObList.forEach(offerObj -> {
            long appfileId = offerObj.getLong("appfile");
            EmployDecisionVo employDecisionVo = (EmployDecisionVo)employMap.get(appfileId);
            logger.info("\u3010SocialRecruitBiz\u3011print hire data for appFile \"{}\" employDecisionVo \"{}\"", (Object)appfileId, (Object)employDecisionVo);
            if (employDecisionVo == null) {
                this.getPostionInfo((DynamicObject)offerObj, dynamicMap);
            } else {
                this.initOfferDataForEmploy((DynamicObject)offerObj, employDecisionVo, dynamicMap);
            }
        });
    }

    private void getPostionInfo(DynamicObject offerDynamic, Map<String, List<DynamicObject>> otherDynamicMap) {
        long appfileId = offerDynamic.getLong("appfile");
        DynamicObject appFileObject = AppFileHelper.queryOne((long)appfileId);
        DynamicObject positionObject = appFileObject.getDynamicObject("position");
        OfferFieldEditSwitch fieldSorce = OfferFieldEditSwitch.init();
        SocialRecruitService.initPositionObject(offerDynamic, positionObject, appFileObject);
        SocialRecruitService.initJobObject(offerDynamic, positionObject, fieldSorce);
        SocialRecruitService.initRegsaObject(offerDynamic, positionObject);
        SocialRecruitService.initPrpesaObject(offerDynamic, positionObject);
        SocialRecruitService.initWelfareObject(offerDynamic, positionObject);
        SocialRecruitService.initOfferIncentInfo(offerDynamic, positionObject);
        HashMap fieldSrcMap = Maps.newHashMapWithExpectedSize((int)16);
        fieldSrcMap.put("tso_somk_offerbase", fieldSorce.getFieldEditSetting());
        this.initOtherPage(otherDynamicMap, appFileObject.getLong("id"), fieldSrcMap);
    }

    private void initOfferDataForEmploy(DynamicObject offerObj, EmployDecisionVo employDecisionVo, Map<String, List<DynamicObject>> dynamicMap) {
        OfferFieldEditSwitch fieldSorce = OfferFieldEditSwitch.init();
        DynamicObject appFileObject = AppFileHelper.queryOne((long)employDecisionVo.getAppFileId());
        DynamicObject positionObject = appFileObject.getDynamicObject("position");
        SocialRecruitService.initPositionObject(offerObj, positionObject, appFileObject);
        this.initJobObjectForEmploy(offerObj, employDecisionVo, fieldSorce, positionObject);
        this.initOfferEtInfoForEmploy(offerObj, employDecisionVo, fieldSorce);
        this.initRegSalaryInfo(offerObj, employDecisionVo, fieldSorce);
        this.initPrpeSalaryInfo(offerObj, employDecisionVo, fieldSorce);
        this.initWelfareInfo(offerObj, employDecisionVo, fieldSorce);
        HashMap fieldSrcMap = Maps.newHashMapWithExpectedSize((int)16);
        fieldSrcMap.put("tso_somk_offerbase", fieldSorce.getFieldEditSetting());
        this.initOtherPage(dynamicMap, appFileObject.getLong("id"), fieldSrcMap);
    }

    private void initRegSalaryInfo(DynamicObject offerObj, EmployDecisionVo employDecisionVo, OfferFieldEditSwitch fieldEditSwitch) {
        RegSalaryInfoVo regSalaryInfoVo = Optional.ofNullable(employDecisionVo.getRegSalaryInfoVo()).orElseGet(RegSalaryInfoVo::new);
        Map fieldEditMap = fieldEditSwitch.getFieldEditSetting();
        this.updateFieldEditSwitch(offerObj, "regpaycu", regSalaryInfoVo.getPaycu(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "regbwages", regSalaryInfoVo.getBwages(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "regpossub", regSalaryInfoVo.getPossub(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "regprp", regSalaryInfoVo.getPrp(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "regmonthly", regSalaryInfoVo.getMonthlysalary(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "regyearbonus", regSalaryInfoVo.getYearbonus(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "regremark", regSalaryInfoVo.getRemark(), fieldEditMap);
    }

    private void initPrpeSalaryInfo(DynamicObject offerObj, EmployDecisionVo employDecisionVo, OfferFieldEditSwitch fieldEditSwitch) {
        PrpeSalaryInfoVo prpeSalaryInfoVo = Optional.ofNullable(employDecisionVo.getPrpeSalaryInfoVo()).orElseGet(PrpeSalaryInfoVo::new);
        Map fieldEditMap = fieldEditSwitch.getFieldEditSetting();
        this.updateFieldEditSwitch(offerObj, "prpepaycu", prpeSalaryInfoVo.getPaycu(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "prpesacaltype", prpeSalaryInfoVo.getSacaltype(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "prpebwages", prpeSalaryInfoVo.getBwages(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "prpepossub", prpeSalaryInfoVo.getPossub(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "prpeprp", prpeSalaryInfoVo.getPrp(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "prpesaratio", prpeSalaryInfoVo.getSaratio(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "prpemonthly", prpeSalaryInfoVo.getMonthlysalary(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "prperemark", prpeSalaryInfoVo.getRemark(), fieldEditMap);
    }

    private void initWelfareInfo(DynamicObject offerObj, EmployDecisionVo employDecisionVo, OfferFieldEditSwitch fieldSorce) {
        WelfareInfoVo welfareInfoVo = Optional.ofNullable(employDecisionVo.getWelfareInfoVo()).orElseGet(WelfareInfoVo::new);
        Map fieldEditMap = fieldSorce.getFieldEditSetting();
        this.updateFieldEditSwitch(offerObj, "welpaycu", welfareInfoVo.getPaycu(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "trafaow", welfareInfoVo.getTrafaow(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "trafaowunit", welfareInfoVo.getTrafaowu(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "tietaryaow", welfareInfoVo.getTietaryaow(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "tietaryaowunit", welfareInfoVo.getTietaryaowu(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "municataow", welfareInfoVo.getMunicataow(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "municataowunit", welfareInfoVo.getMunicataowu(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "rentalaow", welfareInfoVo.getRentalaow(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "rentalaowunit", welfareInfoVo.getRentalaowu(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "housaow", welfareInfoVo.getHousaow(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "housaowunit", welfareInfoVo.getHousaowu(), fieldEditMap);
        this.updateFieldEditSwitch(offerObj, "welremark", welfareInfoVo.getRemark(), fieldEditMap);
    }

    private void initOfferEtInfoForEmploy(DynamicObject offerObj, EmployDecisionVo employDecisionVo, OfferFieldEditSwitch fieldEditSwitch) {
        OfferIncentInfoVo offerIncentInfoVo = Optional.ofNullable(employDecisionVo.getOfferIncentInfoVo()).orElseGet(OfferIncentInfoVo::new);
        Map jobFieldMap = fieldEditSwitch.getFieldEditSetting();
        this.updateFieldEditSwitch(offerObj, "rsnum", offerIncentInfoVo.getRsnum(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "rsunit", offerIncentInfoVo.getRsunit(), jobFieldMap);
        this.setDefaultValue(offerObj, "rsunit", offerIncentInfoVo.getRsunit(), OfferMultilingualConstants.getSharesUnit());
        this.updateFieldEditSwitch(offerObj, "rsyearvalue", offerIncentInfoVo.getRsYearValue(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "rsyearcu", offerIncentInfoVo.getRsYearValueCuId(), jobFieldMap);
        this.setDefaultValue(offerObj, "rsyearcu", offerIncentInfoVo.getRsYearValueCuId(), 1);
        this.updateFieldEditSwitch(offerObj, "optionnum", offerIncentInfoVo.getOptionNum(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "optionunit", offerIncentInfoVo.getOptionUnit(), jobFieldMap);
        this.setDefaultValue(offerObj, "optionunit", offerIncentInfoVo.getOptionUnit(), OfferMultilingualConstants.getSharesUnit());
        this.updateFieldEditSwitch(offerObj, "optionyearvalue", offerIncentInfoVo.getOptionYearValue(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "optioncu", offerIncentInfoVo.getOptionCuId(), jobFieldMap);
        this.setDefaultValue(offerObj, "optioncu", offerIncentInfoVo.getOptionCuId(), OfferMultilingualConstants.getSharesUnit());
        this.updateFieldEditSwitch(offerObj, "etremark", offerIncentInfoVo.getRemark(), jobFieldMap);
    }

    private void setDefaultValue(DynamicObject dynamicObject, String key, Object value, Object defValue) {
        if (value == null) {
            dynamicObject.set(key, defValue);
        } else if (value instanceof String && StringUtils.isEmpty((CharSequence)value.toString())) {
            dynamicObject.set(key, defValue);
        }
    }

    private void initJobObjectForEmploy(DynamicObject offerObj, EmployDecisionVo employDecisionVo, OfferFieldEditSwitch fieldEditSwitch, DynamicObject positionObject) {
        OfferJobInfoVo offerJobInfoVo = Optional.ofNullable(employDecisionVo.getOfferJobInfoVo()).orElseGet(OfferJobInfoVo::new);
        Map jobFieldMap = fieldEditSwitch.getFieldEditSetting();
        this.updateFieldEditSwitch(offerObj, "peposition", offerJobInfoVo.getPePositionId(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "peadminorg", offerJobInfoVo.getPeAdminOrgId(), jobFieldMap);
        DynamicObject recrusceneObj = POSITIONHELPER.queryOne("recruscene", positionObject.get("id"));
        offerObj.set("recruscene", recrusceneObj.get("recruscene"));
        if (offerJobInfoVo.getPeAdminOrgId() != 0L) {
            Optional.ofNullable(this.ADMINORGHELPER.queryOne("company", (Object)offerJobInfoVo.getPeAdminOrgId())).ifPresent(this.setCompanyValue(offerObj));
        }
        this.updateFieldEditSwitch(offerObj, "jobscm", offerJobInfoVo.getJobscm(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "pejob", offerJobInfoVo.getPeJobId(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "joblevel", offerJobInfoVo.getJobLevelId(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "jobgrade", offerJobInfoVo.getJobGradeId(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "positiontype", offerJobInfoVo.getPositionTypeId(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "laborreltypecls", offerJobInfoVo.getLaborreltypeclsId(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "labrelstatuscls", offerJobInfoVo.getLabrelstatusclsId(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "ishaveperiodterm", offerJobInfoVo.getIshaveperiodterm(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "pperiodterm", offerJobInfoVo.getpPeriodTerm(), jobFieldMap);
        this.updateFieldEditSwitch(offerObj, "pperiodtermunit", offerJobInfoVo.getpPeriodTermUnit(), jobFieldMap);
        SocialRecruitService.setWorkAddress(positionObject, offerObj);
    }

    private static void setWorkAddress(DynamicObject positionObject, DynamicObject jobObject) {
        if (positionObject.getDynamicObjectCollection("workaddr") != null && positionObject.getDynamicObjectCollection("workaddr").size() > 1) {
            return;
        }
        Optional.ofNullable(positionObject.getDynamicObjectCollection("workaddr")).filter(dynamicObjects -> dynamicObjects.size() > 0).ifPresent(dynamic -> {
            HRBaseServiceHelper workAddressHelper = new HRBaseServiceHelper("tsrbd_workaddr");
            DynamicObject workObject = workAddressHelper.queryOne((Object)((DynamicObject)dynamic.get(0)).getLong("fbasedataid_id"));
            jobObject.set("placework", (Object)workObject.getLong("id"));
        });
    }

    private Consumer<DynamicObject> setCompanyValue(DynamicObject jobObject) {
        return dynamicObject -> {
            DynamicObject companyObj = dynamicObject.getDynamicObject("company");
            logger.info("\u3010SocialRecruitBiz\u3011print company  \"{}\"", (Object)companyObj);
            if (companyObj == null) {
                return;
            }
            DynamicObject orgObj = this.ADMINORGHELPER.queryOne("id,name", (Object)companyObj.getLong("id"));
            logger.info("\u3010SocialRecruitBiz\u3011print company object \"{}\" and id \"{}\"", (Object)companyObj, orgObj != null ? Long.valueOf(orgObj.getLong("id")) : "");
            if (orgObj == null) {
                return;
            }
            jobObject.set("pecompany", (Object)orgObj.getLong("id"));
        };
    }

    private void updateFieldEditSwitch(DynamicObject jobObject, String field, Object value, Map<String, Integer> jobFieldMap) {
        jobObject.set(field, value);
        jobFieldMap.put(field, OfferFieldEnableEnum.NOT_ENABLE.ordinal());
    }

    private Map<String, List<DynamicObject>> callPosition(List<DynamicObject> offerDynamicObList) {
        HashMap dynamicMap = Maps.newHashMapWithExpectedSize((int)8);
        offerDynamicObList.forEach(offerDynamic -> this.getPostionInfo((DynamicObject)offerDynamic, dynamicMap));
        return dynamicMap;
    }

    public static void initWelfareObject(DynamicObject offerDynamic, DynamicObject positionObject) {
        DynamicObject currencyDynamic = positionObject.getDynamicObject("currency");
        offerDynamic.set("welpaycu", (Object)(currencyDynamic == null ? 1L : currencyDynamic.getLong("id")));
        offerDynamic.set("trafaowunit", (Object)OfferPPeriodTermEnum.DAY.getCode());
        offerDynamic.set("tietaryaowunit", (Object)OfferPPeriodTermEnum.DAY.getCode());
        offerDynamic.set("municataowunit", (Object)OfferPPeriodTermEnum.DAY.getCode());
        offerDynamic.set("rentalaowunit", (Object)OfferPPeriodTermEnum.DAY.getCode());
        offerDynamic.set("housaowunit", (Object)OfferPPeriodTermEnum.DAY.getCode());
    }

    public static void initPrpesaObject(DynamicObject offerDynamic, DynamicObject positionObject) {
        DynamicObject currencyDynamic = positionObject.getDynamicObject("currency");
        offerDynamic.set("prpepaycu", (Object)(currencyDynamic == null ? 1L : currencyDynamic.getLong("id")));
    }

    public static void initRegsaObject(DynamicObject offerDynamic, DynamicObject positionObject) {
        DynamicObject currencyDynamic = positionObject.getDynamicObject("currency");
        offerDynamic.set("regpaycu", (Object)(currencyDynamic == null ? 1L : currencyDynamic.getLong("id")));
    }

    private void initOtherPage(Map<String, List<DynamicObject>> dynamicMap, Long appFileId, Map<String, Map> fieldSrcMap) {
        PAGE_KEY_LIST.forEach(pageKey -> {
            List dynamicObjectList = Optional.ofNullable(dynamicMap.get(pageKey)).orElseGet(Lists::newArrayList);
            this.initFieldEditSwitch((String)pageKey, fieldSrcMap, appFileId, dynamicObjectList);
            dynamicMap.put((String)pageKey, dynamicObjectList);
        });
    }

    private void initOfferCont(String pageKey, Long appFileId, List<DynamicObject> dynamicObjectList) {
        if (!"tso_offercont".equals(pageKey)) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)pageKey);
        dynamicObject.set("offer", (Object)appFileId);
        OfferUtils.updateCreateInfo((DynamicObject)dynamicObject);
        dynamicObjectList.add(dynamicObject);
    }

    private void initFieldEditSwitch(String pageKey, Map<String, Map> fieldWitMap, long appFileId, List dynamicObjectList) {
        if (!"tso_offerfieswit".equals(pageKey)) {
            return;
        }
        for (Map.Entry<String, Map> entry : fieldWitMap.entrySet()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)pageKey);
            dynamicObject.set("offer", (Object)appFileId);
            dynamicObject.set("pagekey", (Object)entry.getKey());
            dynamicObject.set("displaycontrol", JSON.toJSON((Object)entry.getValue()));
            dynamicObjectList.add(dynamicObject);
        }
    }

    public static void initOfferIncentInfo(DynamicObject offerDynamic, DynamicObject positionObject) {
        DynamicObject currencyDynamic = positionObject.getDynamicObject("currency");
        long currency = currencyDynamic == null ? 1L : currencyDynamic.getLong("id");
        offerDynamic.set("rsunit", (Object)OfferMultilingualConstants.getSharesUnit());
        offerDynamic.set("rsyearcu", (Object)currency);
        offerDynamic.set("optionunit", (Object)OfferMultilingualConstants.getSharesUnit());
        offerDynamic.set("optioncu", (Object)currency);
        offerDynamic.set("rsnum", (Object)0);
        offerDynamic.set("rsyearvalue", (Object)0);
        offerDynamic.set("optionnum", (Object)0);
        offerDynamic.set("optionyearvalue", (Object)0);
    }

    public static void initJobObject(DynamicObject offerDynamic, DynamicObject positionObject, OfferFieldEditSwitch fieldEditSwitch) {
        Optional.ofNullable(positionObject.getDynamicObject("entryjob")).ifPresent(dynamic -> {
            offerDynamic.set("pejob", dynamic);
            fieldEditSwitch.addFieldEditSetting("joblevel", OfferFieldEnableEnum.ENABLE);
            fieldEditSwitch.addFieldEditSetting("jobgrade", OfferFieldEnableEnum.ENABLE);
        });
        Optional.ofNullable(positionObject.getDynamicObject("entryposition")).ifPresent(dynamic -> {
            offerDynamic.set("peposition", dynamic);
            DynamicObject hrPositionObj = hrPositionHelper.queryOne("adminorg", dynamic.get("id"));
            DynamicObject orgObj = hrPositionObj.getDynamicObject("adminorg");
            offerDynamic.set("peadminorg", (Object)orgObj);
            offerDynamic.set("pecompany", orgObj != null ? orgObj.getDynamicObject("company") : null);
            fieldEditSwitch.addFieldEditSetting("peadminorg", OfferFieldEnableEnum.NOT_ENABLE);
            fieldEditSwitch.addFieldEditSetting("pecompany", OfferFieldEnableEnum.NOT_ENABLE);
        });
        DynamicObject recrusceneObj = POSITIONHELPER.queryOne("recruscene", positionObject.get("id"));
        offerDynamic.set("recruscene", recrusceneObj.get("recruscene"));
        if (recrusceneObj.get("recruscene") == null) {
            fieldEditSwitch.addFieldEditSetting("recruscene", OfferFieldEnableEnum.ENABLE);
        }
        SocialRecruitService.setWorkAddress(positionObject, offerDynamic);
        Optional.ofNullable(positionObject.getDynamicObject("holdofftyp")).ifPresent(dynamic -> offerDynamic.set("positiontype", dynamic));
        offerDynamic.set("pperiodtermunit", (Object)OfferPPeriodTermEnum.MONTH.getCode());
        offerDynamic.set("jobscm", (Object)positionObject.getLong("jobscm.id"));
        if (positionObject.getDynamicObject("laborreltype") == null) {
            fieldEditSwitch.addFieldEditSetting("flex_haveperiodterm", OfferFieldEnableEnum.NOT_ENABLE);
        }
        Optional.ofNullable(positionObject.getDynamicObject("laborreltype")).ifPresent(dynamic -> SocialRecruitService.doLaborreltypeHandle(offerDynamic, fieldEditSwitch, dynamic));
        offerDynamic.set("postassignmode", (Object)"2");
    }

    private static void doLaborreltypeHandle(DynamicObject offerDynamic, OfferFieldEditSwitch fieldEditSwitch, DynamicObject dynamic) {
        long laborreltypeId = dynamic.getLong("id");
        offerDynamic.set("laborreltypecls", (Object)laborreltypeId);
        if (TSOPreDataEnum.LABORRELRELTYPECLS_REHIRE.getId() == laborreltypeId) {
            offerDynamic.set("ishaveperiodterm", (Object)"0");
            offerDynamic.set("labrelstatuscls", (Object)TSOPreDataEnum.LABRESTATULCLS_ONBOARDING.getId());
            fieldEditSwitch.addFieldEditSetting("flex_haveperiodterm", OfferFieldEnableEnum.NOT_ENABLE);
        } else {
            offerDynamic.set("ishaveperiodterm", (Object)"1");
            offerDynamic.set("labrelstatuscls", (Object)TSOPreDataEnum.LABRESTATULCLS_PROBATION.getId());
            fieldEditSwitch.addFieldEditSetting("pperiodterm", OfferFieldEnableEnum.ENABLE);
            fieldEditSwitch.addFieldEditSetting("pperiodtermunit", OfferFieldEnableEnum.ENABLE);
        }
    }

    public static void initPositionObject(DynamicObject offerDynamic, DynamicObject positionObject, DynamicObject appFileObject) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_positionmanage");
        offerDynamic.set("adminorg", (Object)appFileObject.getDynamicObject("adminorg"));
        offerDynamic.set("recruposi", (Object)positionObject);
        QFilter boFilter = new QFilter("position", "=", positionObject.get("id"));
        DynamicObject positionManageObj = serviceHelper.queryOne("posprin", boFilter);
        if (positionManageObj == null) {
            return;
        }
        DynamicObjectCollection posprinObject = positionManageObj.getDynamicObjectCollection("posprin");
        posprinObject.forEach(SocialRecruitService.addDeliver(offerDynamic));
    }

    private static Consumer<DynamicObject> addDeliver(DynamicObject dynamicObject) {
        return object -> {
            DynamicObject deliverObject = dynamicObject.getDynamicObjectCollection("deliver").addNew();
            object.getDataEntityType().getProperties().stream().filter(property -> !"pkid".equals(property.getName())).forEach(property -> deliverObject.set(property.getName(), object.get(property.getName())));
        };
    }

    public Map<String, List<DynamicObject>> getOfferBaseInfo(List<DynamicObject> offerDynamicObList, List<OfferCreateReqDto> reqVos) {
        List appFileIdList = reqVos.stream().map(OfferCreateReqDto::getAppFileId).collect(Collectors.toList());
        HashMap employMap = Maps.newHashMapWithExpectedSize((int)4);
        logger.info("\u3010SocialRecruitBiz\u3011print call salary return value \"{}\" for id list \"{}\"", (Object)employMap, appFileIdList);
        if (employMap.isEmpty()) {
            return this.callPosition(offerDynamicObList);
        }
        HashMap dynamicMap = Maps.newHashMapWithExpectedSize((int)4);
        this.initOfferBaseData(employMap, dynamicMap, offerDynamicObList);
        return dynamicMap;
    }

    static {
        PAGE_KEY_LIST.add("tso_offerletter");
        PAGE_KEY_LIST.add("tso_offercont");
        PAGE_KEY_LIST.add("tso_offerfieswit");
    }

    public static enum Singleton {
        INSTANCE;

        private final SocialRecruitService instance = new SocialRecruitService();

        public SocialRecruitService getInstance() {
            return this.instance;
        }
    }
}

