/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.head;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferHeadInfoBO;
import kd.tsc.tso.business.domain.offer.helper.OfferStatusHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.constants.offer.OfferHeadInfoConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.offer.status.IOfferStatus;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferShowParamUtils;

public class OfferHeadFormPluginService
implements OfferHeadInfoConstants {
    public void handleCddNameBeforeClickEvt(BeforeClickEvent beforeClickEvent, IFormView formView) {
        Button button = (Button)beforeClickEvent.getSource();
        if (!HRStringUtils.equals((String)button.getKey(), (String)"appfilevector")) {
            return;
        }
        DynamicObject offer = formView.getModel().getDataEntity(true).getDynamicObject("offer");
        if (HRObjectUtils.isEmpty((Object)offer)) {
            return;
        }
        boolean hasAppFilePerm = OfferPermService.getInstance().verifyHasAppFilePerm(offer);
        if (!hasAppFilePerm) {
            beforeClickEvent.setCancel(true);
            formView.showErrorNotification(OfferMultilingualConstants.hasNoAppFilePerm());
        }
    }

    public void handleCddNameLblClickEvt(EventObject eventObject, IFormView formView) {
        Button button = (Button)eventObject.getSource();
        if (!HRStringUtils.equals((String)button.getKey(), (String)"appfilevector")) {
            return;
        }
        DynamicObject dataEntity = formView.getModel().getDataEntity(true);
        DynamicObject offerInfo = dataEntity.getDynamicObject("offer");
        DynamicObject appFile = offerInfo.getDynamicObject("appfile");
        FormShowParameter appFileParam = OfferShowParamUtils.getAppFileParam((Long)appFile.getLong("id"), (String)formView.getPageId());
        formView.showForm(appFileParam);
    }

    public void initPageInfo(IFormView formView, OfferHeadInfoBO headInfoBO) {
        Label applicantLbl = (Label)formView.getControl("applicant");
        applicantLbl.setText(headInfoBO.getApplicantName());
        Label applyTimeLbl = (Label)formView.getControl("applytime");
        applyTimeLbl.setText(headInfoBO.getApplyTime());
        Label billNoLbl = (Label)formView.getControl("number");
        billNoLbl.setText(headInfoBO.getNumber());
        Label recruitTypeLbl = (Label)formView.getControl("recrutyp");
        recruitTypeLbl.setText(headInfoBO.getRecruitType());
        this.updateOfferStatusLabel(formView, headInfoBO.getOfferStatus());
        Label busUnitLbl = (Label)formView.getControl("busunit");
        if (Objects.nonNull(busUnitLbl)) {
            busUnitLbl.setText(headInfoBO.getBusUnit());
        }
    }

    private void updateOfferStatusLabel(IFormView formView, IOfferStatus iOfferStatus) {
        String lblName = "";
        if (iOfferStatus instanceof OfferStatus) {
            OfferStatus offerStatus = (OfferStatus)iOfferStatus;
            lblName = offerStatus.getName();
        }
        if (iOfferStatus instanceof OfferLetterStatus) {
            lblName = ((OfferLetterStatus)iOfferStatus).getName();
        }
        if (iOfferStatus instanceof OfferLetterReplyStatus) {
            OfferLetterReplyStatus replyStatus = (OfferLetterReplyStatus)iOfferStatus;
            lblName = replyStatus.getName();
        }
        if (iOfferStatus instanceof OfferLetterDataStatus) {
            OfferLetterDataStatus validStatus = (OfferLetterDataStatus)iOfferStatus;
            lblName = validStatus.getName();
        }
        if (iOfferStatus instanceof OfferAuditStatus) {
            OfferAuditStatus auditStatus = (OfferAuditStatus)iOfferStatus;
            lblName = auditStatus.getName();
        }
        Label statusLbl = (Label)formView.getControl("status");
        statusLbl.setText(lblName);
        formView.updateControlMetadata("status", OfferStatusHelper.getStatusMetaDataMap(iOfferStatus));
    }

    public static OfferHeadFormPluginService getInstance() {
        return Instance.INSTANCE;
    }

    private OfferHeadFormPluginService() {
    }

    private static class Instance {
        private static final OfferHeadFormPluginService INSTANCE = new OfferHeadFormPluginService();

        private Instance() {
        }
    }
}

