/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.head;

import java.util.Date;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferHeadInfoBO;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.common.constants.offer.OfferHeadInfoConstants;
import kd.tsc.tso.common.enums.offer.status.IOfferStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferHeadInfoService
implements OfferHeadInfoConstants {
    public Long getPkId(IFormView headInfoView) {
        Long pkId = 0L;
        Object id = headInfoView.getFormShowParameter().getCustomParam("id");
        if (Objects.nonNull(id)) {
            pkId = (Long)id;
        }
        return pkId;
    }

    public OfferHeadInfoBO getOfferHeadInfoBoForBase(IFormView headInfoView) {
        Object copy = headInfoView.getParentView().getFormShowParameter().getCustomParam("copy");
        if (Objects.nonNull(copy) && "1".equals(copy.toString())) {
            return this.getHeadInfoForCopy(headInfoView);
        }
        DynamicObject offer = OfferServiceHelper.getInstance().queryOne(this.getPkId(headInfoView));
        OfferHeadInfoBO headInfoBO = new OfferHeadInfoBO();
        headInfoBO.setNumber(offer.getString("number"));
        DynamicObject recruitType = offer.getDynamicObject("recrutyp");
        if (!HRObjectUtils.isEmpty((Object)recruitType)) {
            headInfoBO.setRecruitType(recruitType.getString("name"));
        }
        OperationStatus pageStatus = headInfoView.getFormShowParameter().getStatus();
        headInfoBO.setApplicantName(this.getApplicantName(pageStatus, offer));
        headInfoBO.setApplyTime(this.getApplyTime(pageStatus, offer));
        headInfoBO.setOfferStatus(this.getStatus(offer));
        headInfoBO.setBusUnit(this.getBusUnit(offer));
        return headInfoBO;
    }

    private String getBusUnit(DynamicObject offer) {
        if (HRObjectUtils.isEmpty((Object)offer)) {
            return "";
        }
        return offer.getString("busunit.name");
    }

    public OfferHeadInfoBO getOfferHeadInfoBoForBill(IFormView headInfoView) {
        Date applyTime;
        DynamicObject applicant;
        Long pkId = this.getPkId(headInfoView);
        String properties = OfferUtils.getSelectProperties((String[])new String[]{"entryentity.offer", "billno", "applicant", "applytime", "billstatus", "busunit.name"});
        DynamicObject offerBillDt = OfferBillServiceHelper.getInstance().queryOne(properties, pkId);
        DynamicObject offer = OfferBillServiceHelper.getInstance().getOfferByBillDt(offerBillDt);
        OfferHeadInfoBO headInfoBO = new OfferHeadInfoBO();
        headInfoBO.setNumber(offerBillDt.getString("billno"));
        DynamicObject recruitType = offer.getDynamicObject("recrutyp");
        if (!HRObjectUtils.isEmpty((Object)recruitType)) {
            headInfoBO.setRecruitType(recruitType.getString("name"));
        }
        if (!HRObjectUtils.isEmpty((Object)(applicant = offerBillDt.getDynamicObject("applicant")))) {
            headInfoBO.setApplicantName(applicant.getString("name"));
        }
        if ((applyTime = offerBillDt.getDate("applytime")) != null) {
            headInfoBO.setApplyTime(HRInteDateTimeUtil.formatDate((String)offerBillDt.getDynamicObjectType().getName(), (String)"applytime", (Date)applyTime));
        }
        headInfoBO.setOfferStatus((IOfferStatus)OfferStatusUtil.getOfferAuditStatus((DynamicObject)offerBillDt));
        headInfoBO.setBusUnit(this.getBusUnit(offerBillDt));
        return headInfoBO;
    }

    public OfferHeadInfoBO getOfferHeadInfoBoForNotice(IFormView headInfoView) {
        DynamicObject offer = OfferServiceHelper.getInstance().queryOne(this.getPkId(headInfoView));
        OfferHeadInfoBO headInfoBO = new OfferHeadInfoBO();
        headInfoBO.setRecruitType(offer.getDynamicObject("recrutyp").getString("name"));
        headInfoBO.setOfferStatus(this.getStatus(offer));
        headInfoBO.setNumber(offer.getString("number"));
        headInfoBO.setApplyTime(this.getApplyTime(OperationStatus.VIEW, offer));
        headInfoBO.setApplicantName(this.getApplicantName(OperationStatus.VIEW, offer));
        headInfoBO.setBusUnit(this.getBusUnit(offer));
        return headInfoBO;
    }

    public IOfferStatus getStatus(DynamicObject offerInfo) {
        OfferStatus offerStatus = OfferStatusUtil.getOfferStatus((DynamicObject)offerInfo);
        if (offerStatus == OfferStatus.APPLY_PASS) {
            OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatusByOffer((DynamicObject)offerInfo);
            if (letterStatus == OfferLetterStatus.ALR_SEND) {
                return OfferStatusUtil.getLetterReplyStatusByOffer((DynamicObject)offerInfo);
            }
            return letterStatus;
        }
        return offerStatus;
    }

    public String getApplyTime(OperationStatus pageStatus, DynamicObject dynamicObject) {
        if (!OfferUtils.checkHasProperty((DynamicObject)dynamicObject, (String)"applytime")) {
            return "-";
        }
        Date applyTime = null;
        if (dynamicObject.getDate("applytime") == null) {
            if (pageStatus == OperationStatus.EDIT) {
                applyTime = DateUtils.nowDateTime();
            }
        } else {
            applyTime = dynamicObject.getDate("applytime");
        }
        if (Objects.isNull(applyTime)) {
            return "-";
        }
        return HRInteDateTimeUtil.formatDate((String)"tso_somk_offerbase", (String)"applytime", (Date)applyTime);
    }

    public String getApplicantName(OperationStatus pageStatus, DynamicObject dynamicObject) {
        if (!OfferUtils.checkHasProperty((DynamicObject)dynamicObject, (String)"applicant")) {
            return "-";
        }
        String applicantName = "-";
        DynamicObject applicant = dynamicObject.getDynamicObject("applicant");
        if (Objects.isNull(applicant)) {
            if (pageStatus == OperationStatus.EDIT) {
                applicantName = RequestContext.get().getUserName();
            }
        } else {
            applicantName = applicant.getString("name");
        }
        return applicantName;
    }

    private OfferHeadInfoBO getHeadInfoForCopy(IFormView formView) {
        OfferHeadInfoBO headInfoBO = new OfferHeadInfoBO();
        headInfoBO.setApplicantName(TSCRequestContext.getUserName());
        headInfoBO.setApplyTime(HRInteDateTimeUtil.formatDate((String)"tso_somk_offerbase", (String)"applytime", (Date)DateUtils.nowDateTime()));
        String number = (String)formView.getFormShowParameter().getCustomParam("number");
        if (HRStringUtils.isNotEmpty((String)number)) {
            headInfoBO.setNumber(number);
        }
        headInfoBO.setOfferStatus((IOfferStatus)OfferStatus.PRE_APPLY);
        DynamicObject dataEntity = formView.getParentView().getModel().getDataEntity(true);
        headInfoBO.setRecruitType(dataEntity.getDynamicObject("recrutyp").getString("name"));
        DynamicObject offerDy = (DynamicObject)formView.getModel().getValue("offer");
        headInfoBO.setBusUnit(HRObjectUtils.isEmpty((Object)offerDy) || HRStringUtils.isEmpty((String)offerDy.getString("busunit.name")) ? "" : offerDy.getString("busunit.name"));
        return headInfoBO;
    }

    public static OfferHeadInfoService getInstance() {
        return Instance.HEAD_INFO_INSTANCE;
    }

    private OfferHeadInfoService() {
    }

    private static class Instance {
        private static final OfferHeadInfoService HEAD_INFO_INSTANCE = new OfferHeadInfoService();

        private Instance() {
        }
    }
}

