/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.letter;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.mq.model.OfferChangeModel;
import kd.tsc.tso.business.domain.mq.producer.OfferChangeProducer;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.induction.LaunchInductionStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tspr.business.domain.intreco.service.IntrecoBusinessHelper;
import kd.tsc.tsrbd.common.constants.TSCBaseConstants;
import kd.tsc.tsrbd.common.utils.DateUtils;

public final class OfferLetterService {
    private static final Log log = LogFactory.getLog(OfferLetterService.class);
    private final OfferLetterServiceHelper letterHelper = OfferLetterServiceHelper.getInstance();
    private final OfferServiceHelper offerHelper = OfferServiceHelper.getInstance();
    private final OfferGenOpRecordService genOpRecordService = OfferGenOpRecordService.getInstance();
    private OfferParamConfigService offerParamConfigService = OfferParamConfigService.getInstance();

    public boolean acceptOffer(Long offerLetterId) {
        int updateCount;
        DynamicObject letterObj = this.letterHelper.loadSingle(offerLetterId);
        this.doCheckLetterStatus(letterObj);
        letterObj.set("replystatus", (Object)OfferLetterReplyStatus.ALR_ACCEPT.getCode());
        String updateSql = "update T_TSO_OFFERLETTER set FREPLYSTATUSID = ?, FMODIFYTIME = ?, FREPLYTIME = ? where FID = ? and FDATASTATUSID = ? and FSTATUSID = ?";
        Object[] objects = new Object[]{OfferLetterReplyStatus.ALR_ACCEPT.getCode(), new Date(), new Date(), letterObj.getLong("id"), OfferLetterDataStatus.TAKE_EFFECT.getCode(), OfferLetterStatus.ALR_SEND.getCode()};
        String updateOfferASql = "UPDATE T_TSO_OFFER_A SET FLAUNCHINDSTATUS = ? where FID = ? ";
        Object[] offerAValues = new Object[]{LaunchInductionStatus.NO_LAUNCH.getCode(), letterObj.getLong("offer.id")};
        DynamicObject offerObj = this.offerHelper.loadSingle(letterObj.get("offer.id"));
        try (TXHandle tx = TX.required();){
            try {
                updateCount = HRDBUtil.update((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)updateSql, (Object[])objects);
                HRDBUtil.update((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)updateOfferASql, (Object[])offerAValues);
                log.info("offer status update success");
                if (updateCount > 0) {
                    DataEntityCacheManager dataEntityCacheManager = new DataEntityCacheManager(letterObj.getDataEntityType());
                    dataEntityCacheManager.removeByDt();
                    this.sendAcceptOfferMessage(letterObj);
                    this.genOpRecordService.genAcceptOfferOpRecord(offerObj);
                }
            }
            catch (Exception e) {
                log.error("offer accept error :", (Throwable)e);
                tx.markRollback();
                throw new KDBizException(OfferMultilingualConstants.acceptOfferError());
            }
        }
        return updateCount > 0;
    }

    public void sendAcceptOfferMessage(DynamicObject letterObj) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>(16);
        paramMap.put("appFileId", letterObj.getDynamicObject("appfile").getLong("id"));
        paramMap.put("offerId", letterObj.getLong("offer.id"));
        paramMap.put("offerStatus", OfferLetterReplyStatus.ALR_ACCEPT.getCode());
        ArrayList paramMapList = Lists.newArrayList((Object[])new Map[]{paramMap});
        AppFileDataHelper.updateOfferStatus((List)paramMapList);
        IntrecoBusinessHelper.updateBizCountByList((ArrayList)paramMapList);
    }

    private void doCheckLetterStatus(DynamicObject letterObj) {
        long letterStatus = letterObj.getDynamicObject("letterstatus").getLong("id");
        if (letterStatus == OfferLetterStatus.ALR_DISCARD.getCode()) {
            throw new KDBizException(OfferMultilingualConstants.offerDiscard());
        }
        long replayStatus = letterObj.getDynamicObject("replystatus").getLong("id");
        if (replayStatus != OfferLetterReplyStatus.PRE_REPLY.getCode()) {
            throw new KDBizException(OfferMultilingualConstants.offerStatusChange());
        }
    }

    public void initOfferLetter(DynamicObject[] offerObjs) {
        HashSet offerLetterSet = Sets.newHashSetWithExpectedSize((int)offerObjs.length);
        for (DynamicObject offerObj : offerObjs) {
            DynamicObject letterObj = this.letterHelper.generateNewOfferLetter(offerObj);
            if (HRObjectUtils.isEmpty((Object)letterObj)) continue;
            offerLetterSet.add(letterObj);
        }
        DynamicObject[] letterObjs = (DynamicObject[])this.letterHelper.save(offerLetterSet.toArray(new DynamicObject[0]));
        Map<Long, DynamicObject> letterObjMap = Arrays.stream(letterObjs).collect(Collectors.toMap(obj -> obj.getLong("offer"), obj -> obj));
        for (DynamicObject offerObj : offerObjs) {
            offerObj.set("offerletter", (Object)letterObjMap.get(offerObj.getLong("id")));
        }
        this.genOpRecordService.genNewOfferLetterOpRecord(Arrays.asList(offerObjs), 1);
        this.updateAppfileInfo(letterObjs);
    }

    private void updateAppfileInfo(DynamicObject[] offerLetterDys) {
        Set appfileIds = Arrays.stream(offerLetterDys).filter(dy -> dy.getLong("appfile") != 0L).map(dy -> dy.getLong("appfile")).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        QFilter qFilter = new QFilter("id", "in", appfileIds);
        Object[] appfileDys = serviceHelper.query("id,offerletter", new QFilter[]{qFilter});
        if (HRArrayUtils.isEmpty((Object[])appfileDys)) {
            return;
        }
        Map<Long, Long> appfileToOfferLetterMaps = Arrays.stream(offerLetterDys).filter(dy -> dy.getLong("appfile") != 0L).collect(Collectors.toMap(dy -> dy.getLong("appfile"), dy -> dy.getLong("id")));
        Arrays.stream(appfileDys).forEach(appfileDy -> {
            long appfileId = appfileDy.getLong("id");
            appfileDy.set("offerletter_id", appfileToOfferLetterMaps.get(appfileId));
        });
        serviceHelper.update((DynamicObject[])appfileDys);
    }

    public boolean rejectOffer(DynamicObject letterObj) {
        int updateCount;
        Object[] objects;
        Date now = KDDateUtils.now();
        String updateSetSql = "update T_TSO_OFFERLETTER set FREPLYSTATUSID = ?, FREJECTREASON = ?, FDATASTATUSID = ?, FMODIFYTIME = ?, FREPLYTIME = ?";
        String updateWhereSql = " where FID = ? and FDATASTATUSID = ? and FSTATUSID =? ";
        long offerLetterStatus = OfferLetterDataStatus.TAKE_EFFECT.getCode();
        boolean isInvalid = this.offerParamConfigService.getInvalidConfig("refuseoffer");
        if (isInvalid) {
            offerLetterStatus = OfferLetterDataStatus.INVALID.getCode();
            updateSetSql = updateSetSql + ", FVALIDTIME = ?";
            objects = new Object[]{OfferLetterReplyStatus.ALR_REFUSE.getCode(), letterObj.getLong("rejectreason.id"), offerLetterStatus, now, now, now, letterObj.getLong("id"), OfferLetterDataStatus.TAKE_EFFECT.getCode(), OfferLetterStatus.ALR_SEND.getCode()};
        } else {
            objects = new Object[]{OfferLetterReplyStatus.ALR_REFUSE.getCode(), letterObj.getLong("rejectreason.id"), offerLetterStatus, now, now, letterObj.getLong("id"), OfferLetterDataStatus.TAKE_EFFECT.getCode(), OfferLetterStatus.ALR_SEND.getCode()};
        }
        String updateSql = updateSetSql + updateWhereSql;
        long offerId = letterObj.getLong("offer.id");
        DynamicObject offerObj = this.offerHelper.loadSingle(offerId);
        try (TXHandle tx = TX.required();){
            try {
                updateCount = HRDBUtil.update((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)updateSql, (Object[])objects);
                if (updateCount > 0) {
                    this.letterHelper.updateOne(letterObj);
                    DataEntityCacheManager dataEntityCacheManager = new DataEntityCacheManager(letterObj.getDataEntityType());
                    dataEntityCacheManager.removeByDt();
                    OfferChangeModel model = new OfferChangeModel();
                    model.setAppFileId(letterObj.getDynamicObject("appfile").getLong("id"));
                    model.setOfferId(letterObj.getLong("offer.id"));
                    model.setOfferStatus(OfferLetterReplyStatus.ALR_REFUSE.getCode());
                    OfferChangeProducer.sendOfferChangeMessage(model);
                    this.genOpRecordService.genRefuseOfferOpRecord(offerObj, letterObj.getDynamicObject("rejectreason"), letterObj.getString("rejectdesc"), "\u62d2\u7edd");
                }
            }
            catch (Exception e) {
                log.error("offer reject error :", (Throwable)e);
                tx.markRollback();
                throw new KDBizException(OfferMultilingualConstants.rejectError());
            }
        }
        return updateCount > 0;
    }

    public DynamicObject generateValidOfferLetter(Long offerId, Date validTime, Date lastreplytime, String changereason, boolean isAudit) {
        DynamicObject templateDy;
        log.info("\u3010OfferLetterService\u3011\"generateValidOfferLetter\" param \"offerId:\"{} \"isAudit:\"{}", (Object)offerId, (Object)isAudit);
        DynamicObject offerInfo = this.offerHelper.getOfferById(offerId);
        DynamicObject letter = this.letterHelper.generateEmptyDynamicObject();
        letter.set("changevaliddesc", (Object)changereason);
        letter.set("lastreasonsign", (Object)"changevaliddesc");
        letter.set("offer", (Object)offerInfo.getLong("id"));
        long appfileId = offerInfo.getDynamicObject("appfile").getLong("id");
        letter.set("appfile", (Object)appfileId);
        String letterName = offerInfo.getString("candidatename") + OfferMultilingualConstants.getOfferLetterNameSuffix();
        letter.set("name", (Object)letterName);
        String letterNo = CodeRuleServiceHelper.getNumber((String)"tso_offerletter", (DynamicObject)letter, null);
        letter.set("billno", (Object)letterNo);
        long letterStatus = isAudit ? OfferLetterStatus.PRE_GENERATE.getCode() : OfferLetterStatus.PRE_SEND.getCode();
        letter.set("letterstatus", (Object)letterStatus);
        long letterDataStatus = isAudit ? OfferLetterDataStatus.NULL.getCode() : OfferLetterDataStatus.DEFAULT.getCode();
        letter.set("datastatus", (Object)letterDataStatus);
        letter.set("lastreplytime", (Object)lastreplytime);
        letter.set("validtime", (Object)validTime);
        if (!isAudit) {
            Date lastSendTime = DateUtils.afterNowDateTime((int)7);
            letter.set("lastsendtime", (Object)lastSendTime);
        }
        if (!HRObjectUtils.isEmpty((Object)(templateDy = offerInfo.getDynamicObject("template")))) {
            letter.set("template", (Object)templateDy.getLong("id"));
        }
        String letterContent = OfferAttachmentService.getInstance().generateLetterContent(offerInfo, letter);
        letter.set("lettercontent_tag", (Object)letterContent);
        letter.set("isgtannex", (Object)"1");
        letter.set("isepannex", (Object)"1");
        OfferUtils.updateOperateInfo((DynamicObject)letter);
        this.sendOfferChangeMessage(appfileId, offerId, letterStatus);
        return letter;
    }

    public void sendOfferChangeMessage(Long appfileId, Long offerId, Long offerStatusId) {
        if (appfileId == null) {
            log.error("appfileId is null");
            return;
        }
        if (offerId == null) {
            log.error("offerId is null");
            return;
        }
        if (offerStatusId == null) {
            log.error("offerStatusId is null");
            return;
        }
        OfferChangeModel model = new OfferChangeModel();
        model.setAppFileId(appfileId);
        model.setOfferId(offerId);
        model.setOfferStatus(offerStatusId);
        model.setAppfileInProcess("true");
        OfferChangeProducer.sendOfferChangeMessage(model);
    }

    public void sendOfferChangeMessage(long offerLetterId, Long letterStatus) {
        DynamicObject letterObj = this.letterHelper.loadSingle(offerLetterId);
        long appfileId = letterObj.getDynamicObject("appfile").getLong("id");
        long offerId = letterObj.getDynamicObject("offer").getLong("id");
        OfferChangeModel model = new OfferChangeModel();
        model.setAppFileId(appfileId);
        model.setOfferId(offerId);
        model.setOfferStatus(letterStatus);
        OfferChangeProducer.sendOfferChangeMessage(model);
    }

    public long sendTemplateMessage(String contentUrl, List<Long> userIds, String candidateName, String type, Long bizDataId) {
        MessageInfo messageInfo = new MessageInfo();
        String msg = "";
        msg = "1".equals(type) ? ResManager.loadKDString((String)"\u5019\u9009\u4eba{0}\u5df2\u56de\u590d\u63a5\u53d7Offer\uff0c\u8bf7\u60a8\u53ca\u65f6\u5173\u6ce8\u3002", (String)"tsc-tsrbd-business", (String)"OfferLetterService_1", (Object[])new Object[]{candidateName}) : ResManager.loadKDString((String)"\u5019\u9009\u4eba{0}\u5df2\u56de\u590d\u62d2\u7eddOffer\uff0c\u8bf7\u60a8\u53ca\u65f6\u5173\u6ce8\u3002", (String)"tsc-tsrbd-business", (String)"OfferLetterService_2", (Object[])new Object[]{candidateName});
        messageInfo.setTitle(msg);
        messageInfo.setContent(msg);
        messageInfo.setBizDataId(bizDataId);
        messageInfo.setType("message");
        messageInfo.setContentUrl(contentUrl);
        messageInfo.setUserIds(userIds);
        messageInfo.setSenderId(Long.valueOf(0L));
        messageInfo.setSendTime(new Date());
        long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        return msgId;
    }

    public void noticeSendUser(Long letterId, String type) {
        DynamicObject letter = this.getOfferLetter(letterId);
        DynamicObject offer = letter.getDynamicObject("offer");
        DynamicObject sendUser = letter.getDynamicObject("senduser");
        if (HRObjectUtils.isEmpty((Object)offer) || HRObjectUtils.isEmpty((Object)sendUser)) {
            return;
        }
        long offerId = offer.getLong("id");
        long sendUserId = sendUser.getLong("id");
        String candidateName = offer.getString("candidatename");
        StringBuilder contentUrl = new StringBuilder();
        contentUrl.append(UrlService.getDomainContextUrl());
        contentUrl.append("/?formId=");
        contentUrl.append("tso_somk_offerbaseinfo");
        contentUrl.append("&offerId=");
        contentUrl.append(offerId);
        this.sendTemplateMessage(contentUrl.toString(), Lists.newArrayList((Object[])new Long[]{sendUserId}), candidateName, type, offerId);
    }

    public DynamicObject getOfferLetter(Long letterId) {
        return this.letterHelper.queryOne("senduser,offer", letterId);
    }

    public static enum Singleton {
        INSTANCE;

        private final OfferLetterService instance = new OfferLetterService();

        public OfferLetterService getInstance() {
            return this.instance;
        }
    }
}

