/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.login;

import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.common.constants.offer.login.OfferLoginBaseConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.dto.login.OfferCodeLoginDto;
import org.apache.commons.lang3.StringUtils;

public class OfferCodeLoginService {
    private final DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private final OfferLetterServiceHelper offerLetterServiceHelper = OfferLetterServiceHelper.getInstance();

    public void checkLimitCondition(String cachedKeySuffix) {
        String totalNumber = (String)this.redisCache.get("OFFER_SMS_DAY:" + cachedKeySuffix);
        if (StringUtils.isNotEmpty((CharSequence)totalNumber) && Long.parseLong(totalNumber) >= (long)OfferLoginBaseConstants.MAX_SEND_NUMBER_DAY.intValue()) {
            throw new KDBizException(OfferMultilingualConstants.codeLoginToMaxLimitForDay());
        }
        String loginErrorNum = (String)this.redisCache.get("OFFER_LOGIN_ERROR_HOUR:" + cachedKeySuffix);
        if (StringUtils.isNotEmpty((CharSequence)loginErrorNum) && Long.parseLong(loginErrorNum) >= (long)OfferLoginBaseConstants.MAX_LOGIN_ERROR_HOUR.intValue()) {
            throw new KDBizException(OfferMultilingualConstants.loginToMaxLimitForHour());
        }
    }

    public void checkCode(OfferCodeLoginDto offerCodeLoginDto) {
        DynamicObject offerLetter = this.offerLetterServiceHelper.loadSingle(offerCodeLoginDto.getOfferLetterId());
        if (!offerLetter.getString("verifycode").trim().equals(offerCodeLoginDto.getVerifyCode().trim())) {
            this.statisticLoginNum(offerCodeLoginDto.getCachedKeySuffix());
            throw new KDBizException(OfferMultilingualConstants.loginCodeError());
        }
        this.redisCache.remove("OFFER_LOGIN_ERROR_HOUR:" + offerCodeLoginDto.getCachedKeySuffix());
    }

    private void statisticLoginNum(String cachedKeySuffix) {
        String loginErrorNum = (String)this.redisCache.get("OFFER_LOGIN_ERROR_HOUR:" + cachedKeySuffix);
        if (StringUtils.isEmpty((CharSequence)loginErrorNum)) {
            this.redisCache.inc("OFFER_LOGIN_ERROR_HOUR:" + cachedKeySuffix, 1, TimeUnit.HOURS);
        } else {
            this.setLoginLockTimeHour(cachedKeySuffix, loginErrorNum);
        }
        String totalNumber = (String)this.redisCache.get("OFFER_SMS_DAY:" + cachedKeySuffix);
        if (StringUtils.isEmpty((CharSequence)totalNumber)) {
            this.redisCache.inc("OFFER_SMS_DAY:" + cachedKeySuffix, 1, TimeUnit.DAYS);
        } else {
            this.setLoginLockTimeDay(cachedKeySuffix, totalNumber);
        }
    }

    private void setLoginLockTimeDay(String cachedKeySuffix, String totalNumber) {
        if (Integer.parseInt(totalNumber) >= OfferLoginBaseConstants.MAX_SEND_NUMBER_DAY - 1) {
            this.redisCache.inc("OFFER_SMS_DAY:" + cachedKeySuffix, 1, TimeUnit.DAYS);
        } else {
            this.redisCache.inc("OFFER_SMS_DAY:" + cachedKeySuffix);
        }
    }

    private void setLoginLockTimeHour(String cachedKey, String loginErrorNum) {
        if (Integer.parseInt(loginErrorNum) >= OfferLoginBaseConstants.MAX_LOGIN_ERROR_HOUR - 1) {
            this.redisCache.inc("OFFER_LOGIN_ERROR_HOUR:" + cachedKey, 1, TimeUnit.HOURS);
        } else {
            this.redisCache.inc("OFFER_LOGIN_ERROR_HOUR:" + cachedKey);
        }
    }

    public static enum Singleton {
        INSTANCE;

        private OfferCodeLoginService instance = new OfferCodeLoginService();

        public OfferCodeLoginService getInstance() {
            return this.instance;
        }
    }
}

