/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.login;

import com.google.common.base.Joiner;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.common.enums.offer.login.OfferLoginMainParamEnum;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.exception.OfferInvalidException;
import kd.tsc.tso.common.util.Sha256Utils;

public class OfferLoginMainService {
    private static final Log log = LogFactory.getLog(OfferLoginMainService.class);
    private OfferLetterServiceHelper letterServiceHelper = OfferLetterServiceHelper.getInstance();

    private void checkParam(Map<String, Object> paramMap) {
        try {
            for (OfferLoginMainParamEnum param : OfferLoginMainParamEnum.values()) {
                if (paramMap.get(param.key) != null) continue;
                log.error("{} is null", (Object)param.key);
                return;
            }
        }
        catch (IllegalStateException e) {
            log.error("\u3010OfferLoginMainService\u3011param has exit null :", (Throwable)e);
            throw new OfferInvalidException((Throwable)e);
        }
        catch (Exception e) {
            log.error("\u3010OfferLoginMainService\u3011check param error :", (Throwable)e);
            throw new OfferInvalidException((Throwable)e);
        }
    }

    private void checkValid(Map<String, Object> paramMap) {
        long status;
        String letterNumber = paramMap.get(OfferLoginMainParamEnum.LETTER_NUMBER.key).toString();
        QFilter qFilter = new QFilter("billno", "=", (Object)letterNumber);
        DynamicObject letterObj = this.letterServiceHelper.queryOne("offer,validtime,letterstatus", qFilter);
        if (letterObj == null) {
            throw new OfferInvalidException("offer letter empty");
        }
        long letterStatus = letterObj.getDynamicObject("letterstatus").getLong("id");
        if (letterStatus == OfferLetterStatus.ALR_DISCARD.getCode()) {
            throw new OfferInvalidException("offer letter status alr_discard");
        }
        DynamicObject offerObj = letterObj.getDynamicObject("offer");
        if (offerObj != null && (status = offerObj.getDynamicObject("status").getLong("id")) == OfferStatus.ALR_DISCARD.getCode()) {
            throw new OfferInvalidException("offer status alr_discard");
        }
        Date validtime = letterObj.getDate("validtime");
        long validDay = OfferLetterServiceHelper.getInstance().checkValidDay(validtime);
        log.info("\u3010OfferLoginMainService\u3011checkValid validDay {} :", (Object)validDay);
        if (validDay < 0L) {
            throw new OfferInvalidException("offer letter empty");
        }
        paramMap.put("letterid", letterObj.getLong("id"));
        paramMap.put("offerid", letterObj.getLong("offer.id"));
    }

    private void checkSign(Map<String, Object> paramMap) {
        String letterNumber = paramMap.get(OfferLoginMainParamEnum.LETTER_NUMBER.key).toString();
        QFilter qFilter = new QFilter("billno", "=", (Object)letterNumber);
        DynamicObject letterObj = this.letterServiceHelper.queryOne("offer", qFilter);
        DynamicObject offerObj = letterObj.getDynamicObject("offer");
        Object[] paramList = new Object[]{letterNumber, offerObj.getString("candidatephone"), paramMap.get(OfferLoginMainParamEnum.TYPE.key)};
        boolean signSuccess = OfferLoginMainService.checkSign(paramMap.get(OfferLoginMainParamEnum.KEY.key).toString(), paramList);
        log.info("OfferLoginMainService.checkSign:{}", (Object)signSuccess);
        if (!signSuccess) {
            throw new OfferInvalidException();
        }
        paramMap.put("candidatephone", offerObj.getString("candidatephone"));
    }

    private static boolean checkSign(String sign, Object[] paramList) {
        if (HRStringUtils.isEmpty((String)sign)) {
            return false;
        }
        if (HRArrayUtils.isEmpty((Object[])paramList)) {
            return false;
        }
        String key = Joiner.on((String)"_").join(paramList);
        String nSign = Sha256Utils.getSha256((String)key);
        return sign.equals(nSign);
    }

    public void checkDataValid(Map<String, Object> paramMap) {
        this.checkParam(paramMap);
        this.checkValid(paramMap);
        this.checkSign(paramMap);
    }

    public static enum Singleton {
        INSTANCE;

        private final OfferLoginMainService instance = new OfferLoginMainService();

        public OfferLoginMainService getInstance() {
            return this.instance;
        }
    }
}

