/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.login;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.service.letter.OfferLetterService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.offer.login.OfferRejectParamEnum;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;

public class OfferRejectService {
    private OfferLetterService letterService = OfferLetterService.Singleton.INSTANCE.getInstance();
    private final OfferLetterServiceHelper letterHelper = OfferLetterServiceHelper.getInstance();

    public DynamicObject doRejectOffer(IFormView parentView) {
        Object letterId = parentView.getFormShowParameter().getCustomParams().get(OfferRejectParamEnum.OFFER_Letter_ID.code);
        DynamicObject parentEntity = parentView.getModel().getDataEntity(true);
        DynamicObject letterObj = this.letterHelper.loadSingle(letterId);
        DynamicObject rejectObject = parentEntity.getDynamicObject("rejectreason");
        letterObj.set("rejectreason", (Object)rejectObject);
        String reasonDesc = parentEntity.getString("other_reason");
        if (reasonDesc == null) {
            reasonDesc = rejectObject.getString("name");
        }
        letterObj.set("rejectdesc", (Object)reasonDesc);
        letterObj.set("lastreasonsign", (Object)"rejectdesc");
        letterObj.set("replystatus", (Object)OfferLetterReplyStatus.ALR_REFUSE.getCode());
        boolean updateSuccess = this.letterService.rejectOffer(letterObj);
        if (!updateSuccess) {
            throw new KDBizException(OfferMultilingualConstants.rejectError());
        }
        OfferLetterService.Singleton.INSTANCE.getInstance().noticeSendUser(Long.valueOf(letterId.toString()), "2");
        return letterObj;
    }

    public static enum Singleton {
        INSTANCE;

        private final OfferRejectService instance = new OfferRejectService();

        public OfferRejectService getInstance() {
            return this.instance;
        }
    }
}

