/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.login;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.tsc.tso.common.constants.offer.login.OfferLoginBaseConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.dto.login.OfferSmsLoginDto;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.sms.entity.SmsModel;
import kd.tsc.tsrbs.business.domain.sms.service.SmsServiceImpl;
import kd.tsc.tsrbs.common.utils.verifycode.service.VerifyCodeService;

public class OfferSmsLoginService {
    private static final Log log = LogFactory.getLog(OfferSmsLoginService.class);
    private static final int SMS_CACHE_TIMEOUT = 300;
    private static final DistributeSessionlessCache REDIS_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    private void checkSmsCode(OfferSmsLoginDto smsLoginDto) {
        String smsCodeKey = "OFFER_SMS_CODE:" + smsLoginDto.getPhone();
        String cacheSmsCode = CacheLoginData.getAttribute((String)"login", (String)smsCodeKey);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cacheSmsCode)) {
            throw new IllegalStateException(OfferMultilingualConstants.smsCodeInValid());
        }
        if (!cacheSmsCode.equalsIgnoreCase(smsLoginDto.getSmsCode())) {
            this.statisticsLoginNum(smsLoginDto.getCachedKeySuffix());
            throw new KDBizException(OfferMultilingualConstants.smsCodeError());
        }
        REDIS_CACHE.remove("OFFER_LOGIN_ERROR_HOUR:" + smsLoginDto.getCachedKeySuffix());
        CacheLoginData.remove((String)"login", (String)smsCodeKey);
    }

    private void checkLimitCondition(String smsCode, String cachedKey) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)smsCode)) {
            throw new IllegalStateException(OfferMultilingualConstants.smsCodeNotNull());
        }
        String totalNumber = (String)REDIS_CACHE.get("OFFER_SMS_DAY:" + cachedKey);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)totalNumber) && Long.parseLong(totalNumber) >= (long)OfferLoginBaseConstants.MAX_SEND_NUMBER_DAY.intValue()) {
            throw new KDBizException(OfferMultilingualConstants.loginToMaxLimitForDay());
        }
        String loginErrorNum = (String)REDIS_CACHE.get("OFFER_LOGIN_ERROR_HOUR:" + cachedKey);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)loginErrorNum) && Long.parseLong(loginErrorNum) >= (long)OfferLoginBaseConstants.MAX_LOGIN_ERROR_HOUR.intValue()) {
            throw new KDBizException(OfferMultilingualConstants.loginToMaxLimitForHour());
        }
    }

    private void statisticsLoginNum(String cachedKeySuffix) {
        String loginErrorNum = (String)REDIS_CACHE.get("OFFER_LOGIN_ERROR_HOUR:" + cachedKeySuffix);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)loginErrorNum)) {
            REDIS_CACHE.inc("OFFER_LOGIN_ERROR_HOUR:" + cachedKeySuffix, 1, TimeUnit.HOURS);
        } else {
            this.setLoginLockTimeHour(cachedKeySuffix, loginErrorNum);
        }
        String totalNumber = (String)REDIS_CACHE.get("OFFER_SMS_DAY:" + cachedKeySuffix);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)totalNumber)) {
            REDIS_CACHE.inc("OFFER_SMS_DAY:" + cachedKeySuffix, 1, TimeUnit.DAYS);
        } else {
            this.setLoginLockTimeDay(cachedKeySuffix, totalNumber);
        }
    }

    private void setLoginLockTimeDay(String cachedKeySuffix, String loginErrorNum) {
        if (Integer.parseInt(loginErrorNum) >= OfferLoginBaseConstants.MAX_SEND_NUMBER_DAY - 1) {
            REDIS_CACHE.inc("OFFER_SMS_DAY:" + cachedKeySuffix, 1, TimeUnit.DAYS);
        } else {
            REDIS_CACHE.inc("OFFER_SMS_DAY:" + cachedKeySuffix);
        }
    }

    private void setLoginLockTimeHour(String cachedKeySuffix, String loginErrorNum) {
        if (Integer.parseInt(loginErrorNum) >= OfferLoginBaseConstants.MAX_LOGIN_ERROR_HOUR - 1) {
            REDIS_CACHE.inc("OFFER_LOGIN_ERROR_HOUR:" + cachedKeySuffix, 1, TimeUnit.HOURS);
        } else {
            REDIS_CACHE.inc("OFFER_LOGIN_ERROR_HOUR:" + cachedKeySuffix);
        }
    }

    private void checkVerifyCode(OfferSmsLoginDto smsLoginDto, DynamicObject dataEntity) {
        String verifyCode = dataEntity.getString("verify_code");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)verifyCode)) {
            throw new IllegalStateException(OfferMultilingualConstants.verifyCodeNotNull());
        }
        boolean isValid = VerifyCodeService.Singleton.INSTANCE.getInstance().checkVerifyCode(null, verifyCode, smsLoginDto.getAuthCodeCache());
        if (!isValid) {
            throw new KDBizException(OfferMultilingualConstants.verifyCodeNoValid());
        }
    }

    private void checkPhone(DynamicObject dynamicObject, String offerPhone) {
        String phone = dynamicObject.getString("phone");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)phone)) {
            throw new IllegalStateException(OfferMultilingualConstants.phoneNoEmpty());
        }
        if (!StringUtils.isPhoneNumberValid((String)phone)) {
            throw new IllegalStateException(OfferMultilingualConstants.phoneNoValid());
        }
        if (!offerPhone.equals(phone)) {
            throw new IllegalStateException(OfferMultilingualConstants.phoneDisaccord());
        }
    }

    private String generateVerifyCode() {
        ArrayList numbers = Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        Collections.shuffle(numbers);
        return org.apache.commons.lang3.StringUtils.join(numbers.subList(0, 6), (String)"");
    }

    private void sendSmsCode(String offerPhone) throws Exception {
        String lockTime = (String)REDIS_CACHE.get("OFFER_SMS_LOCK_TIME:" + offerPhone);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)lockTime)) {
            throw new KDBizException(OfferMultilingualConstants.smsToMaxLimit());
        }
        String verifyCode = this.generateVerifyCode();
        String content = MessageFormat.format(OfferMultilingualConstants.sendSmsVerifyCode(), verifyCode);
        SmsModel smsModel = new SmsModel();
        smsModel.setPhone(offerPhone);
        smsModel.setContent(content);
        smsModel.setOptUserId(Long.valueOf(TSCRequestContext.getUserId()));
        smsModel.setBusKey("offer_login");
        String smsCodeKey = "OFFER_SMS_CODE:" + offerPhone;
        try {
            SmsServiceImpl.Singleton.INSTANCE.getInstance().limitSendSms(smsModel);
        }
        catch (KDBizException e) {
            REDIS_CACHE.put("OFFER_SMS_LOCK_TIME:" + offerPhone, (Object)"one day", 1, TimeUnit.DAYS);
            throw new KDBizException(OfferMultilingualConstants.smsToMaxLimit());
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        CacheLoginData.setAttribute((String)"login", (String)smsCodeKey, (String)verifyCode, (int)300);
    }

    public void checkLoginCondition(DynamicObject dynamicObject, OfferSmsLoginDto smsLoginDto) {
        this.checkPhone(dynamicObject, smsLoginDto.getPhone());
        this.checkVerifyCode(smsLoginDto, dynamicObject);
        this.checkLimitCondition(smsLoginDto.getSmsCode(), smsLoginDto.getCachedKeySuffix());
        this.checkSmsCode(smsLoginDto);
    }

    public void checkSendSmsCondition(DynamicObject dynamicObject, OfferSmsLoginDto smsLoginDto) throws Exception {
        this.checkPhone(dynamicObject, smsLoginDto.getPhone());
        this.checkVerifyCode(smsLoginDto, dynamicObject);
        this.sendSmsCode(smsLoginDto.getPhone());
    }

    public static enum Singleton {
        INSTANCE;

        private OfferSmsLoginService instance = new OfferSmsLoginService();

        public OfferSmsLoginService getInstance() {
            return this.instance;
        }
    }
}

