/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.offerLetter;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.offer.service.modal.AbstractOfferLetterTemplateBizService;
import kd.tsc.tsrbd.common.utils.TerracePhoneFormChangeUtil;

public class DefaultOfferLetterTemplateBizService
extends AbstractOfferLetterTemplateBizService {
    public void getOfferLetterTemplateParams(Map<String, String> param, DynamicObject ... dys) {
        Arrays.stream(dys).filter(dynamicObject -> dynamicObject.getDynamicObjectType().getName().equals("tso_somk_offerbase") || dynamicObject.getDynamicObjectType().getName().equals("tso_offerbase_info") || dynamicObject.getDynamicObjectType().getName().equals("tso_somk_offerbaseinfo") || dynamicObject.getDynamicObjectType().getName().equals("tso_somk_waitofferbase")).findFirst().ifPresent(dynamicObject -> {
            DynamicObject placeWork = dynamicObject.getDynamicObject("placework");
            String placeWorkStr = Optional.ofNullable(placeWork).map(this::getWorkPlace).orElse("");
            param.put("placework", placeWorkStr);
            param.put("peposition", this.getPePosition((DynamicObject)dynamicObject));
            DynamicObject applicant = dynamicObject.getDynamicObject("applicant");
            if (HRObjectUtils.isEmpty((Object)applicant)) {
                param.put("offercontact", null);
                param.put("offercontactphone", null);
            } else {
                param.put("offercontact", applicant.getString("name"));
                param.put("offercontactphone", TerracePhoneFormChangeUtil.getFormChangePhone((String)applicant.getString("phone")));
            }
            Map<String, String> currencyMapping = this.getCurrencyMapping((DynamicObject)dynamicObject);
            for (Map.Entry<String, String> entry : currencyMapping.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String oldValue = (String)param.get(key);
                if (!HRStringUtils.isNotEmpty((String)oldValue)) continue;
                param.put(key, value + oldValue);
            }
        });
    }

    public void getOtherFieldVariables(Map<String, String> param, Object obj) {
    }

    private String getWorkPlace(DynamicObject dy) {
        return dy.getString("name");
    }

    private Map<String, String> getCurrencyMapping(DynamicObject offer) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject regpaycu = offer.getDynamicObject("regpaycu");
        Optional.ofNullable(regpaycu).ifPresent(reg -> {
            String sign = reg.getString("sign");
            resultMap.put("regbwages", sign);
            resultMap.put("regpossub", sign);
            resultMap.put("regprp", sign);
            resultMap.put("regmonthly", sign);
            resultMap.put("regyearbonus", sign);
        });
        DynamicObject prpepaycu = offer.getDynamicObject("prpepaycu");
        Optional.ofNullable(prpepaycu).ifPresent(prp -> {
            String sign = prp.getString("sign");
            resultMap.put("prpebwages", sign);
            resultMap.put("prpepossub", sign);
            resultMap.put("prpeprp", sign);
            resultMap.put("regmonthlyforprpe", sign);
            resultMap.put("prpemonthly", sign);
        });
        DynamicObject welpaycu = offer.getDynamicObject("welpaycu");
        Optional.ofNullable(welpaycu).ifPresent(welpay -> {
            String sign = welpay.getString("sign");
            resultMap.put("trafaow", sign);
            resultMap.put("tietaryaow", sign);
            resultMap.put("municataow", sign);
            resultMap.put("rentalaow", sign);
            resultMap.put("housaow", sign);
        });
        logger.info("OfferAttachmentService.getCurrencyMapping:[{}]", (Object)resultMap);
        return resultMap;
    }

    private String getPePosition(DynamicObject dynamicObject) {
        DynamicObject pePosition = dynamicObject.getDynamicObject("peposition");
        DynamicObject peJob = dynamicObject.getDynamicObject("pejob");
        DynamicObject peStdPosition = dynamicObject.getDynamicObject("pestdposition");
        String name = "";
        if (Objects.nonNull(pePosition)) {
            name = pePosition.getString("name");
        } else if (Objects.nonNull(peStdPosition)) {
            name = peStdPosition.getString("name");
        } else if (Objects.nonNull(peJob)) {
            name = peJob.getString("name");
        }
        return name;
    }
}

