/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.oprecord;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tsc.tso.business.domain.offer.bo.oprecord.AbandonOfferOpRecordBO;
import kd.tsc.tso.business.domain.offer.bo.oprecord.AgreeApprovalOfferOpRecordBO;
import kd.tsc.tso.business.domain.offer.bo.oprecord.ChgOfferValidTimeOpRecordBO;
import kd.tsc.tso.business.domain.offer.bo.oprecord.DelaySendOfferOpRecordBO;
import kd.tsc.tso.business.domain.offer.bo.oprecord.EditOfferBillOpRecordBO;
import kd.tsc.tso.business.domain.offer.bo.oprecord.OfferOpRecordBO;
import kd.tsc.tso.business.domain.offer.bo.oprecord.RefuseOfferOpRecordBO;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferSendOpRecordService;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class OfferGenOpRecordService {
    public void genNewOfferBaseOpRecord(List<DynamicObject> offerInfoList) {
        OfferOpRecordBO offerOpRecordBO = new OfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(offerInfoList);
        offerOpRecordBO.setOpDefEnum(OpDefEnum.ADD_OFFER);
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genEditOfferOpRecord(DynamicObject offerInfo) {
        OfferOpRecordBO offerOpRecordBO = new OfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(Collections.singletonList(offerInfo));
        offerOpRecordBO.setOpDefEnum(OpDefEnum.EDIT_OFFER);
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genSubmitOfferOpRecord(DynamicObject offerInfo, String operateName) {
        OfferOpRecordBO offerOpRecordBO = new OfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(Collections.singletonList(offerInfo));
        offerOpRecordBO.setOpDefEnum(OpDefEnum.SUBMIT_OFFER);
        offerOpRecordBO.setOperateName(operateName);
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genDeleteOfferOpRecord(List<DynamicObject> offerInfoList, String operateName) {
        OfferOpRecordBO bo = new OfferOpRecordBO();
        bo.setOperateName(operateName);
        bo.setOpDefEnum(OpDefEnum.DELETE_OFFER);
        bo.setDynamicObjectList(offerInfoList);
        OfferSendOpRecordService.getInstance().sendOpRecord(bo);
    }

    public void genAbandonOfferOpRecord(List<DynamicObject> offerInfoList, DynamicObject reason, String abandonDesc, String operateName) {
        AbandonOfferOpRecordBO bo = new AbandonOfferOpRecordBO();
        bo.setOpDefEnum(OpDefEnum.ABANDON_OFFER);
        bo.setDynamicObjectList(offerInfoList);
        bo.setOperateName(operateName);
        StringBuilder abandonReasonSb = new StringBuilder(3);
        if (OfferUtils.abandonReasonIsOth((DynamicObject)reason)) {
            abandonReasonSb.append(reason.getString("name"));
            abandonReasonSb.append('-');
        }
        abandonReasonSb.append(abandonDesc);
        bo.setAbandonReason(abandonReasonSb.toString());
        OfferSendOpRecordService.getInstance().sendOpRecord(bo);
    }

    public void genNewOfferBillOpRecord(DynamicObject offerBill) {
        OfferOpRecordBO offerOpRecordBO = new OfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(Collections.singletonList(offerBill));
        offerOpRecordBO.setOpDefEnum(OpDefEnum.FOUND_OFFER_APPFORM);
        offerOpRecordBO.setSkipFormId("tso_offerbillinfo");
        offerOpRecordBO.setSkipPkId(offerBill.getString("id"));
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genEditBillOpRecord(DynamicObject offerBill, List<String> keyWordList) {
        EditOfferBillOpRecordBO offerOpRecordBO = new EditOfferBillOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(Collections.singletonList(offerBill));
        offerOpRecordBO.setOpDefEnum(OpDefEnum.EDIT_OFFER_APPFROM);
        if (keyWordList != null && !keyWordList.isEmpty()) {
            offerOpRecordBO.setEditKeyWords(true);
            offerOpRecordBO.setKeyWords(Joiner.on((char)'\u3001').skipNulls().join(keyWordList));
        }
        offerOpRecordBO.setSkipFormId("tso_offerbillinfo");
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genSubmitOfferBillOpRecord(DynamicObject offerBill, String operateName) {
        OfferOpRecordBO offerOpRecordBO = new OfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(Collections.singletonList(offerBill));
        offerOpRecordBO.setOpDefEnum(OpDefEnum.SUB_OFFER_APPFORM);
        offerOpRecordBO.setOperateName(operateName);
        offerOpRecordBO.setSkipFormId("tso_offerbillinfo");
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genUnSubmitBillOpRecord(DynamicObject offerBill, String operateName) {
        OfferOpRecordBO bo = new OfferOpRecordBO();
        bo.setDynamicObjectList(Collections.singletonList(offerBill));
        bo.setOpDefEnum(OpDefEnum.REVOKE_OFFER_APPFORM);
        bo.setOperateName(operateName);
        bo.setSkipFormId("tso_offerbillinfo");
        OfferSendOpRecordService.getInstance().sendOpRecord(bo);
    }

    public void genAbandonOfferBillOpRecord(List<DynamicObject> offerBillList, DynamicObject reason, String abandonDesc, String operateName) {
        AbandonOfferOpRecordBO offerOpRecordBO = new AbandonOfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(offerBillList);
        offerOpRecordBO.setOpDefEnum(OpDefEnum.ABANDON_OFFER_APPFORM);
        offerOpRecordBO.setOperateName(operateName);
        StringBuilder abandonReasonSb = new StringBuilder(3);
        if (OfferUtils.abandonReasonIsOth((DynamicObject)reason)) {
            abandonReasonSb.append(reason.getString("name"));
            abandonReasonSb.append('-');
        }
        abandonReasonSb.append(abandonDesc);
        offerOpRecordBO.setAbandonReason(abandonReasonSb.toString());
        offerOpRecordBO.setSkipFormId("tso_offerbillinfo");
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genAgreeApproveOpRecord(DynamicObject offerBill, boolean isEndNode) {
        AgreeApprovalOfferOpRecordBO bo = new AgreeApprovalOfferOpRecordBO();
        bo.setDynamicObjectList(Collections.singletonList(offerBill));
        bo.setOpDefEnum(OpDefEnum.AGREE_OFFER_APPFORM);
        bo.setEndNode(isEndNode);
        OfferSendOpRecordService.getInstance().sendOpRecord(bo);
    }

    public void genDisagreeApproveOpRecord(DynamicObject offerBill) {
        OfferOpRecordBO offerOpRecordBO = new OfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(Collections.singletonList(offerBill));
        offerOpRecordBO.setOpDefEnum(OpDefEnum.DISAGREE_OFFER_APPROVE);
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genNewOfferLetterOpRecord(List<DynamicObject> dynamicObjectList, int status) {
        OfferOpRecordBO offerOpRecordBO = new OfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(dynamicObjectList);
        offerOpRecordBO.setOpDefEnum(OpDefEnum.FOUND_OFFER_LETTER);
        offerOpRecordBO.setStatus(status);
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genSendOfferLetterOpRecord(List<DynamicObject> offerInfoList, String operateName) {
        OfferOpRecordBO bo = new OfferOpRecordBO();
        bo.setDynamicObjectList(offerInfoList);
        bo.setOpDefEnum(OpDefEnum.SEND_OFFER_LETTER);
        bo.setOperateName(operateName);
        OfferSendOpRecordService.getInstance().sendOpRecord(bo);
    }

    public void genDelaySendOpRecord(List<DynamicObject> dynamicObjectList, String operateName, Date lastSendTime, String delayReason) {
        DelaySendOfferOpRecordBO offerOpRecordBO = new DelaySendOfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(dynamicObjectList);
        offerOpRecordBO.setOpDefEnum(OpDefEnum.DELAY_SEND_OFFER_LETTER);
        offerOpRecordBO.setOperateName(operateName);
        offerOpRecordBO.setDelaySendReason(delayReason);
        offerOpRecordBO.setLastSendTime(lastSendTime);
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genAbandonOfferLetterOpRecord(List<DynamicObject> offerInfoList, DynamicObject reason, String abandonDesc, String operateName) {
        AbandonOfferOpRecordBO bo = new AbandonOfferOpRecordBO();
        bo.setOpDefEnum(OpDefEnum.ABANDON_OFFER_LETTER);
        bo.setDynamicObjectList(offerInfoList);
        bo.setOperateName(operateName);
        StringBuilder abandonReasonSb = new StringBuilder(3);
        if (reason != null && OfferUtils.abandonReasonIsOth((DynamicObject)reason)) {
            abandonReasonSb.append(reason.getString("name"));
            abandonReasonSb.append('-');
        }
        abandonReasonSb.append(abandonDesc);
        bo.setAbandonReason(abandonReasonSb.toString());
        OfferSendOpRecordService.getInstance().sendOpRecord(bo);
    }

    public void genAcceptOfferOpRecord(DynamicObject offerInfo) {
        OfferOpRecordBO bo = new OfferOpRecordBO();
        bo.setDynamicObjectList(Collections.singletonList(offerInfo));
        bo.setOpDefEnum(OpDefEnum.ACCEPT_OFFER);
        bo.setOperateName("\u63a5\u53d7");
        OfferSendOpRecordService.getInstance().sendOpRecord(bo);
    }

    public void genRefuseOfferOpRecord(DynamicObject offerInfo, DynamicObject reason, String refuseDesc, String operateName) {
        RefuseOfferOpRecordBO bo = new RefuseOfferOpRecordBO();
        bo.setDynamicObjectList(Collections.singletonList(offerInfo));
        bo.setOpDefEnum(OpDefEnum.REFUSE_OFFER);
        bo.setOperateName(operateName);
        StringBuilder refuseReasonSb = new StringBuilder(3);
        if (OfferUtils.refuseReasonIsOth((DynamicObject)reason)) {
            refuseReasonSb.append(reason.getString("name"));
            refuseReasonSb.append('-');
        }
        refuseReasonSb.append(refuseDesc);
        bo.setRefuseReason(refuseReasonSb.toString());
        OfferSendOpRecordService.getInstance().sendOpRecord(bo);
    }

    public void genNewOfferLetterBillOpRecord(DynamicObject offer) {
        OfferOpRecordBO offerOpRecordBO = new OfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(Collections.singletonList(offer));
        offerOpRecordBO.setOpDefEnum(OpDefEnum.FOUND_OFFER_LETTER_CHANGE_FROM);
        offerOpRecordBO.setSkipFormId("tso_changeletterbill");
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genEditOfferLetterBillOpRecord(DynamicObject offerLetterBillList) {
        EditOfferBillOpRecordBO offerOpRecordBO = new EditOfferBillOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(Collections.singletonList(offerLetterBillList));
        offerOpRecordBO.setOpDefEnum(OpDefEnum.EDIT_OFFER_LETTER_CHANGE_FROM);
        offerOpRecordBO.setSkipFormId("tso_changeletterbill");
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genSubmitOfferLetterBillOpRecord(DynamicObject offerLetterBill, String operateName) {
        OfferOpRecordBO offerOpRecordBO = new OfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(Collections.singletonList(offerLetterBill));
        offerOpRecordBO.setOpDefEnum(OpDefEnum.COMMIT_OFFER_LETTER_CHANGE_FROM);
        offerOpRecordBO.setOperateName(operateName);
        offerOpRecordBO.setSkipFormId("tso_changeletterbill");
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genUnSubmitOfferLetterBillOpRecord(DynamicObject offerLetterBill, String operateName) {
        OfferOpRecordBO bo = new OfferOpRecordBO();
        bo.setDynamicObjectList(Collections.singletonList(offerLetterBill));
        bo.setOpDefEnum(OpDefEnum.REVOKE_OFFER_LETTER_CHANGE_FROM);
        bo.setOperateName(operateName);
        bo.setSkipFormId("tso_changeletterbill");
        OfferSendOpRecordService.getInstance().sendOpRecord(bo);
    }

    public void genAbandonOfferLetterBillOpRecord(List<DynamicObject> offerLetterBillList, DynamicObject reason, String abandonDesc, String operateName) {
        AbandonOfferOpRecordBO offerOpRecordBO = new AbandonOfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(offerLetterBillList);
        offerOpRecordBO.setOpDefEnum(OpDefEnum.ABANDON_OFFER_LETTER_CHANGE_FROM);
        offerOpRecordBO.setOperateName(operateName);
        StringBuilder abandonReasonSb = new StringBuilder(3);
        if (OfferUtils.abandonReasonIsOth((DynamicObject)reason)) {
            abandonReasonSb.append(reason.getString("name"));
            abandonReasonSb.append('-');
        }
        abandonReasonSb.append(abandonDesc);
        offerOpRecordBO.setAbandonReason(abandonReasonSb.toString());
        offerOpRecordBO.setSkipFormId("tso_changeletterbill");
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void genAgreeApproveOfferLetterBillOpRecord(DynamicObject offerLetterBill, boolean isEndNode) {
        AgreeApprovalOfferOpRecordBO bo = new AgreeApprovalOfferOpRecordBO();
        bo.setDynamicObjectList(Collections.singletonList(offerLetterBill));
        bo.setOpDefEnum(OpDefEnum.AGREE_OFFER_LETTER_CHANGE_FROM);
        bo.setEndNode(isEndNode);
        OfferSendOpRecordService.getInstance().sendOpRecord(bo);
    }

    public void genDisagreeApproveOfferLetterBillOpRecord(DynamicObject offerLetterBill) {
        OfferOpRecordBO offerOpRecordBO = new OfferOpRecordBO();
        offerOpRecordBO.setDynamicObjectList(Collections.singletonList(offerLetterBill));
        offerOpRecordBO.setOpDefEnum(OpDefEnum.DISANDEND_OFFER_LETTER_CHANGE_FROM);
        OfferSendOpRecordService.getInstance().sendOpRecord(offerOpRecordBO);
    }

    public void changValidTimeAndLastReplyDate(List<DynamicObject> offerLetterList, Date validTime, String changeReason, Date newLastReplyTime) {
        ChgOfferValidTimeOpRecordBO bo = new ChgOfferValidTimeOpRecordBO();
        bo.setDynamicObjectList(offerLetterList);
        bo.setOpDefEnum(OpDefEnum.CHANGE_OFFER_LETTER_VALID);
        bo.setValidTime(validTime);
        bo.setChangeReason(changeReason);
        bo.setNewLastReplyTime(newLastReplyTime);
        OfferSendOpRecordService.getInstance().sendOpRecord(bo);
    }

    public static OfferGenOpRecordService getInstance() {
        return Instance.INSTANCE;
    }

    private OfferGenOpRecordService() {
    }

    private static class Instance {
        private static final OfferGenOpRecordService INSTANCE = new OfferGenOpRecordService();

        private Instance() {
        }
    }
}

