/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.service.oprecord;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.offer.bo.oprecord.AbandonOfferOpRecordBO;
import kd.tsc.tso.business.domain.offer.bo.oprecord.AgreeApprovalOfferOpRecordBO;
import kd.tsc.tso.business.domain.offer.bo.oprecord.ChgOfferValidTimeOpRecordBO;
import kd.tsc.tso.business.domain.offer.bo.oprecord.DelaySendOfferOpRecordBO;
import kd.tsc.tso.business.domain.offer.bo.oprecord.EditOfferBillOpRecordBO;
import kd.tsc.tso.business.domain.offer.bo.oprecord.OfferOpRecordBO;
import kd.tsc.tso.business.domain.offer.bo.oprecord.RefuseOfferOpRecordBO;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterBillHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferOpRecordTexts;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.business.domain.oprecord.service.OprecordMQ;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class OfferSendOpRecordService {
    private static final Log LOG = LogFactory.getLog(OfferSendOpRecordService.class);
    private static final Map<OpDefEnum, OfferOpRecordFunction<OfferOpRecordBO>> FUNCTION_HASH_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private final OfferOpRecordFunction<OfferOpRecordBO> newOffer = this::newOffer;
    private final OfferOpRecordFunction<OfferOpRecordBO> editOffer = this::editOfferBase;
    private final OfferOpRecordFunction<OfferOpRecordBO> submitOfferBase = this::submitOfferBase;
    private final OfferOpRecordFunction<OfferOpRecordBO> deleteOffer = this::deleteOffer;
    private final OfferOpRecordFunction<OfferOpRecordBO> abandonOffer = this::abandonOffer;
    private final OfferOpRecordFunction<OfferOpRecordBO> newOfferBill = this::newOfferBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> editOfferBill = this::editOfferBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> submitOfferBill = this::submitOfferBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> unSubmitOfferBill = this::unSubmitOfferBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> deleteOfferBill = this::deleteOfferBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> abandonOfferBill = this::abandonOfferBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> agreeApproval = this::agreeApproval;
    private final OfferOpRecordFunction<OfferOpRecordBO> disagreeApproval = this::disagreeApproval;
    private final OfferOpRecordFunction<OfferOpRecordBO> newOfferLetter = this::newOfferLetter;
    private final OfferOpRecordFunction<OfferOpRecordBO> sendOfferLetter = this::sendOfferLetter;
    private final OfferOpRecordFunction<OfferOpRecordBO> delaySendOfferLetter = this::delaySendOfferLetter;
    private final OfferOpRecordFunction<OfferOpRecordBO> abandonOfferLetter = this::abandonOfferLetter;
    private final OfferOpRecordFunction<OfferOpRecordBO> acceptOffer = this::acceptOffer;
    private final OfferOpRecordFunction<OfferOpRecordBO> refuseOffer = this::refuseOffer;
    private final OfferOpRecordFunction<OfferOpRecordBO> newOfferLetterBill = this::newOfferLetterBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> editOfferLetterBill = this::editOfferLetterBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> submitOfferLetterBill = this::submitOfferLetterBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> unSubmitOfferLetterBill = this::unSubmitOfferLetterBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> abandonOfferLetterBill = this::abandonOfferLetterBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> agreeApprovalOfferLetterBill = this::agreeApprovalOfferLetterBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> disagreeApprovalOfferLetterBill = this::disagreeApprovalOfferLetterBill;
    private final OfferOpRecordFunction<OfferOpRecordBO> changeOfferLetterValidTime = this::changeOfferLetterValidTime;

    public void sendOpRecord(OfferOpRecordBO offerOpRecordBO) {
        if (!this.checkBO(offerOpRecordBO)) {
            return;
        }
        OpDefEnum opDefEnum = offerOpRecordBO.getOpDefEnum();
        String operateName = offerOpRecordBO.getOperateName();
        LOG.info("OfferSendOpRecord type:{}, operateName:{}, pkIdList:{}", new Object[]{opDefEnum.getCode(), operateName, offerOpRecordBO.getDynamicObjectList().parallelStream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList())});
        OfferOpRecordFunction<OfferOpRecordBO> offerOpRecordFunction = FUNCTION_HASH_MAP.get(opDefEnum);
        if (Objects.nonNull(offerOpRecordFunction)) {
            List<OprecordMessageModel> modelList = offerOpRecordFunction.generateOpMessageModel(offerOpRecordBO);
            LOG.info("OfferSendOpRecord type:{}, modelList:{}", (Object)opDefEnum.getCode(), (Object)JSON.toJSONString(modelList));
            try {
                OprecordMQ.sendOpRecordChangeMessage(modelList);
            }
            catch (KDException ex) {
                LOG.error("OfferSendOpRecord error:", (Throwable)ex);
            }
        }
    }

    private List<OprecordMessageModel> agreeApprovalOfferLetterBill(OfferOpRecordBO offerOpRecordBO) {
        return this.agreeApproval(offerOpRecordBO);
    }

    private List<OprecordMessageModel> disagreeApprovalOfferLetterBill(OfferOpRecordBO offerOpRecordBO) {
        return this.disagreeApproval(offerOpRecordBO);
    }

    private List<OprecordMessageModel> newOfferLetterBill(OfferOpRecordBO offerOpRecordBO) {
        return this.newOfferBill(offerOpRecordBO);
    }

    private List<OprecordMessageModel> editOfferLetterBill(OfferOpRecordBO offerOpRecordBO) {
        return this.editOfferBill(offerOpRecordBO);
    }

    private List<OprecordMessageModel> submitOfferLetterBill(OfferOpRecordBO offerOpRecordBO) {
        return this.submitOfferBill(offerOpRecordBO);
    }

    private List<OprecordMessageModel> unSubmitOfferLetterBill(OfferOpRecordBO offerOpRecordBO) {
        return this.unSubmitOfferBill(offerOpRecordBO);
    }

    private List<OprecordMessageModel> abandonOfferLetterBill(OfferOpRecordBO offerOpRecordBO) {
        return this.abandonOfferBill(offerOpRecordBO);
    }

    private List<OprecordMessageModel> newOfferLetter(OfferOpRecordBO offerOpRecordBO) {
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(offer -> {
            String positionName = offer.getDynamicObject("recruposi").getString("name");
            String candidateName = offer.getString("candidatename");
            String operatorName = "";
            long operatorId = 0L;
            if (offerOpRecordBO.getStatus() == 1) {
                DynamicObject applicant = null;
                if (offer.get("applicant") instanceof Long) {
                    QFilter qFilter = new QFilter("id", "=", (Object)offer.getLong("applicant"));
                    applicant = QueryServiceHelper.queryOne((String)"bos_user", (String)"name", (QFilter[])qFilter.toArray());
                } else {
                    applicant = offer.getDynamicObject("applicant");
                }
                if (applicant != null) {
                    operatorName = applicant.getString("name");
                    operatorId = applicant.getLong("id");
                }
            } else {
                operatorName = requestContext.getUserName();
                operatorId = requestContext.getCurrUserId();
            }
            String opRecordText = OfferOpRecordTexts.newOfferLetter((String)operatorName, (String)positionName, (String)candidateName);
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, offer.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            offerModel.setOperator(Long.valueOf(operatorId));
            offerModel.setOperatorname(operatorName);
            this.setBizMapToModel(offerModel, (DynamicObject)offer);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> abandonOffer(OfferOpRecordBO offerOpRecordBO) {
        return this.abandonOfferLetter(offerOpRecordBO);
    }

    private List<OprecordMessageModel> deleteOfferBill(OfferOpRecordBO offerOpRecordBO) {
        return null;
    }

    private List<OprecordMessageModel> abandonOfferBill(OfferOpRecordBO offerOpRecordBO) {
        if (!(offerOpRecordBO instanceof AbandonOfferOpRecordBO)) {
            throw new KDBizException("generate abandonOfferOpRecord fail");
        }
        AbandonOfferOpRecordBO opRecordBO = (AbandonOfferOpRecordBO)offerOpRecordBO;
        List<DynamicObject> dynamicObjectList = opRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(dynamicObject -> {
            DynamicObject offerDy = null;
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.ABANDON_OFFER_APPFORM) {
                offerDy = dynamicObject;
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.ABANDON_OFFER_LETTER_CHANGE_FROM) {
                offerDy = dynamicObject;
            }
            String positionName = offerDy.getDynamicObject("recruposi").getString("name");
            String candidateName = offerDy.getString("candidatename");
            String opRecordText = "";
            String billNo = "";
            DynamicObject bill = null;
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.ABANDON_OFFER_APPFORM) {
                opRecordText = OfferOpRecordTexts.abandonOfferBill((String)requestContext.getUserName(), (String)opRecordBO.getOperateName(), (String)positionName, (String)candidateName, (String)opRecordBO.getAbandonReason());
                billNo = dynamicObject.getString("offerauditno");
                bill = OfferBillServiceHelper.getInstance().queryOneByAuditNo(billNo, "id");
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.ABANDON_OFFER_LETTER_CHANGE_FROM) {
                opRecordText = OfferOpRecordTexts.abandonOfferLetterBill((String)requestContext.getUserName(), (String)opRecordBO.getOperateName(), (String)positionName, (String)candidateName, (String)opRecordBO.getAbandonReason());
                billNo = dynamicObject.getString("letterauditno");
                bill = ChangeLetterBillHelper.getInstance().queryOneByAuditNo(billNo);
            }
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, offerDy.getLong("id"), opRecordText, opRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, offerDy);
            offerModel.setClicknumber(billNo);
            if (bill != null) {
                offerModel.setSkipPKId(bill.getString("id"));
            }
            offerModel.setSkipFormId(offerOpRecordBO.getSkipFormId());
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> newOffer(OfferOpRecordBO offerOpRecordBO) {
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(dynamicObject -> {
            String positionName = dynamicObject.getDynamicObject("recruposi").getString("name");
            String candidateName = dynamicObject.getString("candidatename");
            String opRecordText = OfferOpRecordTexts.newOffer((String)requestContext.getUserName(), (String)positionName, (String)candidateName, (String)offerOpRecordBO.getOperateName());
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, dynamicObject.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, (DynamicObject)dynamicObject);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> editOfferBase(OfferOpRecordBO offerOpRecordBO) {
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(dynamicObject -> {
            String positionName = dynamicObject.getDynamicObject("recruposi").getString("name");
            String candidateName = dynamicObject.getString("candidatename");
            String opRecordText = OfferOpRecordTexts.editOffer((String)requestContext.getUserName(), (String)offerOpRecordBO.getOperateName(), (String)positionName, (String)candidateName);
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, dynamicObject.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, (DynamicObject)dynamicObject);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> submitOfferBase(OfferOpRecordBO offerOpRecordBO) {
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(dynamicObject -> {
            String positionName = dynamicObject.getDynamicObject("recruposi").getString("name");
            String candidateName = dynamicObject.getString("candidatename");
            String opRecordText = OfferOpRecordTexts.submitOffer((String)requestContext.getUserName(), (String)offerOpRecordBO.getOperateName(), (String)positionName, (String)candidateName);
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, dynamicObject.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, (DynamicObject)dynamicObject);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> newOfferBill(OfferOpRecordBO offerOpRecordBO) {
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(dynamicObject -> {
            DynamicObject offerDy = null;
            String billNo = "";
            String skipPkId = "";
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.FOUND_OFFER_APPFORM) {
                offerDy = ((DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("offer");
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.FOUND_OFFER_LETTER_CHANGE_FROM) {
                billNo = dynamicObject.getString("billno");
                DynamicObject offerLetterBill = ChangeLetterBillHelper.getInstance().queryOneByAuditNo(billNo);
                if (offerLetterBill != null) {
                    skipPkId = offerLetterBill.getString("id");
                    dynamicObject = offerLetterBill;
                }
                offerDy = dynamicObject.getDynamicObject("offer");
            }
            String positionName = offerDy.getDynamicObject("recruposi").getString("name");
            String candidateName = offerDy.getString("candidatename");
            String opRecordText = "";
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.FOUND_OFFER_APPFORM) {
                opRecordText = OfferOpRecordTexts.newOfferBill((String)requestContext.getUserName(), (String)positionName, (String)candidateName);
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.FOUND_OFFER_LETTER_CHANGE_FROM) {
                opRecordText = OfferOpRecordTexts.newOfferLetterBill((String)requestContext.getUserName(), (String)positionName, (String)candidateName);
            }
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, offerDy.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, offerDy);
            offerModel.setClicknumber(billNo);
            offerModel.setSkipPKId(skipPkId);
            offerModel.setSkipFormId(offerOpRecordBO.getSkipFormId());
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> editOfferBill(OfferOpRecordBO offerOpRecordBO) {
        EditOfferBillOpRecordBO boForEditBill = null;
        if (offerOpRecordBO instanceof EditOfferBillOpRecordBO) {
            boForEditBill = (EditOfferBillOpRecordBO)offerOpRecordBO;
        }
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        if (boForEditBill != null && boForEditBill.isEditKeyWords()) {
            EditOfferBillOpRecordBO finalBO = boForEditBill;
            dynamicObjectList.forEach(dynamicObject -> {
                DynamicObject offerDy = ((DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("offer");
                String positionName = offerDy.getDynamicObject("recruposi").getString("name");
                String candidateName = offerDy.getString("candidatename");
                String opRecordText = OfferOpRecordTexts.editOfferBillWithKeyWords((String)requestContext.getUserName(), (String)finalBO.getOperateName(), (String)positionName, (String)candidateName, (String)finalBO.getKeyWords());
                OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, offerDy.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
                this.setBizMapToModel(offerModel, offerDy);
                this.updateSkipInfo(offerOpRecordBO, (DynamicObject)dynamicObject, offerModel);
                modelList.add(offerModel);
            });
        } else {
            dynamicObjectList.forEach(dynamicObject -> {
                DynamicObject offerDy = null;
                if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.EDIT_OFFER_APPFROM) {
                    offerDy = ((DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("offer");
                } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.EDIT_OFFER_LETTER_CHANGE_FROM) {
                    offerDy = dynamicObject.getDynamicObject("offer");
                }
                String positionName = offerDy.getDynamicObject("recruposi").getString("name");
                String candidateName = offerDy.getString("candidatename");
                String opRecordText = "";
                if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.EDIT_OFFER_APPFROM) {
                    opRecordText = OfferOpRecordTexts.editOfferBill((String)requestContext.getUserName(), (String)offerOpRecordBO.getOperateName(), (String)positionName, (String)candidateName);
                } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.EDIT_OFFER_LETTER_CHANGE_FROM) {
                    opRecordText = OfferOpRecordTexts.editOfferLetterBill((String)requestContext.getUserName(), (String)offerOpRecordBO.getOperateName(), (String)positionName, (String)candidateName);
                }
                OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, offerDy.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
                this.setBizMapToModel(offerModel, offerDy);
                this.updateSkipInfo(offerOpRecordBO, (DynamicObject)dynamicObject, offerModel);
                modelList.add(offerModel);
            });
        }
        return modelList;
    }

    private List<OprecordMessageModel> submitOfferBill(OfferOpRecordBO offerOpRecordBO) {
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        List offerAuditNos = dynamicObjectList.stream().map(dy -> dy.getString("billno")).collect(Collectors.toList());
        QFilter offerFilter = new QFilter("offerauditno", "in", offerAuditNos);
        OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();
        DynamicObject[] offerDys = offerServiceHelper.loadDynamicObjectArray(new QFilter[]{offerFilter});
        Map<String, Long> auditNoToOfferIdMaps = Arrays.stream(offerDys).collect(Collectors.toMap(dy -> dy.getString("offerauditno"), dy -> dy.getLong("id")));
        Map offerObjMap = Arrays.stream(offerDys).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (n1, n2) -> n1));
        dynamicObjectList.forEach(dynamicObject -> {
            DynamicObject offerDy = null;
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.SUB_OFFER_APPFORM) {
                offerDy = ((DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("offer");
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.COMMIT_OFFER_LETTER_CHANGE_FROM) {
                offerDy = dynamicObject.getDynamicObject("offer");
            }
            if (HRObjectUtils.isEmpty(offerDy)) {
                long offerId = (Long)auditNoToOfferIdMaps.get(dynamicObject.getString("billno"));
                offerDy = (DynamicObject)offerObjMap.get(offerId);
            }
            String positionName = offerDy.getDynamicObject("recruposi").getString("name");
            String candidateName = offerDy.getString("candidatename");
            String opRecordText = "";
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.SUB_OFFER_APPFORM) {
                opRecordText = OfferOpRecordTexts.submitOfferBill((String)requestContext.getUserName(), (String)offerOpRecordBO.getOperateName(), (String)positionName, (String)candidateName);
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.COMMIT_OFFER_LETTER_CHANGE_FROM) {
                opRecordText = OfferOpRecordTexts.submitOfferLetterBill((String)requestContext.getUserName(), (String)offerOpRecordBO.getOperateName(), (String)positionName, (String)candidateName);
            }
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, offerDy.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, offerDy);
            this.updateSkipInfo(offerOpRecordBO, (DynamicObject)dynamicObject, offerModel);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> unSubmitOfferBill(OfferOpRecordBO offerOpRecordBO) {
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        List offerAuditNos = dynamicObjectList.stream().map(dy -> dy.getString("billno")).collect(Collectors.toList());
        QFilter offerFilter = new QFilter("offerauditno", "in", offerAuditNos);
        OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();
        DynamicObject[] offerDys = offerServiceHelper.loadDynamicObjectArray(new QFilter[]{offerFilter});
        Map<String, Long> auditNoToOfferIdMaps = Arrays.stream(offerDys).collect(Collectors.toMap(dy -> dy.getString("offerauditno"), dy -> dy.getLong("id")));
        Map offerObjMap = Arrays.stream(offerDys).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (n1, n2) -> n1));
        dynamicObjectList.forEach(dynamicObject -> {
            DynamicObject offerDy = null;
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.REVOKE_OFFER_APPFORM) {
                offerDy = ((DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("offer");
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.REVOKE_OFFER_LETTER_CHANGE_FROM) {
                offerDy = dynamicObject.getDynamicObject("offer");
            }
            if (HRObjectUtils.isEmpty(offerDy)) {
                long offerId = (Long)auditNoToOfferIdMaps.get(dynamicObject.getString("billno"));
                offerDy = (DynamicObject)offerObjMap.get(offerId);
            }
            String positionName = offerDy.getDynamicObject("recruposi").getString("name");
            String candidateName = offerDy.getString("candidatename");
            String opRecordText = "";
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.REVOKE_OFFER_APPFORM) {
                opRecordText = OfferOpRecordTexts.unSubmitOfferBill((String)requestContext.getUserName(), (String)offerOpRecordBO.getOperateName(), (String)positionName, (String)candidateName);
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.REVOKE_OFFER_LETTER_CHANGE_FROM) {
                opRecordText = OfferOpRecordTexts.unSubmitOfferLetterBill((String)requestContext.getUserName(), (String)offerOpRecordBO.getOperateName(), (String)positionName, (String)candidateName);
            }
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, offerDy.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, offerDy);
            this.updateSkipInfo(offerOpRecordBO, (DynamicObject)dynamicObject, offerModel);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> agreeApproval(OfferOpRecordBO offerOpRecordBO) {
        if (!(offerOpRecordBO instanceof AgreeApprovalOfferOpRecordBO)) {
            throw new KDBizException("generate agreeApprovalOpRecord fail");
        }
        AgreeApprovalOfferOpRecordBO bo = (AgreeApprovalOfferOpRecordBO)offerOpRecordBO;
        List<DynamicObject> dynamicObjectList = bo.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(dynamicObject -> {
            DynamicObject offerDy = null;
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.AGREE_OFFER_APPFORM) {
                offerDy = ((DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("offer");
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.AGREE_OFFER_LETTER_CHANGE_FROM) {
                offerDy = dynamicObject.getDynamicObject("offer");
            }
            String positionName = offerDy.getDynamicObject("recruposi").getString("name");
            String candidateName = offerDy.getString("candidatename");
            String opRecordText = "";
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.AGREE_OFFER_APPFORM) {
                opRecordText = OfferOpRecordTexts.agreeApproval((String)requestContext.getUserName(), (String)positionName, (String)candidateName);
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.AGREE_OFFER_LETTER_CHANGE_FROM) {
                opRecordText = OfferOpRecordTexts.agreeApprovalOfferLetterBill((String)requestContext.getUserName(), (String)positionName, (String)candidateName);
            }
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, offerDy.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            if (bo.isEndNode()) {
                this.setBizMapToModel(offerModel, offerDy);
            }
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> disagreeApproval(OfferOpRecordBO offerOpRecordBO) {
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(dynamicObject -> {
            DynamicObject offerDy = null;
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.DISAGREE_OFFER_APPROVE) {
                offerDy = ((DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("offer");
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.DISANDEND_OFFER_LETTER_CHANGE_FROM) {
                offerDy = dynamicObject.getDynamicObject("offer");
            }
            String positionName = offerDy.getDynamicObject("recruposi").getString("name");
            String candidateName = offerDy.getString("candidatename");
            String opRecordText = OfferOpRecordTexts.disagreeApproval((String)requestContext.getUserName(), (String)positionName, (String)candidateName);
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.DISAGREE_OFFER_APPROVE) {
                opRecordText = OfferOpRecordTexts.disagreeApproval((String)requestContext.getUserName(), (String)positionName, (String)candidateName);
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.DISANDEND_OFFER_LETTER_CHANGE_FROM) {
                opRecordText = OfferOpRecordTexts.disagreeApprovalOfferLetterBill((String)requestContext.getUserName(), (String)positionName, (String)candidateName);
            }
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, offerDy.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, offerDy);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> sendOfferLetter(OfferOpRecordBO offerOpRecordBO) {
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(dynamicObject -> {
            String positionName = dynamicObject.getDynamicObject("recruposi").getString("name");
            String candidateName = dynamicObject.getString("candidatename");
            String opRecordText = OfferOpRecordTexts.sendOfferLetter((String)requestContext.getUserName(), (String)positionName, (String)candidateName, (String)offerOpRecordBO.getOperateName());
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, dynamicObject.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, (DynamicObject)dynamicObject);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> delaySendOfferLetter(OfferOpRecordBO offerOpRecordBO) {
        if (!(offerOpRecordBO instanceof DelaySendOfferOpRecordBO)) {
            throw new KDBizException("generate delaySendOpRecord fail");
        }
        DelaySendOfferOpRecordBO opRecordBO = (DelaySendOfferOpRecordBO)offerOpRecordBO;
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(dynamicObject -> {
            String positionName = dynamicObject.getDynamicObject("recruposi").getString("name");
            String candidateName = dynamicObject.getString("candidatename");
            String opRecordText = OfferOpRecordTexts.delaySendOffer((String)requestContext.getUserName(), (String)positionName, (String)candidateName, (String)opRecordBO.getOperateName(), (String)this.formatDate(opRecordBO.getLastSendTime()), (String)opRecordBO.getDelaySendReason());
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, dynamicObject.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, (DynamicObject)dynamicObject);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> changeOfferLetterValidTime(OfferOpRecordBO offerOpRecordBO) {
        if (!(offerOpRecordBO instanceof ChgOfferValidTimeOpRecordBO)) {
            throw new KDBizException("generate chgOfferValidTimeOpRecord fail");
        }
        ChgOfferValidTimeOpRecordBO opRecordBO = (ChgOfferValidTimeOpRecordBO)offerOpRecordBO;
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(offer -> {
            String positionName = offer.getDynamicObject("recruposi").getString("name");
            String candidateName = offer.getString("candidatename");
            String opRecordText = "";
            opRecordText = opRecordBO.getNewLastReplyTime() == null ? OfferOpRecordTexts.changValidTime((String)requestContext.getUserName(), (String)positionName, (String)candidateName, (String)this.formatDate(opRecordBO.getValidTime()), (String)opRecordBO.getChangeReason()) : OfferOpRecordTexts.changValidTimeAndLastReplyDate((String)requestContext.getUserName(), (String)positionName, (String)candidateName, (String)this.formatDate(opRecordBO.getValidTime()), (String)opRecordBO.getChangeReason(), (String)this.formatDate(opRecordBO.getNewLastReplyTime()));
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, offer.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, (DynamicObject)offer);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> abandonOfferLetter(OfferOpRecordBO offerOpRecordBO) {
        if (!(offerOpRecordBO instanceof AbandonOfferOpRecordBO)) {
            throw new KDBizException("generate abandonOfferOpRecord fail");
        }
        AbandonOfferOpRecordBO opRecordBO = (AbandonOfferOpRecordBO)offerOpRecordBO;
        List<DynamicObject> dynamicObjectList = opRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(dynamicObject -> {
            String positionName = dynamicObject.getDynamicObject("recruposi").getString("name");
            String candidateName = dynamicObject.getString("candidatename");
            String opRecordText = "";
            if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.ABANDON_OFFER) {
                opRecordText = OfferOpRecordTexts.abandonOffer((String)requestContext.getUserName(), (String)opRecordBO.getOperateName(), (String)positionName, (String)candidateName, (String)opRecordBO.getAbandonReason());
            } else if (offerOpRecordBO.getOpDefEnum() == OpDefEnum.ABANDON_OFFER_LETTER) {
                opRecordText = OfferOpRecordTexts.abandonOfferLetter((String)requestContext.getUserName(), (String)opRecordBO.getOperateName(), (String)positionName, (String)candidateName, (String)opRecordBO.getAbandonReason());
            }
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, dynamicObject.getLong("id"), opRecordText, opRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, (DynamicObject)dynamicObject);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> acceptOffer(OfferOpRecordBO offerOpRecordBO) {
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        dynamicObjectList.forEach(dynamicObject -> {
            String positionName = dynamicObject.getDynamicObject("recruposi").getString("name");
            String candidateName = dynamicObject.getString("candidatename");
            String opRecordText = OfferOpRecordTexts.acceptOffer((String)positionName, (String)candidateName, (String)offerOpRecordBO.getOperateName());
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, dynamicObject.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, (DynamicObject)dynamicObject);
            this.updateOperatorToCandidate((DynamicObject)dynamicObject, offerModel);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> refuseOffer(OfferOpRecordBO offerOpRecordBO) {
        if (!(offerOpRecordBO instanceof RefuseOfferOpRecordBO)) {
            throw new KDBizException("generate refuseOfferOpRecord fail");
        }
        RefuseOfferOpRecordBO bo = (RefuseOfferOpRecordBO)offerOpRecordBO;
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        dynamicObjectList.forEach(dynamicObject -> {
            String positionName = dynamicObject.getDynamicObject("recruposi").getString("name");
            String candidateName = dynamicObject.getString("candidatename");
            String opRecordText = OfferOpRecordTexts.refuseOffer((String)positionName, (String)candidateName, (String)bo.getOperateName(), (String)bo.getRefuseReason());
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, dynamicObject.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, (DynamicObject)dynamicObject);
            this.updateOperatorToCandidate((DynamicObject)dynamicObject, offerModel);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private List<OprecordMessageModel> deleteOffer(OfferOpRecordBO offerOpRecordBO) {
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>(dynamicObjectList.size());
        RequestContext requestContext = RequestContext.get();
        dynamicObjectList.forEach(dynamicObject -> {
            String positionName = dynamicObject.getDynamicObject("recruposi").getString("name");
            String candidateName = dynamicObject.getString("candidatename");
            String opRecordText = OfferOpRecordTexts.deleteOffer((String)requestContext.getUserName(), (String)offerOpRecordBO.getOperateName(), (String)positionName, (String)candidateName);
            OprecordMessageModel offerModel = this.generateOpMessageModel(candidateName, dynamicObject.getLong("id"), opRecordText, offerOpRecordBO.getOpDefEnum());
            this.setBizMapToModel(offerModel, (DynamicObject)dynamicObject);
            modelList.add(offerModel);
        });
        return modelList;
    }

    private String formatDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(date);
    }

    private boolean checkBO(OfferOpRecordBO offerOpRecordBO) {
        if (Objects.isNull(offerOpRecordBO)) {
            return false;
        }
        if (Objects.isNull(offerOpRecordBO.getOpDefEnum())) {
            return false;
        }
        List<DynamicObject> dynamicObjectList = offerOpRecordBO.getDynamicObjectList();
        return dynamicObjectList != null && !dynamicObjectList.isEmpty();
    }

    private OprecordMessageModel generateOpMessageModel(String candidateName, Long pkId, String opText, OpDefEnum opDefEnum) {
        OprecordMessageModel offerModel = new OprecordMessageModel();
        RequestContext requestContext = RequestContext.get();
        offerModel.setOperator(Long.valueOf(requestContext.getCurrUserId()));
        offerModel.setOperatorname(requestContext.getUserName());
        offerModel.setBizentry("tso_somk_offerbase");
        offerModel.setBizobjname(candidateName);
        offerModel.setBizobj(pkId.longValue());
        offerModel.setOpnumber(opDefEnum.getCode());
        offerModel.setOptime(DateUtils.nowDateTime());
        offerModel.setOprtext(opText);
        return offerModel;
    }

    private void updateSkipInfo(OfferOpRecordBO offerOpRecordBO, DynamicObject dynamicObject, OprecordMessageModel offerModel) {
        offerModel.setClicknumber(dynamicObject.getString("billno"));
        offerModel.setSkipPKId(dynamicObject.getString("id"));
        offerModel.setSkipFormId(offerOpRecordBO.getSkipFormId());
    }

    private void updateOperatorToCandidate(DynamicObject dynamicObject, OprecordMessageModel offerModel) {
        DynamicObject appFile = dynamicObject.getDynamicObject("appfile");
        offerModel.setOperator(Long.valueOf(appFile.getLong("id")));
        offerModel.setOperatorname(dynamicObject.getString("candidatename"));
    }

    private void setBizMapToModel(OprecordMessageModel model, DynamicObject dynamicObject) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        Object appFileObj = dynamicObject.get("appfile");
        if (appFileObj instanceof DynamicObject) {
            DynamicObject appFile = (DynamicObject)appFileObj;
            map.put("tspr_appfile", appFile.getLong("id"));
        }
        if (appFileObj instanceof Long) {
            map.put("tspr_appfile", Long.parseLong(appFileObj.toString()));
        }
        map.put("tso_somk_offerbase", dynamicObject.getLong("id"));
        model.setBizMap((Map)map);
    }

    private OfferSendOpRecordService() {
    }

    public static OfferSendOpRecordService getInstance() {
        return Instance.INSTANCE;
    }

    static {
        FUNCTION_HASH_MAP.put(OpDefEnum.EDIT_OFFER, OfferSendOpRecordService.getInstance().editOffer);
        FUNCTION_HASH_MAP.put(OpDefEnum.ADD_OFFER, OfferSendOpRecordService.getInstance().newOffer);
        FUNCTION_HASH_MAP.put(OpDefEnum.DELETE_OFFER, OfferSendOpRecordService.getInstance().deleteOffer);
        FUNCTION_HASH_MAP.put(OpDefEnum.SUBMIT_OFFER, OfferSendOpRecordService.getInstance().submitOfferBase);
        FUNCTION_HASH_MAP.put(OpDefEnum.ABANDON_OFFER, OfferSendOpRecordService.getInstance().abandonOffer);
        FUNCTION_HASH_MAP.put(OpDefEnum.FOUND_OFFER_APPFORM, OfferSendOpRecordService.getInstance().newOfferBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.EDIT_OFFER_APPFROM, OfferSendOpRecordService.getInstance().editOfferBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.SUB_OFFER_APPFORM, OfferSendOpRecordService.getInstance().submitOfferBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.REVOKE_OFFER_APPFORM, OfferSendOpRecordService.getInstance().unSubmitOfferBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.DELETE_OFFER_APPFORM, OfferSendOpRecordService.getInstance().deleteOfferBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.ABANDON_OFFER_APPFORM, OfferSendOpRecordService.getInstance().abandonOfferBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.AGREE_OFFER_APPFORM, OfferSendOpRecordService.getInstance().agreeApproval);
        FUNCTION_HASH_MAP.put(OpDefEnum.DISAGREE_OFFER_APPROVE, OfferSendOpRecordService.getInstance().disagreeApproval);
        FUNCTION_HASH_MAP.put(OpDefEnum.SEND_OFFER_LETTER, OfferSendOpRecordService.getInstance().sendOfferLetter);
        FUNCTION_HASH_MAP.put(OpDefEnum.DELAY_SEND_OFFER_LETTER, OfferSendOpRecordService.getInstance().delaySendOfferLetter);
        FUNCTION_HASH_MAP.put(OpDefEnum.ABANDON_OFFER_LETTER, OfferSendOpRecordService.getInstance().abandonOfferLetter);
        FUNCTION_HASH_MAP.put(OpDefEnum.ACCEPT_OFFER, OfferSendOpRecordService.getInstance().acceptOffer);
        FUNCTION_HASH_MAP.put(OpDefEnum.REFUSE_OFFER, OfferSendOpRecordService.getInstance().refuseOffer);
        FUNCTION_HASH_MAP.put(OpDefEnum.FOUND_OFFER_LETTER, OfferSendOpRecordService.getInstance().newOfferLetter);
        FUNCTION_HASH_MAP.put(OpDefEnum.FOUND_OFFER_LETTER_CHANGE_FROM, OfferSendOpRecordService.getInstance().newOfferLetterBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.EDIT_OFFER_LETTER_CHANGE_FROM, OfferSendOpRecordService.getInstance().editOfferLetterBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.COMMIT_OFFER_LETTER_CHANGE_FROM, OfferSendOpRecordService.getInstance().submitOfferLetterBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.REVOKE_OFFER_LETTER_CHANGE_FROM, OfferSendOpRecordService.getInstance().unSubmitOfferLetterBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.ABANDON_OFFER_LETTER_CHANGE_FROM, OfferSendOpRecordService.getInstance().abandonOfferLetterBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.AGREE_OFFER_LETTER_CHANGE_FROM, OfferSendOpRecordService.getInstance().agreeApprovalOfferLetterBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.DISANDEND_OFFER_LETTER_CHANGE_FROM, OfferSendOpRecordService.getInstance().disagreeApprovalOfferLetterBill);
        FUNCTION_HASH_MAP.put(OpDefEnum.CHANGE_OFFER_LETTER_VALID, OfferSendOpRecordService.getInstance().changeOfferLetterValidTime);
    }

    @FunctionalInterface
    private static interface OfferOpRecordFunction<T extends OfferOpRecordBO> {
        public List<OprecordMessageModel> generateOpMessageModel(T var1);
    }

    private static class Instance {
        private static final OfferSendOpRecordService INSTANCE = new OfferSendOpRecordService();

        private Instance() {
        }
    }
}

