/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.task;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tsrbd.common.constants.TSCBaseConstants;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class OfferDataMigrationTask
extends AbstractTask {
    private static final OfferServiceHelper OFFER_SERVICE_HELPER = OfferServiceHelper.getInstance();
    private static final HRBaseServiceHelper BILL_SERVICE_HELPER = new HRBaseServiceHelper("tso_somk_offerapproveinfo");
    private static final Log logger = LogFactory.getLog(OfferDataMigrationTask.class);
    private static final Set<String> ignoreKeys = Sets.newHashSet();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("OfferDataMigrationTask begin");
        DynamicObject[] approves = this.getApproveOffers();
        logger.info("in two years status is enable offerApproves.size()\uff1a{}", (Object)approves.length);
        List<Long> offerIds = null;
        try {
            offerIds = Arrays.stream(approves).map(approve -> {
                if (CollectionUtils.isEmpty((Collection)approve.getDynamicObjectCollection("entryentity"))) {
                    return null;
                }
                if (!HRObjectUtils.isEmpty((Object)((DynamicObject)approve.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("offer"))) {
                    return ((DynamicObject)approve.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("offer").getLong("id");
                }
                return null;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("OfferDataMigrationTask analysis error\uff1a", (Throwable)e);
            return;
        }
        logger.info("in two years status is enable offerIds.size()\uff1a{}", (Object)offerIds.size());
        DynamicObject[] offers = this.getOfferByOfferIds(offerIds);
        logger.info("in two years status is enable offers.size()\uff1a{}", (Object)offers.length);
        this.copyPropertiesToApprove(offers, approves);
        this.insertId(approves);
        BILL_SERVICE_HELPER.update(approves);
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("414+SY4TZBIZ");
        scheduleManager.disableSchedule("414+ZRMRXRU7");
    }

    private DynamicObject[] getApproveOffers() {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.add(1, -2);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.add(5, 3);
        QFilter filter = new QFilter("deletestatus", "=", (Object)DeleteEnum.NO_DELETE.getCode()).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("createtime", ">", (Object)beginCalendar.getTime())).and(new QFilter("createtime", "<", (Object)endCalendar.getTime()));
        DynamicObject[] objs = BILL_SERVICE_HELPER.query("id", filter.toArray());
        Object[] ids = Arrays.stream(objs).map(obj -> obj.getLong("id")).toArray();
        logger.info("OfferDataMigrationTask ids.size()\uff1a{}", (Object)ids.length);
        return BILL_SERVICE_HELPER.loadDynamicObjectArray(ids);
    }

    private DynamicObject[] getOfferByOfferIds(List<Long> offerIds) {
        QFilter qFilter = new QFilter("id", "in", offerIds).and(new QFilter("isdelete", "=", (Object)"0"));
        return OFFER_SERVICE_HELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    private void copyPropertiesToApprove(DynamicObject[] offers, DynamicObject[] approves) {
        for (DynamicObject offer : offers) {
            for (DynamicObject approve : approves) {
                for (DynamicObject entry : approve.getDynamicObjectCollection("entryentity")) {
                    DynamicObject entryOffer = entry.getDynamicObject("offer");
                    if (HRObjectUtils.isEmpty((Object)entryOffer) || entryOffer.getLong("id") != offer.getLong("id")) continue;
                    try {
                        HRDynamicObjectUtils.copy((DynamicObject)offer, (DynamicObject)approve, ignoreKeys);
                    }
                    catch (Exception e) {
                        logger.error("OfferDataMigrationTask copyPropertiesToApprove error\uff1a", (Throwable)e);
                    }
                }
            }
        }
    }

    private void insertId(DynamicObject[] approves) {
        List approveIds = Arrays.stream(approves).map(approve -> approve.getLong("id")).collect(Collectors.toList());
        String queryACount = "SELECT (1) FROM T_TSO_OFFERAPPROVE_A WHERE FID = ?";
        String queryBCount = "SELECT (1) FROM T_TSO_OFFERAPPROVE_B WHERE FID = ?";
        String queryCCount = "SELECT (1) FROM T_TSO_OFFERAPPROVE_C WHERE FID = ?";
        String insertASql = "INSERT INTO T_TSO_OFFERAPPROVE_A (FID) VALUES (?)";
        String insertBSql = "INSERT INTO T_TSO_OFFERAPPROVE_B (FID) VALUES (?)";
        String insertCSql = "INSERT INTO T_TSO_OFFERAPPROVE_C (FID) VALUES (?)";
        for (Long approveId : approveIds) {
            Boolean isHasC;
            Boolean isHasB;
            Boolean isHasA = (Boolean)HRDBUtil.query((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)queryACount, (Object[])new Object[]{approveId}, resultSet -> {
                boolean next = resultSet.next();
                if (next) {
                    return resultSet.getInt(1) >= 1;
                }
                return Boolean.FALSE;
            });
            if (!isHasA.booleanValue()) {
                HRDBUtil.execute((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)insertASql, (Object[])new Object[]{approveId});
            }
            if (!(isHasB = (Boolean)HRDBUtil.query((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)queryBCount, (Object[])new Object[]{approveId}, resultSet -> {
                boolean next = resultSet.next();
                if (next) {
                    return resultSet.getInt(1) >= 1;
                }
                return Boolean.FALSE;
            })).booleanValue()) {
                HRDBUtil.execute((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)insertBSql, (Object[])new Object[]{approveId});
            }
            if ((isHasC = (Boolean)HRDBUtil.query((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)queryCCount, (Object[])new Object[]{approveId}, resultSet -> {
                boolean next = resultSet.next();
                if (next) {
                    return resultSet.getInt(1) >= 1;
                }
                return Boolean.FALSE;
            })).booleanValue()) continue;
            HRDBUtil.execute((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)insertCSql, (Object[])new Object[]{approveId});
        }
        DataEntityCacheManager manager = new DataEntityCacheManager("tso_somk_offerapproveinfo");
        manager.removeByDt();
    }

    static {
        ignoreKeys.add("id");
        ignoreKeys.add("billno");
        ignoreKeys.add("billstatus");
        ignoreKeys.add("creator");
        ignoreKeys.add("modifier");
        ignoreKeys.add("auditor");
        ignoreKeys.add("auditdate");
        ignoreKeys.add("modifytime");
        ignoreKeys.add("createtime");
        ignoreKeys.add("barcode");
        ignoreKeys.add("isexistsworkflow");
        ignoreKeys.add("inputdevicetype");
        ignoreKeys.add("auditstatus");
        ignoreKeys.add("tpdataid");
        ignoreKeys.add("tpdatanum");
        ignoreKeys.add("tptenantid");
        ignoreKeys.add("tpsys");
        ignoreKeys.add("applicant");
        ignoreKeys.add("applytime");
        ignoreKeys.add("terminatedesc");
        ignoreKeys.add("applycontent");
        ignoreKeys.add("busunit");
        ignoreKeys.add("applycompletetime");
        ignoreKeys.add("hireapprovalid");
        ignoreKeys.add("auditusers");
        ignoreKeys.add("offerabandondesc");
        ignoreKeys.add("deletestatus");
        ignoreKeys.add("enable");
        ignoreKeys.add("entryentity.offer");
        ignoreKeys.add("entryentity.offerauditstatus");
        ignoreKeys.add("entryentity.offerterminatedesc");
        ignoreKeys.add("entryentity.isdelete");
        ignoreKeys.add("entryentity.offermodifier");
        ignoreKeys.add("entryentity.signstatus");
        ignoreKeys.add("entryentity.offermodifytime");
        ignoreKeys.add("entryentity.appfile");
    }
}

