/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.task;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.tsc.tso.business.domain.mq.model.OfferChangeModel;
import kd.tsc.tso.business.domain.mq.producer.OfferChangeProducer;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tsrbd.common.constants.TSCBaseConstants;
import kd.tsc.tsrbs.common.enums.DeleteEnum;
import org.apache.commons.collections.CollectionUtils;

public class OfferLatestReplyDateExceededTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(OfferLatestReplyDateExceededTask.class);
    private final OfferLetterServiceHelper letterHelper = OfferLetterServiceHelper.getInstance();
    private OfferParamConfigService offerParamConfigService = OfferParamConfigService.getInstance();
    private static final String[] PROPERTIES = new String[]{"offer", "appfile", "letterstatus"};

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Object[] values;
        log.info("\u8d85\u8fc7\u6700\u665a\u56de\u590d\u65e5\u671f\u672a\u56de\u590d\u4efb\u52a1");
        Calendar validTime = Calendar.getInstance();
        validTime.add(5, -1);
        QFilter filter = new QFilter("letterstatus", "=", (Object)OfferLetterStatus.ALR_SEND.getCode()).and(new QFilter("replystatus", "=", (Object)OfferLetterReplyStatus.PRE_REPLY.getCode())).and(new QFilter("datastatus", "=", (Object)OfferLetterDataStatus.TAKE_EFFECT.getCode())).and(new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode()));
        DynamicObject[] dynamicObjects = this.letterHelper.query("lastreplytime", filter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        long timeInMillis = calendar.getTimeInMillis();
        Calendar largeDate = Calendar.getInstance();
        largeDate.add(5, -2);
        largeDate.set(11, 23);
        largeDate.set(12, 59);
        largeDate.set(13, 59);
        largeDate.set(14, 999);
        long largeTimeInMillis = largeDate.getTimeInMillis();
        ArrayList<DynamicObject> lists = new ArrayList<DynamicObject>(16);
        for (DynamicObject dyn : dynamicObjects) {
            if (null == dyn.getDate("lastreplytime") || dyn.getDate("lastreplytime").getTime() >= timeInMillis || dyn.getDate("lastreplytime").getTime() <= largeTimeInMillis) continue;
            lists.add(dyn);
        }
        if (CollectionUtils.isEmpty(lists)) {
            return;
        }
        long letterDatatStatus = OfferLetterDataStatus.TAKE_EFFECT.getCode();
        boolean isInvalid = this.offerParamConfigService.getInvalidConfig("noreplayouttime");
        log.info("\u3010OfferLatestReplyDateExceededTask\u3011\"execute\" isInvalid : {} ", (Object)isInvalid);
        List<Long> letterIds = lists.stream().map(list -> list.getLong("id")).collect(Collectors.toList());
        String updateSetSql = "UPDATE T_TSO_OFFERLETTER SET FREPLYSTATUSID = ?, FDATASTATUSID = ?, FMODIFYTIME = ? ";
        String updateWhereSql = " where FID IN (" + Joiner.on((String)",").skipNulls().join(letterIds) + ") AND FSTATUSID = ?  AND FDATASTATUSID = ? AND FISDELETE = ? AND FREPLYSTATUSID = ?";
        if (isInvalid) {
            letterDatatStatus = OfferLetterDataStatus.INVALID.getCode();
            updateSetSql = updateSetSql + ", FVALIDTIME = ?";
            values = new Object[]{OfferLetterReplyStatus.ALR_OUTTIME.getCode(), letterDatatStatus, KDDateUtils.now(), validTime.getTime(), OfferLetterStatus.ALR_SEND.getCode(), OfferLetterDataStatus.TAKE_EFFECT.getCode(), DeleteEnum.NO_DELETE.getCode(), OfferLetterReplyStatus.PRE_REPLY.getCode()};
        } else {
            values = new Object[]{OfferLetterReplyStatus.ALR_OUTTIME.getCode(), letterDatatStatus, KDDateUtils.now(), OfferLetterStatus.ALR_SEND.getCode(), OfferLetterDataStatus.TAKE_EFFECT.getCode(), DeleteEnum.NO_DELETE.getCode(), OfferLetterReplyStatus.PRE_REPLY.getCode()};
        }
        String updateSql = updateSetSql + updateWhereSql;
        log.info("\u3010OfferLatestReplyDateExceededTask\u3011\"execute\" updateLetterSql : {} ", (Object)updateSql);
        HRDBUtil.update((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)updateSql, (Object[])values);
        DataEntityCacheManager manager = new DataEntityCacheManager("T_TSO_OFFERLETTER");
        manager.removeByDt();
        this.asyncMessage(letterIds);
    }

    private void asyncMessage(List<Long> letterIds) {
        QFilter filter = new QFilter("replystatus", "=", (Object)OfferLetterReplyStatus.ALR_OUTTIME.getCode()).and(new QFilter("id", "in", letterIds));
        String selectProperties = Joiner.on((char)',').join((Object[])PROPERTIES);
        DynamicObject[] dynamicObjects = this.letterHelper.query(selectProperties, filter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long appfileId = dynamicObject.getDynamicObject("appfile").getLong("id");
            long offerId = dynamicObject.getLong("offer.id");
            OfferChangeModel offerChangeModel = new OfferChangeModel(appfileId, OfferLetterReplyStatus.ALR_OUTTIME.getCode(), offerId);
            modelList.add(offerChangeModel);
        }
        OfferChangeProducer.sendOfferChangeBatch(modelList);
    }
}

