/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.task;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.tsc.tso.business.domain.mq.model.OfferChangeModel;
import kd.tsc.tso.business.domain.mq.producer.OfferChangeProducer;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tsrbd.common.constants.TSCBaseConstants;
import kd.tsc.tsrbs.common.enums.DeleteEnum;
import org.apache.commons.collections.CollectionUtils;

public class OfferLatestSendDateExceededTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(OfferLatestSendDateExceededTask.class);
    private final OfferLetterServiceHelper letterHelper = OfferLetterServiceHelper.getInstance();
    private static final String[] PROPERTIES = new String[]{"offer", "appfile", "letterstatus"};

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("\u8d85\u8fc7\u6700\u665a\u53d1\u9001\u65e5\u671f\u672a\u53d1\u9001\u4efb\u52a1");
        QFilter filter = new QFilter("letterstatus", "=", (Object)OfferLetterStatus.PRE_SEND.getCode()).and(new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode()));
        DynamicObject[] dynamicObjects = this.letterHelper.query("lastsendtime", filter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        long timeInMillis = calendar.getTimeInMillis();
        ArrayList<DynamicObject> lists = new ArrayList<DynamicObject>(16);
        for (DynamicObject dy : dynamicObjects) {
            if (null == dy.getDate("lastsendtime") || dy.getDate("lastsendtime").getTime() > timeInMillis) continue;
            lists.add(dy);
        }
        if (CollectionUtils.isEmpty(lists)) {
            return;
        }
        List<Long> letterIds = lists.stream().map(list -> list.getLong("id")).collect(Collectors.toList());
        String updateSql = "UPDATE T_TSO_OFFERLETTER SET FSTATUSID = ?, FMODIFYTIME = ? where FID IN (" + Joiner.on((String)",").skipNulls().join(letterIds) + ") AND FSTATUSID = ? AND  FISDELETE = ?";
        Object[] values = new Object[]{OfferLetterStatus.NOSEND_OUTTIME.getCode(), Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), OfferLetterStatus.PRE_SEND.getCode(), DeleteEnum.NO_DELETE.getCode()};
        log.info("\u3010OfferLatestSendDateExceededTask\u3011\"execute\" sql : {} ", (Object)updateSql);
        HRDBUtil.update((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)updateSql, (Object[])values);
        DataEntityCacheManager manager = new DataEntityCacheManager("T_TSO_OFFERLETTER");
        manager.removeByDt();
        this.asyncMessage(letterIds);
    }

    private void asyncMessage(List<Long> letterIds) {
        QFilter filter = new QFilter("letterstatus", "=", (Object)OfferLetterStatus.NOSEND_OUTTIME.getCode()).and(new QFilter("id", "in", letterIds));
        String selectProperties = Joiner.on((char)',').join((Object[])PROPERTIES);
        DynamicObject[] dynamicObjects = this.letterHelper.query(selectProperties, filter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long appfileId = dynamicObject.getDynamicObject("appfile").getLong("id");
            long offerId = dynamicObject.getLong("offer.id");
            OfferChangeModel offerChangeModel = new OfferChangeModel(appfileId, OfferLetterStatus.NOSEND_OUTTIME.getCode(), offerId);
            modelList.add(offerChangeModel);
        }
        OfferChangeProducer.sendOfferChangeBatch(modelList);
    }
}

