/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.business.domain.offer.task;

import com.google.common.base.Joiner;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tsrbd.common.constants.TSCBaseConstants;
import kd.tsc.tsrbs.common.enums.DeleteEnum;
import org.apache.commons.collections.CollectionUtils;

public class OfferRejectAfterExpirationTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(OfferRejectAfterExpirationTask.class);
    private final OfferLetterServiceHelper letterHelper = OfferLetterServiceHelper.getInstance();
    private OfferParamConfigService offerParamConfigService = OfferParamConfigService.getInstance();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("\u5df2\u62d2\u7edd\u4e14\u8d85\u8fc7offer\u6709\u6548\u671f\u5931\u6548\u4efb\u52a1");
        boolean isInvalid = this.offerParamConfigService.getInvalidConfig("outvalidtime");
        log.info("\u3010OfferRejectAfterExpirationTask\u3011\"execute\" isInvalid : {} ", (Object)isInvalid);
        if (!isInvalid) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        long timeInMillis = calendar.getTimeInMillis();
        Calendar largeDate = Calendar.getInstance();
        largeDate.add(5, -1);
        largeDate.set(11, 0);
        largeDate.set(12, 0);
        largeDate.set(13, 0);
        long largeTimeInMillis = largeDate.getTimeInMillis();
        QFilter filter = new QFilter("datastatus", "=", (Object)OfferLetterDataStatus.TAKE_EFFECT.getCode()).and(new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode()));
        DynamicObject[] dynamicObjects = this.letterHelper.query("validtime", filter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        ArrayList<DynamicObject> lists = new ArrayList<DynamicObject>(16);
        for (DynamicObject dy : dynamicObjects) {
            if (null == dy.getDate("validtime") || dy.getDate("validtime").getTime() > timeInMillis || dy.getDate("validtime").getTime() < largeTimeInMillis) continue;
            lists.add(dy);
        }
        if (CollectionUtils.isEmpty(lists)) {
            return;
        }
        List letterIds = lists.stream().map(list -> list.getLong("id")).collect(Collectors.toList());
        String updateLetterSql = "UPDATE T_TSO_OFFERLETTER SET FDATASTATUSID = ?, FMODIFYTIME = ? where FID IN (" + Joiner.on((String)",").skipNulls().join(letterIds) + ")  AND FDATASTATUSID = ? AND FISDELETE = ?";
        Object[] values = new Object[]{OfferLetterDataStatus.INVALID.getCode(), Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), OfferLetterDataStatus.TAKE_EFFECT.getCode(), DeleteEnum.NO_DELETE.getCode()};
        log.info("\u3010OfferRejectAfterExpirationTask\u3011\"execute\" updateLetterSql : {} ", (Object)updateLetterSql);
        HRDBUtil.update((DBRoute)TSCBaseConstants.DB_ROUTE_TSC, (String)updateLetterSql, (Object[])values);
        DataEntityCacheManager manager = new DataEntityCacheManager("T_TSO_OFFERLETTER");
        manager.removeByDt();
    }
}

