/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.induction.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.field.DecimalEdit;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tso.business.domain.induction.helper.InductionFieldEditSwitchHelper;
import kd.tsc.tso.business.domain.induction.service.InductionFormService;
import kd.tsc.tso.business.domain.offer.service.OfferFieldEnableService;
import kd.tsc.tso.common.enums.TSOPreDataEnum;
import kd.tsc.tso.common.util.InductionFieldEditSwitch;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import org.apache.commons.lang3.tuple.Pair;

public class InductionBasicInfoEdit
extends HRCoreBaseBillEdit {
    private InductionFormService inductionFormService = InductionFormService.Singleton.INSTANCE.getInstance();

    public void afterLoadData(EventObject eventObject) {
        super.afterLoadData(eventObject);
        this.getView().setVisible(Boolean.valueOf(OfferUtils.hasPeriodTerm((DynamicObject)this.getModel().getDataEntity(true))), new String[]{"prpesalaryinfo", "pperiodterm", "pperiodtermunit"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        int workAge = this.getModel().getDataEntity(true).getInt("candidateworkage");
        if (!HRObjectUtils.isEmpty((Object)workAge)) {
            String workYear = ResumeAnalysisHelper.getWorkYearShow((int)workAge);
            this.getModel().setValue("workage", (Object)workYear);
        }
    }

    public void afterBindData(EventObject eventObject) {
        BillShowParameter showParameter;
        super.afterBindData(eventObject);
        Object newValue = this.getModel().getValue("ishaveperiodterm");
        DecimalEdit pPeriodTermEdit = (DecimalEdit)this.getView().getControl("pperiodterm");
        if ("1".equals(newValue)) {
            pPeriodTermEdit.setMustInput(true);
        }
        if (HRStringUtils.equals((String)((String)(showParameter = (BillShowParameter)this.getView().getFormShowParameter()).getCustomParam("fromPage")), (String)"appFilePage")) {
            this.initFieldEditSwitchInfo(0L);
            this.handleFieldEdit();
            return;
        }
        this.initFieldEditSwitchInfo(Long.parseLong(showParameter.getPkId().toString()));
        int age = this.getModel().getDataEntity(true).getInt("candidateage");
        if (age == 0) {
            int candidateAge = this.inductionFormService.getCandidateAge(Long.valueOf(this.getModel().getDataEntity(true).getLong("appfile.id")));
            this.getModel().setValue("candidateage", (Object)candidateAge);
            this.getView().updateView("candidateage");
        }
        this.handleFieldEdit();
    }

    private void handleFieldEdit() {
        String isHavePeriodTerm;
        Object peAdminOrgValue = this.getModel().getValue("peadminorg");
        if (peAdminOrgValue == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"peposition"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"peposition"});
        }
        DynamicObject jobDy = (DynamicObject)this.getModel().getValue("pejob");
        if (HRObjectUtils.isEmpty((Object)jobDy)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"joblevel", "jobgrade"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"joblevel", "jobgrade"});
        }
        DynamicObject laborRelTypeClsDy = (DynamicObject)this.getModel().getValue("laborreltypecls");
        if (HRObjectUtils.isEmpty((Object)laborRelTypeClsDy)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"emprelationtype"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"emprelationtype"});
        }
        String postMode = this.getModel().getValue("postassignmode").toString();
        if ("2".equals(postMode) || "3".equals(postMode)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"pejob"});
        }
        if (HRStringUtils.equals((String)(isHavePeriodTerm = (String)this.getModel().getValue("ishaveperiodterm")), (String)"0")) {
            this.lockPeriodTerm();
            this.getView().setVisible(Boolean.FALSE, new String[]{"pperiodtermunit", "pperiodterm"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"flex_haveperiodterm"});
        }
    }

    private void lockPeriodTerm() {
        DynamicObject laborRelTypeClsDy = (DynamicObject)this.getModel().getValue("laborreltypecls");
        if (HRObjectUtils.isEmpty((Object)laborRelTypeClsDy)) {
            return;
        }
        long laborRelTypeClsDyId = laborRelTypeClsDy.getLong("id");
        if (laborRelTypeClsDyId == TSOPreDataEnum.LABORRELRELTYPECLS_PROBATION.getId() || laborRelTypeClsDyId == TSOPreDataEnum.LABORRELRELTYPECLS_REHIRE.getId()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"flex_haveperiodterm"});
            this.getModel().setValue("ishaveperiodterm", (Object)"0");
            this.getView().setVisible(Boolean.FALSE, new String[]{"pperiodtermunit", "pperiodterm"});
        }
    }

    protected void initFieldEditSwitchInfo(Long offerId) {
        JSONObject fieldEnableJsonObj;
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            return;
        }
        String fieldEnableJson = this.getPageCache().get("fieldSwitchCacheKey");
        if (HRStringUtils.isEmpty((String)fieldEnableJson)) {
            if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("fromPage")), (String)"appFilePage") && offerId == 0L) {
                InductionFieldEditSwitch fieldEditSetting = InductionFieldEditSwitch.init();
                this.getPageCache().put("fieldSwitchCacheKey", JSON.toJSON((Object)fieldEditSetting.getFieldEditSetting()).toString());
                return;
            }
            fieldEnableJsonObj = InductionFieldEditSwitchHelper.getInstance().queryFieldEnableJsonByOfferId(offerId);
            if (Objects.isNull(fieldEnableJsonObj)) {
                return;
            }
            this.getPageCache().put("fieldSwitchCacheKey", fieldEnableJsonObj.toJSONString());
        } else {
            fieldEnableJsonObj = JSONObject.parseObject((String)fieldEnableJson);
        }
        Pair pair = OfferFieldEnableService.getInstance().partJsonByEnable(fieldEnableJsonObj);
        List enableFieldList = (List)pair.getLeft();
        List unEnableFieldList = (List)pair.getRight();
        this.getView().setEnable(Boolean.FALSE, unEnableFieldList.toArray(new String[0]));
        this.getView().setEnable(Boolean.TRUE, enableFieldList.toArray(new String[0]));
    }
}

