/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.induction.base;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tso.business.domain.attachment.AttachmentService;
import kd.tsc.tso.business.domain.induction.helper.InductionFieldEditSwitchHelper;
import kd.tsc.tso.business.domain.induction.helper.InductionFormHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferOnlyViewHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.induction.InductionServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.common.constants.offer.multilanguage.InductionOpMultiLangConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.induction.InductionStatus;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsrbd.business.domain.common.service.TscMutexHelper;
import kd.tsc.tsrbd.business.domain.rewardrule.RewardRuleQFilterHelper;
import kd.tsc.tsrbd.business.utils.BizAttachmentUtil;
import kd.tsc.tsrbd.common.enums.TSRBDPreDataEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class InductionInfoEdit
extends HRCoreBaseBillEdit
implements TabSelectListener,
BeforeF7SelectListener {
    private static final String CANCEL_OFFER_CONFIRM_FLAG = "cancelOfferConfirm";
    private static final String CLOSE_OFFER_CONFIRM_FLAG = "closeOfferConfirm";
    private static final Log LOG = LogFactory.getLog(InductionInfoEdit.class);
    private InductionServiceHelper inductionServiceHelper = InductionServiceHelper.Singleton.INSTANCE.getInstance();
    private static final AttachmentService attachmentService = AttachmentService.Singleton.INSTANCE.getInstance();

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        BillShowParameter showParameter = (BillShowParameter)preOpenFormEventArgs.getFormShowParameter();
        if (HRStringUtils.equals((String)((String)showParameter.getCustomParam("fromPage")), (String)"appFilePage")) {
            showParameter.setCaption(InductionOpMultiLangConstants.inductionInfoName() + "-" + showParameter.getCustomParam("name"));
            return;
        }
        if (showParameter.getPkId() == null && showParameter.getCustomParam("id") != null) {
            showParameter.setPkId((Object)Long.valueOf((String)showParameter.getCustomParam("id")));
        }
        if (OfferOnlyViewHelper.checkIsOnlyView((FormShowParameter)showParameter)) {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"busunit", "candidatename"});
        DynamicObject offerInfoById = InductionFormHelper.Singleton.INSTANCE.getInstance().queryOne(selectProperties, (Object)Long.parseLong(showParameter.getPkId().toString()));
        showParameter.setCaption(InductionOpMultiLangConstants.inductionInfoName() + "-" + offerInfoById.getString("candidatename"));
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit recruscene = (BasedataEdit)this.getControl("recruscene");
        recruscene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit peadminOrg = (BasedataEdit)this.getControl("peadminorg");
        peadminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName;
        switch (propertyName = beforeF7SelectEvent.getProperty().getName()) {
            case "recruscene": {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject type = (DynamicObject)this.getModel().getValue("recrutyp");
                QFilter qFilter = RewardRuleQFilterHelper.queryRecrusceneByRecrutyp((long)type.getLong("id"));
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        switch (propertyChangedArgs.getProperty().getName()) {
            case "credentialstype": {
                DynamicObject credentialsType = this.getModel().getDataEntity(true).getDynamicObject("credentialstype");
                if (!HRObjectUtils.isEmpty((Object)credentialsType)) break;
                this.getModel().setValue("credentialsnumber", null);
                break;
            }
        }
        this.getView().updateView();
    }

    public void afterLoadData(EventObject eventObject) {
        super.afterLoadData(eventObject);
        this.initOtherTabInfo();
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        DateTimeEdit dateEdit = (DateTimeEdit)this.getControl("pemploymenttime");
        dateEdit.setMinDate(DateUtils.afterNowDate((int)1));
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            Long offerId = (Long)this.getView().getFormShowParameter().getCustomParam("offerId");
            if (offerId == null || offerId == 0L) {
                return;
            }
            List attachments = OfferAttachmentService.getInstance().getOfferAttachment((Object)offerId);
            if (CollectionUtils.isNotEmpty((Collection)attachments)) {
                List list = BizAttachmentUtil.copyAndSaveTempAttachments((List)attachments);
                AttachmentPanel attachmentpanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
                attachmentpanel.bindData(list);
            }
            return;
        }
        this.initAttachment();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
        }
    }

    private void initAttachment() {
        long inductionId = this.getInductionId();
        QFilter qFilter = new QFilter("id", "=", (Object)inductionId);
        DynamicObject dynamicObject = this.inductionServiceHelper.queryOne("offer_id", new QFilter[]{qFilter});
        List attachments = OfferAttachmentService.getInstance().getOfferAttachment((Object)dynamicObject.getLong("offer_id"));
        List attachmentList = attachmentService.getAttachmentList("tso_inductioninfo", (Object)inductionId, "attachmentpanelap");
        attachments.addAll(attachmentList);
        if (CollectionUtils.isNotEmpty((Collection)attachments)) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
            attachmentPanel.bindData(attachments);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (operate.getOperateKey().equals("save")) {
            if (this.validateApplyEmp()) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4ebaOffer\u73af\u8282\u672a\u5b8c\u6210\uff0c\u6216\u5df2\u5b58\u5728\u6709\u6548\u7684\u5165\u804c\u534f\u540c\u5355\u636e\u3002", (String)"InductionInfoEdit_2", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                return;
            }
            long currUserId = RequestContext.get().getCurrUserId();
            Date nowDateTime = DateUtils.nowDateTime();
            this.getModel().getDataEntity(true).set("applicant", (Object)currUserId);
            this.getModel().getDataEntity(true).set("applytime", (Object)nowDateTime);
            if (this.getModel().getDataEntity(true).get("pperiodterm") == null) {
                this.getModel().getDataEntity(true).set("pperiodterm", (Object)0);
            }
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
                Object appfileId = this.getView().getFormShowParameter().getCustomParam("appfile");
                if (appfileId == null) {
                    args.setCancel(true);
                    return;
                }
                DynamicObject appfileDy = AppFileHelper.queryOne((long)Long.parseLong(String.valueOf(appfileId)));
                if (HRObjectUtils.isEmpty((Object)appfileDy)) {
                    args.setCancel(true);
                    return;
                }
                if (appfileDy.getBoolean("isdelete")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"InductionInfoEdit_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (this.getModel().getValue("peadminorg") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u62df\u5165\u804c\u90e8\u95e8\"\u3002", (String)"InductionInfoEdit_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                this.getModel().getDataEntity().set("number", (Object)CodeRuleServiceHelper.getNumber((String)"tso_inductioninfo", (DynamicObject)this.getModel().getDataEntity(), null));
                InductionFieldEditSwitchHelper.getInstance().updateFieldSwitch(this.getView());
                return;
            }
            InductionFieldEditSwitchHelper.getInstance().updateFieldSwitch(this.getView());
        }
        if (operate.getOperateKey().equals("cancel")) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }

    private boolean validateApplyEmp() {
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT) {
            return false;
        }
        long appfileId = this.getModel().getDataEntity().getLong("appfile.id");
        if (appfileId == 0L) {
            return false;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        DynamicObject appfileDy = serviceHelper.queryOne((Object)appfileId);
        if (HRObjectUtils.isEmpty((Object)appfileDy)) {
            return false;
        }
        long offerStatusId = appfileDy.getLong("offer.status.id");
        long offerLetterStatusId = appfileDy.getLong("offerletter.datastatus.id");
        long offerReplyStatusId = appfileDy.getLong("offerletter.replystatus.id");
        String inductionStatus = appfileDy.getString("inductioninfo.inductionstatus");
        return !(offerStatusId == 0L && HRStringUtils.isEmpty((String)inductionStatus) || offerLetterStatusId == 1030020L && offerReplyStatusId == 1040030L && HRStringUtils.isEmpty((String)inductionStatus));
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        beforeClosedEvent.setCheckDataChange(false);
        String isConfirm = this.getPageCache().get("isConfirm");
        if (this.getModel().getDataChanged() && this.getPageStatus() != OperationStatus.VIEW && !HRStringUtils.equals((String)isConfirm, (String)"1")) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5185\u5bb9\u5df2\u53d8\u66f4\uff0c\u76f4\u63a5\u53d6\u6d88\u5c06\u4e22\u5931\u66f4\u6539\u7684\u5185\u5bb9\uff0c\u786e\u8ba4\u53d6\u6d88\u5417\uff1f", (String)"OfferInfoAbstractPlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CLOSE_OFFER_CONFIRM_FLAG, (IFormPlugin)this));
            beforeClosedEvent.setCancel(true);
        } else {
            MutexHelper.release((IFormView)this.getView());
        }
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("fromPage")), (String)"appFilePage")) {
            Object appfileId = this.getView().getFormShowParameter().getCustomParam("appfile");
            TscMutexHelper.releaseMutex((String)"tso_inductioninfo", (Long)Long.valueOf(String.valueOf(appfileId)), (String)"applyemp");
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        MutexHelper.release((IFormView)this.getView());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (result == MessageBoxResult.Yes) {
            this.getPageCache().put("isConfirm", "1");
            if (HRStringUtils.equals((String)callBackId, (String)CANCEL_OFFER_CONFIRM_FLAG)) {
                this.handleCancelOperate();
            }
            if (HRStringUtils.equals((String)callBackId, (String)CLOSE_OFFER_CONFIRM_FLAG)) {
                MutexHelper.release((IFormView)this.getView());
                if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("fromPage")), (String)"appFilePage")) {
                    Object appfileId = this.getView().getFormShowParameter().getCustomParam("appfile");
                    TscMutexHelper.releaseMutex((String)"tso_inductioninfo", (Long)Long.valueOf(String.valueOf(appfileId)), (String)"applyemp");
                }
                this.getView().close();
            }
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("fromPage")), (String)"appFilePage")) {
            QFilter qFilter;
            HRBaseServiceHelper serviceHelper;
            DynamicObject certificateDy;
            this.showOfferHeadInfo();
            this.getModel().setValue("inductionstatus", (Object)InductionStatus.PRE_INDUCTION.getCode());
            Object appfileId = this.getView().getFormShowParameter().getCustomParam("appfile");
            if (appfileId == null) {
                return;
            }
            DynamicObject appfileDy = AppFileHelper.queryOne((long)Long.parseLong(String.valueOf(appfileId)));
            if (HRObjectUtils.isEmpty((Object)appfileDy)) {
                return;
            }
            Long offerId = (Long)this.getView().getFormShowParameter().getCustomParam("offerId");
            this.getModel().setValue("offer", (Object)offerId);
            this.getModel().setValue("id", (Object)ORM.create().genLongId("tso_inductioninfo"));
            this.getModel().setValue("appfile", (Object)appfileDy);
            this.getModel().setValue("candidatename", appfileDy.get("name"));
            this.getModel().setValue("busunit", appfileDy.get("createorg"));
            DynamicObject appResDy = appfileDy.getDynamicObject("appres");
            if (!HRObjectUtils.isEmpty((Object)appResDy)) {
                this.getModel().setValue("candidategender", appResDy.get("gender"));
                this.getModel().setValue("candidateage", appResDy.get("age"));
                this.getModel().setValue("candidatenation", appResDy.get("natreg"));
                this.getModel().setValue("candidateworkage", appResDy.get("workingyears"));
            }
            this.getModel().setValue("highesteducation", appfileDy.get("highesteducation"));
            this.getModel().setValue("schoolname", (Object)appfileDy.getLong("highesteduschool.id"));
            this.getModel().setValue("specialtycategory", appfileDy.get("highestspecialty"));
            this.getModel().setValue("candidatephone", appfileDy.get("phone"));
            this.getModel().setValue("candidateemail", appfileDy.get("email"));
            DynamicObject arfRsmDy = appfileDy.getDynamicObject("arfrsm");
            if (!HRObjectUtils.isEmpty((Object)arfRsmDy) && !HRObjectUtils.isEmpty((Object)(certificateDy = (serviceHelper = new HRBaseServiceHelper("tstpm_srscarfmcertificate")).loadDynamicObject(qFilter = new QFilter("rsm", "=", (Object)arfRsmDy.getLong("id")))))) {
                this.getModel().setValue("credentialstype", certificateDy.get("certtype"));
                this.getModel().setValue("credentialsnumber", certificateDy.get("certnumber"));
            }
            this.getModel().setValue("adminorg", appfileDy.get("adminorg"));
            DynamicObject positionDy = appfileDy.getDynamicObject("position");
            if (!HRObjectUtils.isEmpty((Object)positionDy)) {
                this.getModel().setValue("recruposi", positionDy.get("id"));
                DynamicObject recruSceneDy = positionDy.getDynamicObject("recruscene");
                if (!HRObjectUtils.isEmpty((Object)recruSceneDy)) {
                    this.getModel().setValue("recruscene", recruSceneDy.get("id"));
                }
            }
            this.getModel().setValue("recrutyp", (Object)TSRBDPreDataEnum.RECRUTYP_SOCIALRECRUITMENT.getId());
            this.getModel().getDataEntity(true).set("applicant", (Object)RequestContext.get().getCurrUserId());
            this.getModel().getDataEntity(true).set("applytime", (Object)DateUtils.nowDateTime());
            this.getModel().setValue("name", (Object)(appfileDy.get("name") + OfferMultilingualConstants.getOfferNameSuffix()));
            this.getModel().setValue("number", (Object)CodeRuleServiceHelper.readNumber((String)"tso_inductioninfo", (DynamicObject)this.getModel().getDataEntity(true), null));
            this.getModel().setValue("pperiodterm", (Object)0);
            if (offerId != null && offerId != 0L) {
                DynamicObject offerDy = OfferServiceHelper.getInstance().queryOne((Object)offerId);
                this.getModel().setValue("adminorg", offerDy.get("adminorg"));
                this.getModel().setValue("recruposi", offerDy.get("recruposi"));
                this.getModel().setValue("recruscene", offerDy.get("recruscene"));
                this.getModel().setValue("peadminorg", offerDy.get("peadminorg"));
                this.getModel().setValue("pecompany", offerDy.get("pecompany"));
                this.getModel().setValue("placework", offerDy.get("placework"));
                this.getModel().setValue("postassignmode", offerDy.get("postassignmode"));
                this.getModel().setValue("peposition", offerDy.get("peposition"));
                this.getModel().setValue("pestdposition", offerDy.get("pestdposition"));
                this.getModel().setValue("jobscm", offerDy.get("jobscm"));
                this.getModel().setValue("jobscm", offerDy.get("jobscm"));
                this.getModel().setValue("pejob", offerDy.get("pejob"));
                this.getModel().setValue("jobgrade", offerDy.get("jobgrade"));
                this.getModel().setValue("joblevel", offerDy.get("joblevel"));
                this.getModel().setValue("laborreltypecls", offerDy.get("laborreltypecls"));
                this.getModel().setValue("emprelationtype", offerDy.get("emprelationtype"));
                this.getModel().setValue("positiontype", offerDy.get("positiontype"));
                this.getModel().setValue("depcytype", offerDy.get("depcytype"));
                this.getModel().setValue("supervisor", offerDy.get("supervisor"));
                this.getModel().setValue("pemploymenttime", offerDy.get("pemploymenttime"));
                this.getModel().setValue("ishaveperiodterm", offerDy.get("ishaveperiodterm"));
                this.getModel().setValue("pperiodterm", offerDy.get("pperiodterm"));
                this.getModel().setValue("pperiodtermunit", offerDy.get("pperiodtermunit"));
            }
            this.getModel().setValue("tpsys", appfileDy.get("tpsys"));
        }
    }

    private void handleCancelOperate() {
        MutexHelper.release((IFormView)this.getView());
        IPageCache pageCache = this.getPageCache();
        pageCache.put("fieldSwitchCacheKey", null);
    }

    private void initOtherTabInfo() {
        this.showOfferHeadInfo();
        this.initTpFieldInfo();
    }

    private void initTpFieldInfo() {
        DynamicObject offerObj = this.getModel().getDataEntity(true);
        String sysFieldStr = offerObj.getString("tpsysfield");
        if (StringUtils.isEmpty((CharSequence)sysFieldStr)) {
            return;
        }
        JSONObject sysFieldMap = JSONObject.parseObject((String)sysFieldStr);
        this.getModel().setValue("tppositiondepartment", sysFieldMap.get((Object)"tppositiondepartment"));
        this.getModel().setValue("tppeadminorg", sysFieldMap.get((Object)"tppeadminorg"));
        this.getModel().setValue("tpplacework", sysFieldMap.get((Object)"tpplacework"));
    }

    private void showOfferHeadInfo() {
        OperationStatus pageStatus = this.getPageStatus();
        FormShowParameter headInfoParam = new FormShowParameter();
        headInfoParam.setFormId("tso_inductionhead");
        headInfoParam.getOpenStyle().setTargetKey("infohead");
        headInfoParam.getOpenStyle().setShowType(ShowType.InContainer);
        headInfoParam.setStatus(pageStatus);
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("fromPage")), (String)"appFilePage")) {
            headInfoParam.setCustomParam("busunit.name", this.getView().getFormShowParameter().getCustomParam("busunit.name"));
            headInfoParam.setCustomParam("fromPage", (Object)"appFilePage");
            if (this.getModel().getValue("number") == null || this.getModel().getValue("number") == "") {
                headInfoParam.setCustomParam("number", (Object)CodeRuleServiceHelper.readNumber((String)"tso_inductioninfo", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"tso_inductioninfo"), null));
            } else {
                headInfoParam.setCustomParam("number", this.getModel().getValue("number"));
            }
            this.getView().showForm(headInfoParam);
            return;
        }
        headInfoParam.setCustomParam("id", (Object)this.getInductionId());
        this.getView().showForm(headInfoParam);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    private long getInductionId() {
        long pkId = 0L;
        BillShowParameter offerParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object id = offerParameter.getPkId();
        if (Objects.nonNull(id)) {
            pkId = Long.parseLong(id.toString());
        }
        return pkId;
    }

    private OperationStatus getPageStatus() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus pageStatus = formShowParameter.getStatus();
        if (pageStatus == OperationStatus.EDIT) {
            return pageStatus;
        }
        return OperationStatus.VIEW;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("save") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("fromPage")), (String)"appFilePage")) {
                HRBaseServiceHelper appfileServiceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
                QFilter appFileFilter = new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("appfile.id"));
                DynamicObject appfileDy = appfileServiceHelper.queryOne("id,inductioninfo,filestatus", new QFilter[]{appFileFilter});
                if (!HRObjectUtils.isEmpty((Object)appfileDy) && appfileDy.getLong("inductioninfo_id") == 0L) {
                    appfileDy.set("inductioninfo_id", (Object)this.getModel().getDataEntity().getLong("id"));
                    appfileDy.set("filestatus", (Object)AppFileStatusEnum.TBEMP.getValue());
                    appfileServiceHelper.update(new DynamicObject[]{appfileDy});
                }
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
                return;
            }
            DynamicObject offerObj = InductionFormHelper.Singleton.INSTANCE.getInstance().queryOne(this.getModel().getValue("id"));
            if (offerObj.getBoolean("isdelete")) {
                this.getView().showTipNotification(OfferMultilingualConstants.offerIsDelete());
                return;
            }
            long currUserId = RequestContext.get().getCurrUserId();
            this.getModel().getDataEntity(true).set("applicant", (Object)currUserId);
            InductionServiceHelper.Singleton.INSTANCE.getInstance().updateOne(this.getModel().getDataEntity(true));
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
            MutexHelper.release((IFormView)this.getView());
        }
        if (afterDoOperationEventArgs.getOperateKey().equals("cancel")) {
            MutexHelper.release((IFormView)this.getView());
        }
    }
}

